/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.EnricherDynamicType;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.rebind.BasicEnricherRebindSupport;
import brooklyn.entity.rebind.RebindSupport;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.mementos.EnricherMemento;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherType;
import brooklyn.policy.basic.AbstractEntityAdjunct;
import brooklyn.util.flags.TypeCoercions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;

public abstract class AbstractEnricher
extends AbstractEntityAdjunct
implements Enricher {
    public static final ConfigKey<Boolean> SUPPRESS_DUPLICATES = ConfigKeys.newBooleanConfigKey("enricher.suppressDuplicates", "Whether duplicate values published by this enricher should be suppressed");
    private final EnricherDynamicType enricherType = new EnricherDynamicType(this);
    protected Boolean suppressDuplicates;

    public AbstractEnricher() {
        this(Maps.newLinkedHashMap());
    }

    public AbstractEnricher(Map<?, ?> flags) {
        super((Map)flags);
        if (this.isLegacyConstruction() && !this.isLegacyNoConstructionInit()) {
            this.init();
        }
    }

    public RebindSupport<EnricherMemento> getRebindSupport() {
        return new BasicEnricherRebindSupport(this);
    }

    public EnricherType getEnricherType() {
        return this.enricherType.getSnapshot();
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        Boolean suppressDuplicates = this.getConfig(SUPPRESS_DUPLICATES);
        if (suppressDuplicates != null) {
            this.suppressDuplicates = suppressDuplicates;
        }
    }

    @Override
    protected void onChanged() {
        this.requestPersist();
    }

    @Override
    protected <T> void emit(Sensor<T> sensor, Object val) {
        Preconditions.checkState((this.entity != null ? 1 : 0) != 0, (Object)"entity must first be set");
        if (val == Entities.UNCHANGED) {
            return;
        }
        if (val == Entities.REMOVE) {
            ((EntityInternal)this.entity).removeAttribute((AttributeSensor)sensor);
            return;
        }
        Object newVal = TypeCoercions.coerce(val, sensor.getTypeToken());
        if (sensor instanceof AttributeSensor) {
            Object oldValue;
            if (Boolean.TRUE.equals(this.suppressDuplicates) && Objects.equal((Object)(oldValue = this.entity.getAttribute((AttributeSensor)sensor)), newVal)) {
                return;
            }
            this.entity.setAttribute((AttributeSensor)sensor, newVal);
        } else {
            this.entity.emit(sensor, newVal);
        }
    }
}

