/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.trait.Changeable;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAggregator<T, U>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAggregator.class);
    public static final ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer", "The entity whose children/members will be aggregated");
    public static final ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor");
    public static final ConfigKey<?> DEFAULT_MEMBER_VALUE = ConfigKeys.newConfigKey(Object.class, "enricher.defaultMemberValue");
    public static final ConfigKey<Set<? extends Entity>> FROM_HARDCODED_PRODUCERS = ConfigKeys.newConfigKey(new TypeToken<Set<? extends Entity>>(){}, "enricher.aggregating.fromHardcodedProducers");
    public static final ConfigKey<Boolean> FROM_MEMBERS = ConfigKeys.newBooleanConfigKey("enricher.aggregating.fromMembers");
    public static final ConfigKey<Boolean> FROM_CHILDREN = ConfigKeys.newBooleanConfigKey("enricher.aggregating.fromChildren");
    public static final ConfigKey<Predicate<? super Entity>> ENTITY_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<? super Entity>>(){}, "enricher.aggregating.entityFilter");
    public static final ConfigKey<Predicate<?>> VALUE_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<?>>(){}, "enricher.aggregating.valueFilter");
    protected Entity producer;
    protected Sensor<U> targetSensor;
    protected T defaultMemberValue;
    protected Set<? extends Entity> fromHardcodedProducers;
    protected Boolean fromMembers;
    protected Boolean fromChildren;
    protected Predicate<? super Entity> entityFilter;
    protected Predicate<? super T> valueFilter;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.setEntityLoadingConfig();
        if (this.fromHardcodedProducers == null && this.producer == null) {
            this.producer = entity;
        }
        Preconditions.checkState((boolean)(this.fromHardcodedProducers != null ^ this.producer != null), (String)"must specify one of %s (%s) or %s (%s)", (Object[])new Object[]{PRODUCER.getName(), this.producer, FROM_HARDCODED_PRODUCERS.getName(), this.fromHardcodedProducers});
        Preconditions.checkState((this.producer == null || Boolean.TRUE.equals(this.fromMembers) || Boolean.TRUE.equals(this.fromChildren) ? 1 : 0) != 0, (String)"when specifying producer, must specify at least one of fromMembers (%s) or fromChildren (%s)", (Object[])new Object[]{this.fromMembers, this.fromChildren});
        if (this.fromHardcodedProducers != null) {
            for (Entity producer : Iterables.filter(this.fromHardcodedProducers, this.entityFilter)) {
                this.addProducerHardcoded(producer);
            }
        }
        if (Boolean.TRUE.equals(this.fromMembers)) {
            this.setEntityBeforeSubscribingProducerMemberEvents(entity);
            this.setEntitySubscribeProducerMemberEvents();
            this.setEntityAfterSubscribingProducerMemberEvents();
        }
        if (Boolean.TRUE.equals(this.fromChildren)) {
            this.setEntityBeforeSubscribingProducerChildrenEvents();
            this.setEntitySubscribingProducerChildrenEvents();
            this.setEntityAfterSubscribingProducerChildrenEvents();
        }
        this.onUpdated();
    }

    protected void setEntityLoadingConfig() {
        this.producer = this.getConfig(PRODUCER);
        this.fromHardcodedProducers = this.getConfig(FROM_HARDCODED_PRODUCERS);
        this.defaultMemberValue = this.getConfig(DEFAULT_MEMBER_VALUE);
        this.fromMembers = (Boolean)Maybe.fromNullable((Object)this.getConfig(FROM_MEMBERS)).or((Object)this.fromMembers);
        this.fromChildren = (Boolean)Maybe.fromNullable((Object)this.getConfig(FROM_CHILDREN)).or((Object)this.fromChildren);
        this.entityFilter = this.getConfig(ENTITY_FILTER) == null ? Predicates.alwaysTrue() : this.getConfig(ENTITY_FILTER);
        this.valueFilter = this.getConfig(VALUE_FILTER) == null ? this.getDefaultValueFilter() : this.getConfig(VALUE_FILTER);
        this.setEntityLoadingTargetConfig();
    }

    protected Predicate<?> getDefaultValueFilter() {
        return Predicates.alwaysTrue();
    }

    protected void setEntityLoadingTargetConfig() {
        this.targetSensor = this.getRequiredConfig(TARGET_SENSOR);
    }

    protected void setEntityBeforeSubscribingProducerMemberEvents(EntityLocal entity) {
        Preconditions.checkState((boolean)(this.producer instanceof Group), (String)"must be a group when fromMembers true: producer=%s; entity=%s; hardcodedProducers=%s", (Object[])new Object[]{this.getConfig(PRODUCER), entity, this.fromHardcodedProducers});
    }

    protected void setEntitySubscribeProducerMemberEvents() {
        this.subscribe(this.producer, Changeable.MEMBER_ADDED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                if (AbstractAggregator.this.entityFilter.apply(event.getValue())) {
                    AbstractAggregator.this.addProducerMember((Entity)event.getValue());
                    AbstractAggregator.this.onUpdated();
                }
            }
        });
        this.subscribe(this.producer, Changeable.MEMBER_REMOVED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                AbstractAggregator.this.removeProducer((Entity)event.getValue());
                AbstractAggregator.this.onUpdated();
            }
        });
    }

    protected void setEntityAfterSubscribingProducerMemberEvents() {
        if (this.producer instanceof Group) {
            for (Entity member : Iterables.filter((Iterable)((Group)this.producer).getMembers(), this.entityFilter)) {
                this.addProducerMember(member);
            }
        }
    }

    protected void setEntityBeforeSubscribingProducerChildrenEvents() {
    }

    protected void setEntitySubscribingProducerChildrenEvents() {
        this.subscribe(this.producer, AbstractEntity.CHILD_REMOVED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                AbstractAggregator.this.removeProducer((Entity)event.getValue());
                AbstractAggregator.this.onUpdated();
            }
        });
        this.subscribe(this.producer, AbstractEntity.CHILD_ADDED, new SensorEventListener<Entity>(){

            public void onEvent(SensorEvent<Entity> event) {
                if (AbstractAggregator.this.entityFilter.apply(event.getValue())) {
                    AbstractAggregator.this.addProducerChild((Entity)event.getValue());
                    AbstractAggregator.this.onUpdated();
                }
            }
        });
    }

    protected void setEntityAfterSubscribingProducerChildrenEvents() {
        for (Entity child : Iterables.filter((Iterable)this.producer.getChildren(), this.entityFilter)) {
            this.addProducerChild(child);
        }
    }

    protected abstract void addProducerHardcoded(Entity var1);

    protected abstract void addProducerMember(Entity var1);

    protected abstract void addProducerChild(Entity var1);

    protected void removeProducer(Entity producer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} stopped listening to {}", new Object[]{this, producer});
        }
        this.unsubscribe(producer);
        this.onProducerRemoved(producer);
    }

    protected abstract void onProducerAdded(Entity var1);

    protected abstract void onProducerRemoved(Entity var1);

    protected void onUpdated() {
        try {
            this.emit(this.targetSensor, this.compute());
        }
        catch (Throwable t) {
            LOG.warn("Error calculating and setting aggregate for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    protected abstract Object compute();
}

