/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.trait.Changeable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.util.GroovyJavaMethods;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAggregatingEnricher<S, T>
extends AbstractEnricher
implements SensorEventListener<S> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAggregatingEnricher.class);
    AttributeSensor<? extends S> source;
    protected AttributeSensor<T> target;
    protected S defaultValue;
    Set<Entity> producers;
    List<Entity> hardCodedProducers;
    boolean allMembers;
    Predicate<Entity> filter;
    protected final Map<Entity, S> values = Collections.synchronizedMap(new LinkedHashMap());

    public AbstractAggregatingEnricher(Map<String, ?> flags, AttributeSensor<? extends S> source, AttributeSensor<T> target) {
        this(flags, source, target, null);
    }

    public AbstractAggregatingEnricher(Map<String, ?> flags, AttributeSensor<? extends S> source, AttributeSensor<T> target, S defaultValue) {
        super(flags);
        this.source = source;
        this.target = target;
        this.defaultValue = defaultValue;
        this.hardCodedProducers = flags.containsKey("producers") ? flags.get("producers") : Collections.emptyList();
        this.allMembers = (Boolean)(flags.containsKey("allMembers") ? flags.get("allMembers") : Boolean.valueOf(false));
        this.filter = flags.containsKey("filter") ? GroovyJavaMethods.castToPredicate(flags.get("filter")) : Predicates.alwaysTrue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProducer(Entity producer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} linked ({}, {}) to {}", new Object[]{this, producer, this.source, this.target});
        }
        this.subscribe(producer, this.source, this);
        Map<Entity, S> map = this.values;
        synchronized (map) {
            S vo = this.values.get(producer);
            if (vo == null) {
                Object initialVal = ((EntityLocal)producer).getAttribute(this.source);
                this.values.put(producer, initialVal != null ? initialVal : this.defaultValue);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} already had value ({}) for producer ({}); but that producer has just been added", new Object[]{this, vo, producer});
            }
        }
        this.onUpdated();
    }

    public S removeProducer(Entity producer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} unlinked ({}, {}) from {}", new Object[]{this, producer, this.source, this.target});
        }
        this.unsubscribe(producer);
        S removed = this.values.remove(producer);
        this.onUpdated();
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SensorEvent<S> event) {
        Entity e = event.getSource();
        Map<Entity, S> map = this.values;
        synchronized (map) {
            if (this.values.containsKey(e)) {
                this.values.put(e, event.getValue());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} received event for unknown producer ({}); presumably that producer has recently been removed", (Object)this, (Object)e);
            }
        }
        this.onUpdated();
    }

    protected void onUpdated() {
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        for (Entity producer : this.hardCodedProducers) {
            if (!this.filter.apply((Object)producer)) continue;
            this.addProducer(producer);
        }
        if (this.allMembers) {
            this.subscribe((Entity)entity, Changeable.MEMBER_ADDED, new SensorEventListener<Entity>(){

                public void onEvent(SensorEvent<Entity> it) {
                    if (AbstractAggregatingEnricher.this.filter.apply(it.getValue())) {
                        AbstractAggregatingEnricher.this.addProducer((Entity)it.getValue());
                    }
                }
            });
            this.subscribe((Entity)entity, Changeable.MEMBER_REMOVED, new SensorEventListener<Entity>(){

                public void onEvent(SensorEvent<Entity> it) {
                    AbstractAggregatingEnricher.this.removeProducer((Entity)it.getValue());
                }
            });
            if (entity instanceof Group) {
                for (Entity member : ((Group)entity).getMembers()) {
                    if (!this.filter.apply((Object)member)) continue;
                    this.addProducer(member);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Entity, S> copyOfValues() {
        Map<Entity, S> map = this.values;
        synchronized (map) {
            return ImmutableMap.copyOf(this.values);
        }
    }
}

