/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher;

import brooklyn.enricher.basic.AbstractAggregatingEnricher;
import brooklyn.event.AttributeSensor;
import brooklyn.event.SensorEventListener;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.flags.TypeCoercions;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.reflect.TypeToken;
import groovy.lang.Closure;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomAggregatingEnricher<S, T>
extends AbstractAggregatingEnricher<S, T>
implements SensorEventListener<S> {
    private static final Logger LOG = LoggerFactory.getLogger(CustomAggregatingEnricher.class);
    protected final Function<Collection<S>, T> aggregator;

    public CustomAggregatingEnricher(Map<String, ?> flags, AttributeSensor<? extends S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator, S defaultIniitalValueForUnreportedSensors) {
        super(flags, source, target, defaultIniitalValueForUnreportedSensors);
        this.aggregator = aggregator;
    }

    public CustomAggregatingEnricher(Map<String, ?> flags, AttributeSensor<? extends S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator) {
        this(flags, source, target, aggregator, null);
    }

    public CustomAggregatingEnricher(AttributeSensor<? extends S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator, S defaultValue) {
        this((Map<String, ?>)Collections.emptyMap(), source, target, (Function<Collection<? extends S>, T>)aggregator, (S)defaultValue);
    }

    public CustomAggregatingEnricher(AttributeSensor<? extends S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator) {
        this(Collections.emptyMap(), source, target, aggregator, null);
    }

    public CustomAggregatingEnricher(Map<String, ?> flags, AttributeSensor<? extends S> source, AttributeSensor<T> target, Closure<?> aggregator, S defaultValueForUnreportedSensors) {
        this(flags, source, target, (Function<Collection<? extends S>, T>)GroovyJavaMethods.functionFromClosure(aggregator), (S)defaultValueForUnreportedSensors);
    }

    public CustomAggregatingEnricher(Map<String, ?> flags, AttributeSensor<? extends S> source, AttributeSensor<T> target, Closure<?> aggregator) {
        this(flags, source, target, aggregator, null);
    }

    public CustomAggregatingEnricher(AttributeSensor<S> source, AttributeSensor<T> target, Closure<?> aggregator, S defaultValueForUnreportedSensors) {
        this(Collections.emptyMap(), source, target, aggregator, defaultValueForUnreportedSensors);
    }

    public CustomAggregatingEnricher(AttributeSensor<S> source, AttributeSensor<T> target, Closure<?> aggregator) {
        this(Collections.emptyMap(), source, target, aggregator, null);
    }

    @Override
    public void onUpdated() {
        try {
            this.entity.setAttribute(this.target, this.getAggregate());
        }
        catch (Throwable t) {
            LOG.warn("Error calculating and setting aggregate for enricher " + this, t);
            throw Throwables.propagate((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getAggregate() {
        Map map = this.values;
        synchronized (map) {
            return (T)this.aggregator.apply(this.values.values());
        }
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(Map<String, ?> flags, AttributeSensor<S> source, AttributeSensor<T> target, Closure<?> aggregator, S defaultVal) {
        return new CustomAggregatingEnricher<S, T>(flags, source, target, aggregator, defaultVal);
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(Map<String, ?> flags, AttributeSensor<S> source, AttributeSensor<T> target, Closure<?> aggregator) {
        return CustomAggregatingEnricher.newEnricher(flags, source, target, aggregator, null);
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(AttributeSensor<S> source, AttributeSensor<T> target, Closure<?> aggregator, S defaultVal) {
        return CustomAggregatingEnricher.newEnricher(Collections.emptyMap(), source, target, aggregator, defaultVal);
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(AttributeSensor<S> source, AttributeSensor<T> target, Closure<?> aggregator) {
        return CustomAggregatingEnricher.newEnricher(Collections.emptyMap(), source, target, aggregator, null);
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(Map<String, ?> flags, AttributeSensor<S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator, S defaultVal) {
        return new CustomAggregatingEnricher<S, T>(flags, source, target, aggregator, defaultVal);
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(Map<String, ?> flags, AttributeSensor<S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator) {
        return CustomAggregatingEnricher.newEnricher(flags, source, target, aggregator, null);
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(AttributeSensor<S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator, S defaultVal) {
        return CustomAggregatingEnricher.newEnricher(Collections.emptyMap(), source, target, aggregator, defaultVal);
    }

    public static <S, T> CustomAggregatingEnricher<S, T> newEnricher(AttributeSensor<S> source, AttributeSensor<T> target, Function<Collection<S>, T> aggregator) {
        return CustomAggregatingEnricher.newEnricher(Collections.emptyMap(), source, target, aggregator, null);
    }

    public static <N extends Number, T extends Number> CustomAggregatingEnricher<N, T> newSummingEnricher(Map<String, ?> flags, AttributeSensor<N> source, final AttributeSensor<T> target, final N defaultValueForUnreportedSensors, final T valueToReportIfNoSensors) {
        Function aggregator = new Function<Collection<N>, T>(){

            public T apply(Collection<N> vals) {
                return CustomAggregatingEnricher.sum(vals, defaultValueForUnreportedSensors, valueToReportIfNoSensors, target.getTypeToken());
            }
        };
        return new CustomAggregatingEnricher<N, T>(flags, source, target, aggregator, defaultValueForUnreportedSensors);
    }

    public static <N extends Number> CustomAggregatingEnricher<N, N> newSummingEnricher(AttributeSensor<N> source, AttributeSensor<N> target) {
        return CustomAggregatingEnricher.newSummingEnricher(Collections.emptyMap(), source, target, null, null);
    }

    public static <N extends Number> CustomAggregatingEnricher<N, Double> newAveragingEnricher(Map<String, ?> flags, AttributeSensor<? extends N> source, AttributeSensor<Double> target, final N defaultValueForUnreportedSensors, final Double valueToReportIfNoSensors) {
        Function aggregator = new Function<Collection<N>, Double>(){

            public Double apply(Collection<N> vals) {
                int count = CustomAggregatingEnricher.count(vals, defaultValueForUnreportedSensors != null);
                return count == 0 ? valueToReportIfNoSensors : Double.valueOf((Double)CustomAggregatingEnricher.sum(vals, defaultValueForUnreportedSensors, 0, TypeToken.of(Double.class)) / (double)count);
            }
        };
        return new CustomAggregatingEnricher<N, Double>(flags, source, target, aggregator, defaultValueForUnreportedSensors);
    }

    public static <N extends Number> CustomAggregatingEnricher<N, Double> newAveragingEnricher(AttributeSensor<N> source, AttributeSensor<Double> target) {
        return CustomAggregatingEnricher.newAveragingEnricher(Collections.emptyMap(), source, target, null, null);
    }

    private static <N extends Number> N cast(Number n, TypeToken<? extends N> numberType) {
        return (N)((Number)TypeCoercions.castPrimitive(n, numberType.getRawType()));
    }

    private static <N extends Number> N sum(Iterable<? extends Number> vals, Number valueIfNull, Number valueIfNone, TypeToken<N> type) {
        double result = 0.0;
        int count = 0;
        if (vals != null) {
            for (Number number : vals) {
                if (number != null) {
                    result += number.doubleValue();
                    ++count;
                    continue;
                }
                if (valueIfNull == null) continue;
                result += valueIfNull.doubleValue();
                ++count;
            }
        }
        if (count == 0) {
            return CustomAggregatingEnricher.cast(valueIfNone, type);
        }
        return CustomAggregatingEnricher.cast(result, type);
    }

    private static int count(Iterable<? extends Object> vals, boolean includeNullValues) {
        int result = 0;
        if (vals != null) {
            for (Object object : vals) {
                if (object == null && !includeNullValues) continue;
                ++result;
            }
        }
        return result;
    }
}

