/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.config.internal;

import brooklyn.config.ConfigKey;
import brooklyn.config.ConfigMap;
import brooklyn.entity.basic.ConfigMapViewWithStringKeys;
import brooklyn.event.basic.StructuredConfigKey;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.task.DeferredSupplier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigMapImpl
implements ConfigMap {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigMapImpl.class);
    protected final ConfigMapViewWithStringKeys mapViewWithStringKeys = new ConfigMapViewWithStringKeys(this);
    protected Map<ConfigKey<?>, Object> ownConfig = Collections.synchronizedMap(new LinkedHashMap());

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.getConfig(key, null);
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return (T)this.getConfig(key.getConfigKey(), null);
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key, T defaultValue) {
        return (T)this.getConfig(key.getConfigKey(), defaultValue);
    }

    @Deprecated
    public Object getRawConfig(ConfigKey<?> key) {
        return this.getConfigRaw(key, true).orNull();
    }

    protected Object coerceConfigVal(ConfigKey<?> key, Object v) {
        Object val;
        if (v instanceof Future || v instanceof DeferredSupplier) {
            val = v;
        } else if (key instanceof StructuredConfigKey) {
            val = v;
        } else if ((v instanceof Map || v instanceof Iterable) && key.getType().isInstance(v)) {
            val = v;
        } else {
            try {
                val = TypeCoercions.coerce(v, key.getTypeToken());
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot coerce or set " + v + " to " + key, e);
            }
        }
        return val;
    }

    public Map<String, Object> asMapWithStringKeys() {
        return this.mapViewWithStringKeys;
    }

    public int size() {
        return this.ownConfig.size();
    }

    public boolean isEmpty() {
        return this.ownConfig.isEmpty();
    }
}

