/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.config;

import brooklyn.config.ConfigKey;
import brooklyn.util.text.WildcardGlobs;
import com.google.common.base.Predicate;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class ConfigPredicates {
    public static Predicate<ConfigKey<?>> startingWith(final String prefix) {
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && input.getName().startsWith(prefix);
            }
        };
    }

    public static Predicate<ConfigKey<?>> matchingGlob(final String glob) {
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && WildcardGlobs.isGlobMatched((String)glob, (String)input.getName());
            }
        };
    }

    public static Predicate<ConfigKey<?>> matchingRegex(String regex) {
        final Pattern p = Pattern.compile(regex);
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && p.matcher(input.getName()).matches();
            }
        };
    }

    public static Predicate<ConfigKey<?>> nameMatching(final Predicate<String> filter) {
        return new Predicate<ConfigKey<?>>(){

            public boolean apply(@Nullable ConfigKey<?> input) {
                return input != null && filter.apply((Object)input.getName());
            }
        };
    }
}

