/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.config;

import brooklyn.config.ConfigKey;
import brooklyn.config.StringConfigMap;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.os.Os;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import groovy.lang.Closure;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynProperties
extends LinkedHashMap
implements StringConfigMap {
    private static final long serialVersionUID = -945875483083108978L;
    private static final Logger LOG = LoggerFactory.getLogger(BrooklynProperties.class);

    protected BrooklynProperties() {
    }

    public BrooklynProperties addEnvironmentVars() {
        this.addFrom(System.getenv());
        return this;
    }

    public BrooklynProperties addSystemProperties() {
        this.addFrom(System.getProperties());
        return this;
    }

    public BrooklynProperties addFrom(ConfigBag cfg) {
        this.addFrom(cfg.getAllConfig());
        return this;
    }

    public BrooklynProperties addFrom(Map map) {
        this.putAll(Maps.transformValues((Map)map, (Function)StringFunctions.trim()));
        return this;
    }

    public BrooklynProperties addFrom(InputStream i) {
        Properties p = new Properties(){

            @Override
            public synchronized Object put(Object key, Object value) {
                String s = (String)value;
                s = Strings.isBlank((CharSequence)s) ? "" : CharMatcher.BREAKING_WHITESPACE.trimFrom((CharSequence)s);
                return BrooklynProperties.this.put(key, s);
            }
        };
        try {
            p.load(i);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return this;
    }

    public BrooklynProperties addFrom(File f) {
        if (!f.exists()) {
            LOG.warn("Unable to find file '" + f.getAbsolutePath() + "' when loading properties; ignoring");
            return this;
        }
        try {
            return this.addFrom(new FileInputStream(f));
        }
        catch (FileNotFoundException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public BrooklynProperties addFrom(URL u) {
        try {
            return this.addFrom(u.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading properties from " + u + ": " + e, e);
        }
    }

    public BrooklynProperties addFromUrl(String url) {
        try {
            if (url == null) {
                return this;
            }
            return this.addFrom(ResourceUtils.create(this).getResourceFromUrl(url));
        }
        catch (Exception e) {
            throw new RuntimeException("Error reading properties from " + url + ": " + e, e);
        }
    }

    public BrooklynProperties addFromUrlProperty(String urlProperty) {
        String url = (String)this.get(urlProperty);
        if (url == null) {
            this.addFromUrl(url);
        }
        return this;
    }

    public BrooklynProperties addFromMap(Map properties) {
        this.putAll(properties);
        return this;
    }

    @Override
    public boolean putIfAbsent(String key, Object value) {
        if (this.containsKey(key)) {
            return false;
        }
        this.put(key, value);
        return true;
    }

    @Deprecated
    public String get(Map flags, String key) {
        LOG.warn("Discouraged use of 'BrooklynProperties.get(Map,String)' (ambiguous); use getFirst(Map,String) or get(String) -- assuming the former");
        LOG.debug("Trace for discouraged use of 'BrooklynProperties.get(Map,String)'", new Throwable("Arguments: " + flags + " " + key));
        return this.getFirst(flags, key);
    }

    public String getFirst(String ... keys) {
        return this.getFirst((Map)MutableMap.of(), keys);
    }

    public String getFirst(Map flags, String ... keys) {
        for (String k : keys) {
            if (k == null || !this.containsKey(k)) continue;
            return (String)this.get(k);
        }
        if (flags.get("warnIfNone") != null && !Boolean.FALSE.equals(flags.get("warnIfNone"))) {
            if (Boolean.TRUE.equals(flags.get("warnIfNone"))) {
                LOG.warn("Unable to find Brooklyn property " + keys);
            } else {
                LOG.warn("" + flags.get("warnIfNone"));
            }
        }
        if (flags.get("failIfNone") != null && !Boolean.FALSE.equals(flags.get("failIfNone"))) {
            Object f = flags.get("failIfNone");
            if (f instanceof Closure) {
                ((Closure)f).call((Object[])keys);
            }
            if (Boolean.TRUE.equals(f)) {
                throw new NoSuchElementException("Brooklyn unable to find mandatory property " + keys[0] + (keys.length > 1 ? " (or " + (keys.length - 1) + " other possible names, full list is " + Arrays.asList(keys) + ")" : ""));
            }
            throw new NoSuchElementException("" + f);
        }
        if (flags.get("defaultIfNone") != null) {
            return (String)flags.get("defaultIfNone");
        }
        return null;
    }

    @Override
    public String toString() {
        return "BrooklynProperties[" + this.size() + "]";
    }

    @Override
    public Object put(Object key, Object value) {
        if (key instanceof ConfigKey.HasConfigKey) {
            key = ((ConfigKey.HasConfigKey)key).getConfigKey().getName();
        }
        if (key instanceof ConfigKey) {
            key = ((ConfigKey)key).getName();
        }
        return super.put(key, value);
    }

    @Override
    public void putAll(Map vals) {
        for (Map.Entry entry : vals.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public <T> Object put(ConfigKey.HasConfigKey<T> key, T value) {
        return super.put(key.getConfigKey().getName(), value);
    }

    @Override
    public <T> Object put(ConfigKey<T> key, T value) {
        return super.put(key.getName(), value);
    }

    @Override
    public <T> boolean putIfAbsent(ConfigKey<T> key, T value) {
        return this.putIfAbsent(key.getName(), value);
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return this.getConfig(key, null);
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return this.getConfig(key.getConfigKey(), null);
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key, T defaultValue) {
        return this.getConfig(key.getConfigKey(), defaultValue);
    }

    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        if (!this.containsKey(key.getName())) {
            if (defaultValue != null) {
                return defaultValue;
            }
            return (T)key.getDefaultValue();
        }
        Object value = this.get(key.getName());
        if (value == null) {
            return null;
        }
        return TypeCoercions.coerce(value, key.getTypeToken());
    }

    public Object getRawConfig(ConfigKey<?> key) {
        return this.get(key.getName());
    }

    public Maybe<Object> getConfigRaw(ConfigKey<?> key, boolean includeInherited) {
        if (this.containsKey(key.getName())) {
            return Maybe.of(this.get(key.getName()));
        }
        return Maybe.absent();
    }

    public Map<ConfigKey<?>, Object> getAllConfig() {
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : this.entrySet()) {
            result.put(new BasicConfigKey<Object>(Object.class, "" + entry.getKey()), entry.getValue());
        }
        return result;
    }

    public BrooklynProperties submap(Predicate<ConfigKey<?>> filter) {
        BrooklynProperties result = Factory.newEmpty();
        for (Map.Entry entry : this.entrySet()) {
            BasicConfigKey<Object> k = new BasicConfigKey<Object>(Object.class, "" + entry.getKey());
            if (!filter.apply(k)) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public Map<String, Object> asMapWithStringKeys() {
        return this;
    }

    public static class Factory {
        public static BrooklynProperties newEmpty() {
            return new BrooklynProperties();
        }

        public static BrooklynProperties newDefault() {
            return new Builder(true).build();
        }

        public static Builder builderDefault() {
            return new Builder(true);
        }

        public static Builder builderEmpty() {
            return new Builder(true);
        }

        private static void addPropertiesFromUrl(BrooklynProperties p, String url, boolean warnIfNotFound) {
            block4: {
                if (url == null) {
                    return;
                }
                try {
                    p.addFrom(ResourceUtils.create(BrooklynProperties.class).getResourceFromUrl(url));
                }
                catch (Exception e) {
                    if (warnIfNotFound) {
                        LOG.warn("Could not load {}; continuing", (Object)url);
                    }
                    if (!LOG.isTraceEnabled()) break block4;
                    LOG.trace("Could not load " + url + "; continuing", (Throwable)e);
                }
            }
        }

        private static void addPropertiesFromFile(BrooklynProperties p, String file) {
            if (file == null) {
                return;
            }
            String fileTidied = Os.tidyPath((String)file);
            File f = new File(fileTidied);
            if (f.exists()) {
                p.addFrom(f);
            }
        }

        public static class Builder {
            private String defaultLocationMetadataUrl;
            private String globalLocationMetadataFile = null;
            private String globalPropertiesFile = null;
            private String localPropertiesFile = null;
            private BrooklynProperties originalProperties = null;

            public Builder() {
                this(true);
            }

            private Builder(boolean setGlobalFileDefaults) {
                this.resetDefaultLocationMetadataUrl();
                if (setGlobalFileDefaults) {
                    this.resetGlobalFiles();
                }
            }

            public Builder resetDefaultLocationMetadataUrl() {
                this.defaultLocationMetadataUrl = "classpath://brooklyn/location-metadata.properties";
                return this;
            }

            public Builder resetGlobalFiles() {
                this.defaultLocationMetadataUrl = "classpath://brooklyn/location-metadata.properties";
                this.globalLocationMetadataFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "location-metadata.properties"});
                this.globalPropertiesFile = Os.mergePaths((String[])new String[]{Os.home(), ".brooklyn", "brooklyn.properties"});
                return this;
            }

            private Builder(BrooklynProperties originalProperties) {
                this.originalProperties = new BrooklynProperties().addFromMap(originalProperties);
            }

            public Builder defaultLocationMetadataUrl(String val) {
                this.defaultLocationMetadataUrl = (String)Preconditions.checkNotNull((Object)val, (Object)"file");
                return this;
            }

            public Builder globalLocationMetadataFile(String val) {
                this.globalLocationMetadataFile = (String)Preconditions.checkNotNull((Object)val, (Object)"file");
                return this;
            }

            public Builder globalPropertiesFile(String val) {
                this.globalPropertiesFile = val;
                return this;
            }

            @Beta
            public boolean hasDelegateOriginalProperties() {
                return this.originalProperties == null;
            }

            public Builder localPropertiesFile(String val) {
                this.localPropertiesFile = val;
                return this;
            }

            public BrooklynProperties build() {
                if (this.originalProperties != null) {
                    return new BrooklynProperties().addFromMap(this.originalProperties);
                }
                BrooklynProperties properties = new BrooklynProperties();
                Factory.addPropertiesFromUrl(properties, this.defaultLocationMetadataUrl, false);
                Factory.addPropertiesFromFile(properties, this.globalLocationMetadataFile);
                Factory.addPropertiesFromFile(properties, this.globalPropertiesFile);
                Factory.addPropertiesFromFile(properties, this.localPropertiesFile);
                properties.addEnvironmentVars();
                properties.addSystemProperties();
                return properties;
            }

            public static Builder fromProperties(BrooklynProperties brooklynProperties) {
                return new Builder(brooklynProperties);
            }

            public String toString() {
                return Objects.toStringHelper((Object)this).omitNullValues().add("originalProperties", (Object)this.originalProperties).add("defaultLocationMetadataUrl", (Object)this.defaultLocationMetadataUrl).add("globalLocationMetadataUrl", (Object)this.globalLocationMetadataFile).add("globalPropertiesFile", (Object)this.globalPropertiesFile).add("localPropertiesFile", (Object)this.localPropertiesFile).toString();
            }
        }
    }
}

