/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.BasicBrooklynCatalog;
import brooklyn.config.BrooklynLogging;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.classloading.BrooklynClassLoadingContextSequential;
import brooklyn.management.classloading.JavaBrooklynClassLoadingContext;
import brooklyn.management.classloading.OsgiBrooklynClassLoadingContext;
import brooklyn.management.ha.OsgiManager;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Time;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Stopwatch;
import java.util.Collection;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogUtils {
    private static final Logger log = LoggerFactory.getLogger(CatalogUtils.class);
    public static final char VERSION_DELIMITER = ':';

    public static BrooklynClassLoadingContext newClassLoadingContext(ManagementContext mgmt, CatalogItem<?, ?> item) {
        if (item.getLibraries() == null) {
            log.debug("CatalogItemDtoAbstract.getLibraries() is null.", (Throwable)new Exception("Trace for null CatalogItemDtoAbstract.getLibraries()"));
        }
        return CatalogUtils.newClassLoadingContext(mgmt, item.getId(), item.getLibraries());
    }

    public static BrooklynClassLoadingContext getClassLoadingContext(Entity entity) {
        ManagementContext mgmt = ((EntityInternal)entity).getManagementContext();
        String catId = entity.getCatalogItemId();
        if (Strings.isBlank((CharSequence)catId)) {
            return JavaBrooklynClassLoadingContext.create(mgmt);
        }
        CatalogItem<?, ?> cat = CatalogUtils.getCatalogItemOptionalVersion(mgmt, catId);
        if (cat == null) {
            log.warn("Cannot load " + catId + " to get classloader for " + entity + "; will try with standard loader, but might fail subsequently");
            return JavaBrooklynClassLoadingContext.create(mgmt);
        }
        return CatalogUtils.newClassLoadingContext(mgmt, cat);
    }

    public static BrooklynClassLoadingContext newClassLoadingContext(@Nullable ManagementContext mgmt, String catalogItemId, Collection<CatalogItem.CatalogBundle> libraries) {
        BrooklynClassLoadingContext loader;
        BrooklynClassLoadingContextSequential result = new BrooklynClassLoadingContextSequential(mgmt, new BrooklynClassLoadingContext[0]);
        if (libraries != null && !libraries.isEmpty()) {
            result.add(new OsgiBrooklynClassLoadingContext(mgmt, catalogItemId, libraries));
        }
        if ((loader = BasicBrooklynCatalog.BrooklynLoaderTracker.getLoader()) != null) {
            result.add(loader);
        }
        result.addSecondary(JavaBrooklynClassLoadingContext.create(mgmt));
        return result;
    }

    @Deprecated
    public static BrooklynClassLoadingContext newClassLoadingContext(@Nullable ManagementContext mgmt, String catalogItemId, Collection<CatalogItem.CatalogBundle> libraries, ClassLoader customClassLoader) {
        BrooklynClassLoadingContext loader;
        BrooklynClassLoadingContextSequential result = new BrooklynClassLoadingContextSequential(mgmt, new BrooklynClassLoadingContext[0]);
        if (libraries != null && !libraries.isEmpty()) {
            result.add(new OsgiBrooklynClassLoadingContext(mgmt, catalogItemId, libraries));
        }
        if ((loader = BasicBrooklynCatalog.BrooklynLoaderTracker.getLoader()) != null) {
            result.add(loader);
        }
        result.addSecondary(JavaBrooklynClassLoadingContext.create(mgmt, customClassLoader));
        return result;
    }

    public static void installLibraries(ManagementContext managementContext, @Nullable Collection<CatalogItem.CatalogBundle> libraries) {
        if (libraries == null) {
            return;
        }
        ManagementContextInternal mgmt = (ManagementContextInternal)managementContext;
        if (!libraries.isEmpty()) {
            Maybe<OsgiManager> osgi = mgmt.getOsgiManager();
            if (osgi.isAbsent()) {
                throw new IllegalStateException("Unable to load bundles " + libraries + " because OSGi is not running.");
            }
            if (log.isDebugEnabled()) {
                CatalogUtils.logDebugOrTraceIfRebinding(log, "Loading bundles in {}: {}", managementContext, Joiner.on((String)", ").join(libraries));
            }
            Stopwatch timer = Stopwatch.createStarted();
            for (CatalogItem.CatalogBundle bundleUrl : libraries) {
                ((OsgiManager)osgi.get()).registerBundle(bundleUrl);
            }
            if (log.isDebugEnabled()) {
                CatalogUtils.logDebugOrTraceIfRebinding(log, "Registered {} bundles in {}", libraries.size(), Time.makeTimeStringRounded((Stopwatch)timer));
            }
        }
    }

    public static String getCatalogItemIdFromLoader(BrooklynClassLoadingContext loader) {
        if (loader instanceof OsgiBrooklynClassLoadingContext) {
            return ((OsgiBrooklynClassLoadingContext)loader).getCatalogItemId();
        }
        return null;
    }

    public static void setCatalogItemIdOnAddition(Entity entity, BrooklynObject itemBeingAdded) {
        if (entity.getCatalogItemId() != null) {
            if (itemBeingAdded.getCatalogItemId() == null) {
                if (log.isDebugEnabled()) {
                    BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly(entity), "Catalog item addition: " + entity + " from " + entity.getCatalogItemId() + " applying its catalog item ID to " + itemBeingAdded, new Object[0]);
                }
                ((BrooklynObjectInternal)itemBeingAdded).setCatalogItemId(entity.getCatalogItemId());
            } else if (!itemBeingAdded.getCatalogItemId().equals(entity.getCatalogItemId())) {
                log.debug("Cross-catalog item detected: " + entity + " from " + entity.getCatalogItemId() + " has " + itemBeingAdded + " from " + itemBeingAdded.getCatalogItemId());
            }
        } else if (itemBeingAdded.getCatalogItemId() != null && log.isDebugEnabled()) {
            BrooklynLogging.log(log, BrooklynLogging.levelDebugOrTraceIfReadOnly(entity), "Catalog item addition: " + entity + " without catalog item ID has " + itemBeingAdded + " from " + itemBeingAdded.getCatalogItemId(), new Object[0]);
        }
    }

    @Beta
    public static void logDebugOrTraceIfRebinding(Logger log, String message, Object ... args) {
        if (RebindManagerImpl.RebindTracker.isRebinding()) {
            log.trace(message, args);
        } else {
            log.debug(message, args);
        }
    }

    public static boolean looksLikeVersionedId(String versionedId) {
        if (versionedId == null) {
            return false;
        }
        int fi = versionedId.indexOf(58);
        if (fi < 0) {
            return false;
        }
        int li = versionedId.lastIndexOf(58);
        if (li != fi) {
            return false;
        }
        String candidateVersion = versionedId.substring(li + 1);
        return candidateVersion.matches("[0-9]+(|(\\.|_).*)");
    }

    public static String getIdFromVersionedId(String versionedId) {
        if (versionedId == null) {
            return null;
        }
        int versionDelimiterPos = versionedId.lastIndexOf(58);
        if (versionDelimiterPos != -1) {
            return versionedId.substring(0, versionDelimiterPos);
        }
        return null;
    }

    public static String getVersionFromVersionedId(String versionedId) {
        if (versionedId == null) {
            return null;
        }
        int versionDelimiterPos = versionedId.lastIndexOf(58);
        if (versionDelimiterPos != -1) {
            return versionedId.substring(versionDelimiterPos + 1);
        }
        return null;
    }

    public static String getVersionedId(String id, String version) {
        return id + ':' + version;
    }

    public static CatalogItem<?, ?> getCatalogItemOptionalVersion(ManagementContext mgmt, String versionedId) {
        if (versionedId == null) {
            return null;
        }
        if (CatalogUtils.looksLikeVersionedId(versionedId)) {
            String id = CatalogUtils.getIdFromVersionedId(versionedId);
            String version = CatalogUtils.getVersionFromVersionedId(versionedId);
            return mgmt.getCatalog().getCatalogItem(id, version);
        }
        return mgmt.getCatalog().getCatalogItem(versionedId, "0.0.0_DEFAULT_VERSION");
    }

    public static boolean isBestVersion(ManagementContext mgmt, CatalogItem<?, ?> item) {
        CatalogItem<?, ?> bestVersion = CatalogUtils.getCatalogItemOptionalVersion(mgmt, item.getSymbolicName());
        if (bestVersion == null) {
            return false;
        }
        return bestVersion.getVersion().equals(item.getVersion());
    }

    public static <T, SpecT> CatalogItem<T, SpecT> getCatalogItemOptionalVersion(ManagementContext mgmt, Class<T> type, String versionedId) {
        if (CatalogUtils.looksLikeVersionedId(versionedId)) {
            String id = CatalogUtils.getIdFromVersionedId(versionedId);
            String version = CatalogUtils.getVersionFromVersionedId(versionedId);
            return mgmt.getCatalog().getCatalogItem(type, id, version);
        }
        return mgmt.getCatalog().getCatalogItem(type, versionedId, "0.0.0_DEFAULT_VERSION");
    }
}

