/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.basic.AbstractBrooklynObject;
import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogBundleDto;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.catalog.internal.CatalogXmlSerializer;
import brooklyn.config.ConfigKey;
import brooklyn.entity.rebind.BasicCatalogItemRebindSupport;
import brooklyn.entity.rebind.RebindSupport;
import brooklyn.mementos.CatalogItemMemento;
import brooklyn.util.collections.MutableList;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CatalogItemDtoAbstract<T, SpecT>
extends AbstractBrooklynObject
implements CatalogItem<T, SpecT> {
    private static Logger LOG = LoggerFactory.getLogger(CatalogItemDtoAbstract.class);
    @SetFromFlag
    private String symbolicName;
    @SetFromFlag
    private String version = "0.0.0.SNAPSHOT";
    @SetFromFlag
    private String displayName;
    @SetFromFlag
    private String description;
    @SetFromFlag
    private String iconUrl;
    @SetFromFlag
    private String javaType;
    @Deprecated
    @SetFromFlag
    private String type;
    @SetFromFlag
    private String planYaml;
    @SetFromFlag
    private Collection<CatalogItem.CatalogBundle> libraries;
    @SetFromFlag
    private Set<Object> tags = Sets.newLinkedHashSet();
    @SetFromFlag
    private boolean deprecated;
    transient CatalogXmlSerializer serializer;

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        throw new UnsupportedOperationException();
    }

    public <U> U setConfig(ConfigKey<U> key, U val) {
        return (U)this.config().set(key, val);
    }

    @Override
    public String getId() {
        return this.getCatalogItemId();
    }

    @Override
    public String getCatalogItemId() {
        return CatalogUtils.getVersionedId(this.getSymbolicName(), this.getVersion());
    }

    public String getJavaType() {
        if (this.javaType != null) {
            return this.javaType;
        }
        return this.type;
    }

    @Deprecated
    public String getName() {
        return this.getDisplayName();
    }

    @Deprecated
    public String getRegisteredTypeName() {
        return this.getSymbolicName();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public String getIconUrl() {
        return this.iconUrl;
    }

    public String getSymbolicName() {
        if (this.symbolicName != null) {
            return this.symbolicName;
        }
        return this.getJavaType();
    }

    public String getVersion() {
        if (this.version != null) {
            return this.version;
        }
        return "0.0.0.SNAPSHOT";
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.deprecated = deprecated;
    }

    @Nonnull
    public Collection<CatalogItem.CatalogBundle> getLibraries() {
        if (this.libraries != null) {
            return ImmutableList.copyOf(this.libraries);
        }
        return Collections.emptyList();
    }

    @Nullable
    public String getPlanYaml() {
        return this.planYaml;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.planYaml, this.javaType, CatalogItemDtoAbstract.nullIfEmpty(this.libraries), this.version, this.getCatalogItemId()});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogItemDtoAbstract other = (CatalogItemDtoAbstract)obj;
        if (!Objects.equal((Object)this.symbolicName, (Object)other.symbolicName)) {
            return false;
        }
        if (!Objects.equal((Object)this.planYaml, (Object)other.planYaml)) {
            return false;
        }
        if (!Objects.equal((Object)this.javaType, (Object)other.javaType)) {
            return false;
        }
        if (!Objects.equal(CatalogItemDtoAbstract.nullIfEmpty(this.libraries), CatalogItemDtoAbstract.nullIfEmpty(other.libraries))) {
            return false;
        }
        if (!Objects.equal((Object)this.getCatalogItemId(), (Object)other.getCatalogItemId())) {
            return false;
        }
        if (!Objects.equal((Object)this.version, (Object)other.version)) {
            return false;
        }
        if (!Objects.equal((Object)this.deprecated, (Object)other.deprecated)) {
            return false;
        }
        if (!Objects.equal((Object)this.description, (Object)other.description)) {
            return false;
        }
        if (!Objects.equal((Object)this.displayName, (Object)other.displayName)) {
            return false;
        }
        if (!Objects.equal((Object)this.iconUrl, (Object)other.iconUrl)) {
            return false;
        }
        return Objects.equal(this.tags, other.tags);
    }

    private static <T> Collection<T> nullIfEmpty(Collection<T> coll) {
        if (coll == null || coll.isEmpty()) {
            return null;
        }
        return coll;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getId() + "/" + this.getDisplayName() + "]";
    }

    public abstract Class<SpecT> getSpecType();

    public String toXmlString() {
        if (this.serializer == null) {
            this.loadSerializer();
        }
        return this.serializer.toString(this);
    }

    private synchronized void loadSerializer() {
        if (this.serializer == null) {
            this.serializer = new CatalogXmlSerializer();
        }
    }

    public RebindSupport<CatalogItemMemento> getRebindSupport() {
        return new BasicCatalogItemRebindSupport(this);
    }

    @Override
    public void setDisplayName(String newName) {
        this.displayName = newName;
    }

    @Override
    protected AbstractBrooklynObject configure(Map<?, ?> flags) {
        FlagUtils.setFieldsFromFlags(flags, this);
        return this;
    }

    @Override
    public BrooklynObject.TagSupport tags() {
        return new BasicTagSupport();
    }

    @Override
    @Deprecated
    public void setCatalogItemId(String id) {
    }

    protected void setSymbolicName(String symbolicName) {
        this.symbolicName = symbolicName;
    }

    protected void setVersion(String version) {
        this.version = version;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    protected void setIconUrl(String iconUrl) {
        this.iconUrl = iconUrl;
    }

    protected void setJavaType(String javaType) {
        this.javaType = javaType;
        this.type = null;
    }

    protected void setPlanYaml(String planYaml) {
        this.planYaml = planYaml;
    }

    protected void setLibraries(Collection<CatalogItem.CatalogBundle> libraries) {
        this.libraries = libraries;
    }

    protected void setTags(Set<Object> tags) {
        this.tags = tags;
    }

    protected void setSerializer(CatalogXmlSerializer serializer) {
        this.serializer = serializer;
    }

    public static Collection<CatalogItem.CatalogBundle> parseLibraries(Collection<?> possibleLibraries) {
        MutableList dto = MutableList.of();
        for (Object object : possibleLibraries) {
            String url;
            String version;
            String name;
            if (object instanceof Map) {
                Map entry = (Map)object;
                name = CatalogItemDtoAbstract.stringValOrNull(entry, "name");
                version = CatalogItemDtoAbstract.stringValOrNull(entry, "version");
                url = CatalogItemDtoAbstract.stringValOrNull(entry, "url");
                dto.add(new CatalogBundleDto(name, version, url));
                continue;
            }
            if (object instanceof String) {
                String inlineRef = (String)object;
                if (inlineRef.contains("/") || inlineRef.contains("\\")) {
                    name = null;
                    version = null;
                    url = inlineRef;
                } else if (CatalogUtils.looksLikeVersionedId(inlineRef)) {
                    name = CatalogUtils.getIdFromVersionedId(inlineRef);
                    version = CatalogUtils.getVersionFromVersionedId(inlineRef);
                    url = null;
                } else {
                    name = null;
                    version = null;
                    url = inlineRef;
                }
                dto.add(new CatalogBundleDto(name, version, url));
                continue;
            }
            LOG.debug("Unexpected entry in libraries list neither string nor map: " + object);
        }
        return dto;
    }

    private static String stringValOrNull(Map<?, ?> map, String key) {
        Object val = map.get(key);
        return val != null ? String.valueOf(val) : null;
    }

    private class BasicTagSupport
    implements BrooklynObject.TagSupport {
        private BasicTagSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setTagsIfNull() {
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                if (CatalogItemDtoAbstract.this.tags == null) {
                    CatalogItemDtoAbstract.this.tags = Sets.newLinkedHashSet();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nonnull
        public Set<Object> getTags() {
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                return ImmutableSet.copyOf((Collection)CatalogItemDtoAbstract.this.tags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsTag(Object tag) {
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                return CatalogItemDtoAbstract.this.tags.contains(tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTag(Object tag) {
            boolean result;
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                result = CatalogItemDtoAbstract.this.tags.add(tag);
            }
            CatalogItemDtoAbstract.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTags(Iterable<?> newTags) {
            boolean result;
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                result = Iterables.addAll((Collection)CatalogItemDtoAbstract.this.tags, newTags);
            }
            CatalogItemDtoAbstract.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeTag(Object tag) {
            boolean result;
            CatalogItemDtoAbstract catalogItemDtoAbstract = CatalogItemDtoAbstract.this;
            synchronized (catalogItemDtoAbstract) {
                this.setTagsIfNull();
                result = CatalogItemDtoAbstract.this.tags.remove(tag);
            }
            CatalogItemDtoAbstract.this.onTagsChanged();
            return result;
        }
    }
}

