/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogDo;
import brooklyn.catalog.internal.CatalogItemDtoAbstract;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.config.ConfigKey;
import brooklyn.entity.rebind.RebindSupport;
import brooklyn.management.ManagementContext;
import brooklyn.mementos.CatalogItemMemento;
import com.google.common.base.Preconditions;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CatalogItemDo<T, SpecT>
implements CatalogItem<T, SpecT>,
BrooklynObjectInternal {
    protected final CatalogDo catalog;
    protected final CatalogItemDtoAbstract<T, SpecT> itemDto;
    protected volatile Class<T> javaClass;

    public CatalogItemDo(CatalogDo catalog, CatalogItem<T, SpecT> itemDto) {
        this.catalog = (CatalogDo)Preconditions.checkNotNull((Object)catalog, (Object)"catalog");
        this.itemDto = (CatalogItemDtoAbstract)Preconditions.checkNotNull(itemDto, (Object)"itemDto");
    }

    public CatalogItem<T, SpecT> getDto() {
        return this.itemDto;
    }

    @Override
    public BrooklynObjectInternal.ConfigurationSupportInternal config() {
        throw new UnsupportedOperationException();
    }

    public <U> U setConfig(ConfigKey<U> key, U val) {
        return (U)this.config().set(key, val);
    }

    public CatalogItem.CatalogItemType getCatalogItemType() {
        return this.itemDto.getCatalogItemType();
    }

    public Class<T> getCatalogItemJavaType() {
        return this.itemDto.getCatalogItemJavaType();
    }

    public String getId() {
        return this.itemDto.getId();
    }

    public String getCatalogItemId() {
        return this.itemDto.getCatalogItemId();
    }

    public void setDeprecated(boolean deprecated) {
        this.itemDto.setDeprecated(deprecated);
    }

    public boolean isDeprecated() {
        return this.itemDto.isDeprecated();
    }

    @Override
    public void setCatalogItemId(String id) {
        this.itemDto.setCatalogItemId(id);
    }

    public String getJavaType() {
        return this.itemDto.getJavaType();
    }

    @Deprecated
    public String getName() {
        return this.getDisplayName();
    }

    @Deprecated
    public String getRegisteredTypeName() {
        return this.getSymbolicName();
    }

    public String getDisplayName() {
        return this.itemDto.getDisplayName();
    }

    public BrooklynObject.TagSupport tags() {
        return this.itemDto.tags();
    }

    @Deprecated
    public BrooklynObject.TagSupport getTagSupport() {
        return this.tags();
    }

    public String getDescription() {
        return this.itemDto.getDescription();
    }

    public String getIconUrl() {
        return this.itemDto.getIconUrl();
    }

    public String getSymbolicName() {
        return this.itemDto.getSymbolicName();
    }

    public String getVersion() {
        return this.itemDto.getVersion();
    }

    @Nonnull
    public Collection<CatalogItem.CatalogBundle> getLibraries() {
        return this.itemDto.getLibraries();
    }

    @Deprecated
    public Class<T> getJavaClass() {
        if (this.javaClass == null) {
            this.loadJavaClass(null);
        }
        return this.javaClass;
    }

    Class<? extends T> loadJavaClass(ManagementContext mgmt) {
        if (this.javaClass != null) {
            return this.javaClass;
        }
        this.javaClass = CatalogUtils.newClassLoadingContext(mgmt, this.getId(), this.getLibraries(), this.catalog.getRootClassLoader()).loadClass(this.getJavaType());
        return this.javaClass;
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "[" + this.itemDto + "]";
    }

    public String toXmlString() {
        return this.itemDto.toXmlString();
    }

    public Class<SpecT> getSpecType() {
        return this.itemDto.getSpecType();
    }

    @Nullable
    public String getPlanYaml() {
        return this.itemDto.getPlanYaml();
    }

    public RebindSupport<CatalogItemMemento> getRebindSupport() {
        return this.itemDto.getRebindSupport();
    }
}

