/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.catalog.CatalogItem;
import brooklyn.util.text.NaturalOrderComparator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;

public class CatalogItemComparator<T, SpecT>
implements Comparator<CatalogItem<T, SpecT>> {
    private static final String SNAPSHOT = "SNAPSHOT";
    public static final CatalogItemComparator<?, ?> INSTANCE = new CatalogItemComparator();

    public static <T, SpecT> CatalogItemComparator<T, SpecT> getInstance() {
        return INSTANCE;
    }

    @Override
    public int compare(CatalogItem<T, SpecT> o1, CatalogItem<T, SpecT> o2) {
        boolean isV2Snapshot;
        int symbolicNameComparison = o1.getSymbolicName().compareTo(o2.getSymbolicName());
        if (symbolicNameComparison != 0) {
            return symbolicNameComparison;
        }
        String v1 = o1.getVersion();
        String v2 = o2.getVersion();
        boolean isV1Snapshot = v1.toUpperCase().contains(SNAPSHOT);
        if (isV1Snapshot == (isV2Snapshot = v2.toUpperCase().contains(SNAPSHOT))) {
            String[] v1Parts = this.split(v1);
            String[] v2Parts = this.split(v2);
            return -this.compare(v1Parts, v2Parts);
        }
        if (isV1Snapshot) {
            return 1;
        }
        return -1;
    }

    private String[] split(String v) {
        String part;
        int delimPos;
        ArrayList<String> parts = new ArrayList<String>();
        int startPos = 0;
        while ((delimPos = v.indexOf(46, startPos)) != -1 && this.parse(part = v.substring(startPos, delimPos)) != -1) {
            parts.add(part);
            startPos = delimPos + 1;
        }
        String remaining = v.substring(startPos);
        parts.addAll(Arrays.asList(remaining.split("[^\\d]", 2)));
        return parts.toArray(new String[parts.size()]);
    }

    @Override
    private int compare(String[] v1Parts, String[] v2Parts) {
        int len = Math.max(v1Parts.length, v2Parts.length);
        for (int i = 0; i < len; ++i) {
            if (i == v1Parts.length) {
                return this.isNumber(v2Parts[i]) ? -1 : 1;
            }
            if (i == v2Parts.length) {
                return this.isNumber(v1Parts[i]) ? 1 : -1;
            }
            String p1 = v1Parts[i];
            String p2 = v2Parts[i];
            int n1 = this.parse(p1);
            int n2 = this.parse(p2);
            if (n1 != -1 && n2 != -1) {
                if (n1 == n2) continue;
                return this.compare(n1, n2);
            }
            if (n1 == -1 && n2 != -1) {
                return -1;
            }
            if (n1 != -1 && n2 == -1) {
                return 1;
            }
            int cmp = NaturalOrderComparator.INSTANCE.compare(p1, p2);
            if (cmp < 0) {
                return -1;
            }
            if (cmp <= 0) continue;
            return 1;
        }
        return 0;
    }

    private boolean isNumber(String v) {
        return this.parse(v) != -1;
    }

    @Override
    private int compare(int n1, int n2) {
        if (n1 == n2) {
            return 0;
        }
        if (n1 < n2) {
            return -1;
        }
        return 1;
    }

    private int parse(String p) {
        try {
            return Integer.parseInt(p);
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }
}

