/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogEntityItemDto;
import brooklyn.catalog.internal.CatalogItemDtoAbstract;
import brooklyn.catalog.internal.CatalogLocationItemDto;
import brooklyn.catalog.internal.CatalogPolicyItemDto;
import brooklyn.catalog.internal.CatalogTemplateItemDto;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;

public class CatalogItemBuilder<CatalogItemType extends CatalogItemDtoAbstract<?, ?>> {
    private CatalogItemType dto;

    public static CatalogItemBuilder<CatalogEntityItemDto> newEntity(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogEntityItemDto>(new CatalogEntityItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogTemplateItemDto> newTemplate(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogTemplateItemDto>(new CatalogTemplateItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogPolicyItemDto> newPolicy(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogPolicyItemDto>(new CatalogPolicyItemDto()).symbolicName(symbolicName).version(version);
    }

    public static CatalogItemBuilder<CatalogLocationItemDto> newLocation(String symbolicName, String version) {
        return new CatalogItemBuilder<CatalogLocationItemDto>(new CatalogLocationItemDto()).symbolicName(symbolicName).version(version);
    }

    public CatalogItemBuilder(CatalogItemType dto) {
        this.dto = dto;
        ((CatalogItemDtoAbstract)this.dto).setLibraries(Collections.<CatalogItem.CatalogBundle>emptyList());
    }

    public CatalogItemBuilder<CatalogItemType> symbolicName(String symbolicName) {
        ((CatalogItemDtoAbstract)this.dto).setSymbolicName(symbolicName);
        return this;
    }

    @Deprecated
    public CatalogItemBuilder<CatalogItemType> javaType(String javaType) {
        ((CatalogItemDtoAbstract)this.dto).setJavaType(javaType);
        return this;
    }

    @Deprecated
    public CatalogItemBuilder<CatalogItemType> name(String name) {
        return this.displayName(name);
    }

    public CatalogItemBuilder<CatalogItemType> displayName(String displayName) {
        ((CatalogItemDtoAbstract)this.dto).setDisplayName(displayName);
        return this;
    }

    public CatalogItemBuilder<CatalogItemType> description(String description) {
        ((CatalogItemDtoAbstract)this.dto).setDescription(description);
        return this;
    }

    public CatalogItemBuilder<CatalogItemType> iconUrl(String iconUrl) {
        ((CatalogItemDtoAbstract)this.dto).setIconUrl(iconUrl);
        return this;
    }

    public CatalogItemBuilder<CatalogItemType> version(String version) {
        ((CatalogItemDtoAbstract)this.dto).setVersion(version);
        return this;
    }

    public CatalogItemBuilder<CatalogItemType> deprecated(boolean deprecated) {
        ((CatalogItemDtoAbstract)this.dto).setDeprecated(deprecated);
        return this;
    }

    public CatalogItemBuilder<CatalogItemType> libraries(Collection<CatalogItem.CatalogBundle> libraries) {
        ((CatalogItemDtoAbstract)this.dto).setLibraries(libraries);
        return this;
    }

    public CatalogItemBuilder<CatalogItemType> plan(String yaml) {
        ((CatalogItemDtoAbstract)this.dto).setPlanYaml(yaml);
        return this;
    }

    public CatalogItemType build() {
        Preconditions.checkNotNull((Object)((CatalogItemDtoAbstract)this.dto).getSymbolicName());
        Preconditions.checkNotNull((Object)((CatalogItemDtoAbstract)this.dto).getVersion());
        if (((CatalogItemDtoAbstract)this.dto).getLibraries() == null) {
            ((CatalogItemDtoAbstract)this.dto).setLibraries(Collections.<CatalogItem.CatalogBundle>emptyList());
        }
        CatalogItemType ret = this.dto;
        this.dto = null;
        return ret;
    }
}

