/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.CatalogLoadMode;
import brooklyn.catalog.internal.BasicBrooklynCatalog;
import brooklyn.catalog.internal.CatalogDto;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.management.ManagementContext;
import brooklyn.management.ManagementContextInjectable;
import brooklyn.management.ha.ManagementNodeState;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableList;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.FatalRuntimeException;
import brooklyn.util.exceptions.RuntimeInterruptedException;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.os.Os;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CatalogInitialization
implements ManagementContextInjectable {
    private static final Logger log = LoggerFactory.getLogger(CatalogInitialization.class);
    private String initialUri;
    private boolean reset;
    private String additionsUri;
    private boolean force;
    private boolean disallowLocal = false;
    private List<Function<CatalogInitialization, Void>> callbacks = MutableList.of();
    private boolean hasRunUnofficialInitialization = false;
    private boolean hasRunTransientOfficialInitialization = false;
    private boolean hasRunFinalInitialization = false;
    private boolean isPopulating = false;
    private ManagementContext managementContext;
    private boolean isStartingUp = false;
    private boolean failOnStartupErrors = false;
    private Object populatingCatalogMutex = new Object();
    boolean hasRunAdditions = false;
    private Object setFromCLMMutex = new Object();
    private boolean setFromCatalogLoadMode = false;

    public CatalogInitialization(String initialUri, boolean reset, String additionUri, boolean force) {
        this.initialUri = initialUri;
        this.reset = reset;
        this.additionsUri = additionUri;
        this.force = force;
    }

    public CatalogInitialization() {
        this(null, false, null, false);
    }

    @Override
    public void injectManagementContext(ManagementContext managementContext) {
        Preconditions.checkNotNull((Object)managementContext, (Object)"management context");
        if (this.managementContext != null && managementContext != this.managementContext) {
            throw new IllegalStateException("Cannot switch management context, from " + this.managementContext + " to " + managementContext);
        }
        this.managementContext = managementContext;
    }

    public void setStartingUp(boolean isStartingUp) {
        this.isStartingUp = isStartingUp;
    }

    public void setFailOnStartupErrors(boolean startupFailOnCatalogErrors) {
        this.failOnStartupErrors = startupFailOnCatalogErrors;
    }

    public CatalogInitialization addPopulationCallback(Function<CatalogInitialization, Void> callback) {
        this.callbacks.add(callback);
        return this;
    }

    public ManagementContext getManagementContext() {
        return (ManagementContext)Preconditions.checkNotNull((Object)this.managementContext, (Object)("management context has not been injected into " + this));
    }

    public boolean isInitialResetRequested() {
        return this.reset;
    }

    public boolean hasRunFinalInitialization() {
        return this.hasRunFinalInitialization;
    }

    public boolean hasRunOfficialInitialization() {
        return this.hasRunFinalInitialization || this.hasRunTransientOfficialInitialization;
    }

    public boolean hasRunAnyInitialization() {
        return this.hasRunFinalInitialization || this.hasRunTransientOfficialInitialization || this.hasRunUnofficialInitialization;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateCatalog(ManagementNodeState nodeState, boolean needsInitialItemsLoaded, boolean needsAdditionsLoaded, Collection<CatalogItem<?, ?>> optionalExcplicitItemsForResettingCatalog) {
        if (log.isDebugEnabled()) {
            String message = "Populating catalog for " + nodeState + ", needsInitial=" + needsInitialItemsLoaded + ", needsAdditional=" + needsAdditionsLoaded + ", explicitItems=" + (optionalExcplicitItemsForResettingCatalog == null ? "null" : Integer.valueOf(optionalExcplicitItemsForResettingCatalog.size())) + "; from " + JavaClassNames.callerNiceClassAndMethod((int)1);
            if (!ManagementNodeState.isHotProxy((ManagementNodeState)nodeState)) {
                log.debug(message);
            } else {
                log.trace(message);
            }
        }
        Object object = this.populatingCatalogMutex;
        synchronized (object) {
            try {
                if (this.hasRunFinalInitialization() && (needsInitialItemsLoaded || needsAdditionsLoaded)) {
                    log.warn("Catalog initialization called to populate initial, even though it has already run the final official initialization");
                }
                this.isPopulating = true;
                BasicBrooklynCatalog catalog = (BasicBrooklynCatalog)this.managementContext.getCatalog();
                if (!catalog.getCatalog().isLoaded()) {
                    catalog.load();
                } else if (needsInitialItemsLoaded && this.hasRunAnyInitialization()) {
                    if (this.hasRunTransientOfficialInitialization) {
                        log.debug("Catalog initialization now populating, but has noted a previous official run which was not final (probalby loaded while in a standby mode, or a previous run failed); overwriting any items installed earlier");
                    } else {
                        log.warn("Catalog initialization now populating, but has noted a previous unofficial run (it may have been an early web request); overwriting any items installed earlier");
                    }
                    catalog.reset((Collection<CatalogItem<?, ?>>)ImmutableList.of());
                }
                this.populateCatalogImpl(catalog, needsInitialItemsLoaded, needsAdditionsLoaded, optionalExcplicitItemsForResettingCatalog);
                if (nodeState == ManagementNodeState.MASTER) {
                    this.hasRunFinalInitialization = true;
                }
            }
            finally {
                if (!this.hasRunFinalInitialization) {
                    this.hasRunTransientOfficialInitialization = true;
                }
                this.isPopulating = false;
            }
        }
    }

    private void populateCatalogImpl(BasicBrooklynCatalog catalog, boolean needsInitialItemsLoaded, boolean needsAdditionsLoaded, Collection<CatalogItem<?, ?>> optionalItemsForResettingCatalog) {
        this.applyCatalogLoadMode();
        if (optionalItemsForResettingCatalog != null) {
            catalog.reset(optionalItemsForResettingCatalog);
        }
        if (needsInitialItemsLoaded) {
            this.populateInitial(catalog);
        }
        if (needsAdditionsLoaded) {
            this.populateAdditions(catalog);
            this.populateViaCallbacks(catalog);
        }
    }

    protected void populateInitial(BasicBrooklynCatalog catalog) {
        if (this.disallowLocal) {
            if (!this.hasRunFinalInitialization()) {
                log.debug("CLI initial catalog not being read when local catalog load mode is disallowed.");
            }
            return;
        }
        if (this.initialUri != null) {
            this.populateInitialFromUri(catalog, this.initialUri, PopulateMode.AUTODETECT);
            return;
        }
        String catalogUrl = (String)this.managementContext.getConfig().getConfig(BrooklynServerConfig.BROOKLYN_CATALOG_URL);
        if (Strings.isNonBlank((CharSequence)catalogUrl)) {
            this.populateInitialFromUri(catalog, catalogUrl, PopulateMode.AUTODETECT);
            return;
        }
        catalogUrl = Os.mergePaths((String[])new String[]{BrooklynServerConfig.getMgmtBaseDir(this.managementContext.getConfig()), "catalog.bom"});
        if (new File(catalogUrl).exists()) {
            this.populateInitialFromUri(catalog, new File(catalogUrl).toURI().toString(), PopulateMode.YAML);
            return;
        }
        catalogUrl = Os.mergePaths((String[])new String[]{BrooklynServerConfig.getMgmtBaseDir(this.managementContext.getConfig()), "catalog.xml"});
        if (new File(catalogUrl).exists()) {
            this.populateInitialFromUri(catalog, new File(catalogUrl).toURI().toString(), PopulateMode.XML);
            return;
        }
        catalogUrl = "classpath:/brooklyn/default.catalog.bom";
        if (new ResourceUtils(this).doesUrlExist(catalogUrl)) {
            this.populateInitialFromUri(catalog, catalogUrl, PopulateMode.YAML);
            return;
        }
        log.info("No catalog found on classpath or specified; catalog will not be initialized.");
    }

    private void populateInitialFromUri(BasicBrooklynCatalog catalog, String catalogUrl, PopulateMode mode) {
        Iterable result;
        Exception problem;
        block12: {
            String contents;
            block11: {
                block10: {
                    log.debug("Loading initial catalog from {}", (Object)catalogUrl);
                    problem = null;
                    result = null;
                    contents = null;
                    try {
                        contents = new ResourceUtils(this).getResourceAsString(catalogUrl);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        if (problem != null) break block10;
                        problem = e;
                    }
                }
                if (contents != null && (mode == PopulateMode.YAML || mode == PopulateMode.AUTODETECT)) {
                    try {
                        catalog.reset((Collection<CatalogItem<?, ?>>)MutableList.of());
                        result = catalog.addItems(contents);
                    }
                    catch (Exception e) {
                        Exceptions.propagateIfFatal((Throwable)e);
                        if (problem != null) break block11;
                        problem = e;
                    }
                }
            }
            if (result == null && contents != null && (mode == PopulateMode.XML || mode == PopulateMode.AUTODETECT)) {
                try {
                    this.populateInitialFromUriXml(catalog, catalogUrl, contents);
                    problem = null;
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    if (problem != null) break block12;
                    problem = e;
                }
            }
        }
        if (result != null) {
            log.debug("Loaded initial catalog from {}: {}", (Object)catalogUrl, result);
        }
        if (problem != null) {
            log.warn("Error importing catalog from " + catalogUrl + ": " + problem, (Throwable)problem);
        }
    }

    private void populateInitialFromUriXml(BasicBrooklynCatalog catalog, String catalogUrl, String contents) {
        CatalogDto dto = CatalogDto.newDtoFromXmlContents(contents, catalogUrl);
        if (dto != null) {
            catalog.reset(dto);
        }
    }

    protected void populateAdditions(BasicBrooklynCatalog catalog) {
        if (Strings.isNonBlank((CharSequence)this.additionsUri)) {
            if (this.disallowLocal) {
                if (!this.hasRunAdditions) {
                    log.warn("CLI additions supplied but not supported when catalog load mode disallows local loads; ignoring.");
                }
                return;
            }
            if (!this.hasRunAdditions) {
                log.debug("Adding to catalog from CLI: " + this.additionsUri + " (force: " + this.force + ")");
            }
            Iterable items = catalog.addItems(new ResourceUtils(this).getResourceAsString(this.additionsUri), this.force);
            if (!this.hasRunAdditions) {
                log.debug("Added to catalog from CLI: " + items);
            } else {
                log.debug("Added to catalog from CLI: count " + Iterables.size((Iterable)items));
            }
            this.hasRunAdditions = true;
        }
    }

    protected void populateViaCallbacks(BasicBrooklynCatalog catalog) {
        for (Function<CatalogInitialization, Void> callback : this.callbacks) {
            callback.apply((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void applyCatalogLoadMode() {
        Object object = this.setFromCLMMutex;
        synchronized (object) {
            if (this.setFromCatalogLoadMode) {
                return;
            }
            this.setFromCatalogLoadMode = true;
            Maybe clmm = ((ManagementContextInternal)this.managementContext).getConfig().getConfigRaw(BrooklynServerConfig.CATALOG_LOAD_MODE, false);
            if (clmm.isAbsent()) {
                return;
            }
            CatalogLoadMode clm = TypeCoercions.coerce(clmm.get(), CatalogLoadMode.class);
            log.warn("Legacy CatalogLoadMode " + (Object)((Object)clm) + " set: applying, but this should be changed to use new CLI --catalogXxx commands");
            switch (clm) {
                case LOAD_BROOKLYN_CATALOG_URL: {
                    this.reset = true;
                    break;
                }
                case LOAD_BROOKLYN_CATALOG_URL_IF_NO_PERSISTED_STATE: {
                    break;
                }
                case LOAD_PERSISTED_STATE: {
                    this.disallowLocal = true;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateUnofficial(BasicBrooklynCatalog catalog) {
        Object object = this.populatingCatalogMutex;
        synchronized (object) {
            if (this.hasRunAnyInitialization() || this.isPopulating) {
                return;
            }
            log.debug("Populating catalog unofficially (" + catalog + ")");
            this.isPopulating = true;
            try {
                if (this.isStartingUp) {
                    log.warn("Catalog access requested when not yet initialized; populating best effort rather than through recommended pathway. Catalog data may be replaced subsequently.");
                }
                this.populateCatalogImpl(catalog, true, true, null);
            }
            finally {
                this.hasRunUnofficialInitialization = true;
                this.isPopulating = false;
            }
        }
    }

    public void handleException(Throwable throwable, Object details) {
        if (throwable instanceof InterruptedException) {
            throw new RuntimeInterruptedException((InterruptedException)throwable);
        }
        if (throwable instanceof RuntimeInterruptedException) {
            throw (RuntimeInterruptedException)throwable;
        }
        log.error("Error loading catalog item '" + details + "': " + throwable);
        log.debug("Trace for error loading catalog item '" + details + "': " + throwable, throwable);
        ((ManagementContextInternal)this.getManagementContext()).errors().add(throwable);
        if (this.isStartingUp && this.failOnStartupErrors) {
            throw new FatalRuntimeException("Unable to load catalog item '" + details + "': " + throwable, throwable);
        }
    }

    private static enum PopulateMode {
        YAML,
        XML,
        AUTODETECT;

    }
}

