/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.catalog.internal.CatalogClasspathDo;
import brooklyn.catalog.internal.CatalogDto;
import brooklyn.catalog.internal.CatalogXmlSerializer;
import brooklyn.util.ResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogDtoUtils {
    private static final Logger log = LoggerFactory.getLogger(CatalogDtoUtils.class);

    public static CatalogDto newDefaultLocalScanningDto(CatalogClasspathDo.CatalogScanningModes scanMode) {
        return CatalogDto.newDefaultLocalScanningDto(scanMode);
    }

    public static void populateFromUrl(CatalogDto dto, String url) {
        CatalogDto remoteDto = CatalogDtoUtils.newDtoFromUrl(url);
        try {
            CatalogDtoUtils.copyDto(remoteDto, dto, true);
        }
        catch (Exception e) {
            Exceptions.propagate((Throwable)e);
        }
    }

    static void copyDto(CatalogDto source, CatalogDto target, boolean skipNulls) throws IllegalArgumentException, IllegalAccessException {
        target.copyFrom(source, skipNulls);
    }

    public static CatalogDto newDtoFromUrl(String url) {
        if (log.isDebugEnabled()) {
            log.debug("Retrieving catalog from: {}", (Object)url);
        }
        try {
            InputStream source = ResourceUtils.create().getResourceFromUrl(url);
            CatalogDto result = (CatalogDto)new CatalogXmlSerializer().deserialize(new InputStreamReader(source));
            if (log.isDebugEnabled()) {
                log.debug("Retrieved catalog from: {}", (Object)url);
            }
            return result;
        }
        catch (Throwable t) {
            log.debug("Unable to retrieve catalog from: " + url + " (" + t + ")");
            throw Exceptions.propagate((Throwable)t);
        }
    }
}

