/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogClasspathDo;
import brooklyn.catalog.internal.CatalogClasspathDto;
import brooklyn.catalog.internal.CatalogDo;
import brooklyn.catalog.internal.CatalogItemDtoAbstract;
import brooklyn.catalog.internal.CatalogXmlSerializer;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.PropagatedRuntimeException;
import brooklyn.util.stream.Streams;
import com.google.common.annotations.Beta;
import com.google.common.base.Objects;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.InputStream;
import java.io.StringReader;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CatalogDto {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogDto.class);
    String id;
    String url;
    String contents;
    String contentsDescription;
    String name;
    String description;
    CatalogClasspathDto classpath;
    private List<CatalogItemDtoAbstract<?, ?>> entries = null;
    List<CatalogDto> catalogs = null;

    public static CatalogDto newDefaultLocalScanningDto(CatalogClasspathDo.CatalogScanningModes scanMode) {
        CatalogDo result = new CatalogDo(CatalogDto.newNamedInstance("Local Scanned Catalog", "All annotated Brooklyn entities detected in the default classpath", "scanning-local-classpath"));
        result.setClasspathScanForEntities(scanMode);
        return result.dto;
    }

    @Deprecated
    public static CatalogDto newDtoFromUrl(String url) {
        return CatalogDto.newDtoFromXmlUrl(url);
    }

    @Deprecated
    public static CatalogDto newDtoFromXmlUrl(String url) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieving catalog from: {}", (Object)url);
        }
        try {
            InputStream source = ResourceUtils.create().getResourceFromUrl(url);
            String contents = Streams.readFullyString((InputStream)source);
            return CatalogDto.newDtoFromXmlContents(contents, url);
        }
        catch (Throwable t) {
            Exceptions.propagateIfFatal((Throwable)t);
            throw new PropagatedRuntimeException("Unable to retrieve catalog from " + url + ": " + t, t);
        }
    }

    @Deprecated
    public static CatalogDto newDtoFromXmlContents(String xmlContents, String originDescription) {
        CatalogDto result = (CatalogDto)new CatalogXmlSerializer().deserialize(new StringReader(xmlContents));
        result.contentsDescription = originDescription;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Retrieved catalog from: {}", (Object)originDescription);
        }
        return result;
    }

    public static CatalogDto newNamedInstance(String name, String description, String optionalContentsDescription) {
        CatalogDto result = new CatalogDto();
        result.name = name;
        result.description = description;
        if (optionalContentsDescription != null) {
            result.contentsDescription = optionalContentsDescription;
        }
        return result;
    }

    public static CatalogDto newEmptyInstance(String optionalContentsDescription) {
        CatalogDto result = new CatalogDto();
        if (optionalContentsDescription != null) {
            result.contentsDescription = optionalContentsDescription;
        }
        return result;
    }

    public static CatalogDto newLinkedInstance(String url) {
        CatalogDto result = new CatalogDto();
        result.contentsDescription = url;
        result.contents = ResourceUtils.create().getResourceAsString(url);
        return result;
    }

    @Deprecated
    public static CatalogDto newDtoFromCatalogItems(Collection<CatalogItem<?, ?>> entries) {
        return CatalogDto.newDtoFromCatalogItems(entries, null);
    }

    public static CatalogDto newDtoFromCatalogItems(Collection<CatalogItem<?, ?>> entries, String description) {
        CatalogDto result = new CatalogDto();
        result.contentsDescription = description;
        result.entries = (List)FluentIterable.from(entries).filter(CatalogItemDtoAbstract.class).copyInto((Collection)Lists.newArrayListWithExpectedSize((int)entries.size()));
        return result;
    }

    void populate() {
        if (this.contents == null) {
            if (this.url != null) {
                this.contents = ResourceUtils.create().getResourceAsString(this.url);
                this.contentsDescription = this.url;
            } else {
                if (this.contentsDescription == null) {
                    LOG.debug("Catalog DTO has no contents and no description; ignoring call to populate it. Description should be set to suppress this message.");
                    return;
                }
                LOG.trace("Nothing needs doing (no contents or URL) for catalog with contents described as " + this.contentsDescription + ".");
                return;
            }
        }
        CatalogDto remoteDto = CatalogDto.newDtoFromXmlContents(this.contents, this.contentsDescription);
        try {
            this.copyFrom(remoteDto, true);
        }
        catch (Exception e) {
            Exceptions.propagate((Throwable)e);
        }
    }

    void copyFrom(CatalogDto source, boolean skipNulls) throws IllegalAccessException {
        if (source == null) {
            if (skipNulls) {
                return;
            }
            throw new NullPointerException("source DTO is null, when copying to " + this);
        }
        if (!skipNulls || source.id != null) {
            this.id = source.id;
        }
        if (!skipNulls || source.contentsDescription != null) {
            this.contentsDescription = source.contentsDescription;
        }
        if (!skipNulls || source.contents != null) {
            this.contents = source.contents;
        }
        if (!skipNulls || source.name != null) {
            this.name = source.name;
        }
        if (!skipNulls || source.description != null) {
            this.description = source.description;
        }
        if (!skipNulls || source.classpath != null) {
            this.classpath = source.classpath;
        }
        if (!skipNulls || source.entries != null) {
            this.entries = source.entries;
        }
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("id", (Object)this.id).add("contentsDescription", (Object)this.contentsDescription).toString();
    }

    Iterable<CatalogItemDtoAbstract<?, ?>> getUniqueEntries() {
        if (this.entries == null) {
            return null;
        }
        Map<String, CatalogItemDtoAbstract<?, ?>> result = this.getEntriesMap();
        return result.values();
    }

    private Map<String, CatalogItemDtoAbstract<?, ?>> getEntriesMap() {
        if (this.entries == null) {
            return null;
        }
        MutableMap result = MutableMap.of();
        for (CatalogItemDtoAbstract<?, ?> entry : this.entries) {
            result.put(entry.getId(), entry);
        }
        return result;
    }

    void removeEntry(CatalogItemDtoAbstract<?, ?> entry) {
        if (this.entries != null) {
            this.entries.remove(entry);
        }
    }

    void addEntry(CatalogItemDtoAbstract<?, ?> entry) {
        if (this.entries == null) {
            this.entries = MutableList.of();
        }
        CatalogItemDtoAbstract<?, ?> oldEntry = this.getEntriesMap().get(entry.getId());
        this.entries.add(entry);
        if (oldEntry != null) {
            this.removeEntry(oldEntry);
        }
    }
}

