/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.catalog.Catalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogClasspathDto;
import brooklyn.catalog.internal.CatalogDo;
import brooklyn.catalog.internal.CatalogEntityItemDto;
import brooklyn.catalog.internal.CatalogItemDtoAbstract;
import brooklyn.catalog.internal.CatalogLocationItemDto;
import brooklyn.catalog.internal.CatalogPolicyItemDto;
import brooklyn.catalog.internal.CatalogTemplateItemDto;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ApplicationBuilder;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.location.Location;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.policy.Policy;
import brooklyn.util.ResourceUtils;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.javalang.AggregateClassLoader;
import brooklyn.util.javalang.ReflectionScanner;
import brooklyn.util.javalang.UrlClassLoader;
import brooklyn.util.os.Os;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Time;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Arrays;
import java.util.Set;
import javax.annotation.Nullable;
import org.reflections.util.ClasspathHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogClasspathDo {
    private static final Logger log = LoggerFactory.getLogger(CatalogClasspathDo.class);
    private final CatalogDo catalog;
    private final CatalogClasspathDto classpath;
    private final CatalogScanningModes scanMode;
    boolean isLoaded = false;
    private URL[] urls;
    private final AggregateClassLoader classloader = AggregateClassLoader.newInstanceWithNoLoaders();
    private volatile boolean classloaderLoaded = false;

    public CatalogClasspathDo(CatalogDo catalog) {
        this.catalog = (CatalogDo)Preconditions.checkNotNull((Object)catalog, (Object)"catalog");
        this.classpath = catalog.dto.classpath;
        this.scanMode = this.classpath != null ? this.classpath.scan : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void load() {
        if (this.classpath == null || this.isLoaded) {
            return;
        }
        if (this.classpath.getEntries() == null) {
            this.urls = new URL[0];
        } else {
            this.urls = new URL[this.classpath.getEntries().size()];
            for (int i = 0; i < this.urls.length; ++i) {
                try {
                    String u = this.classpath.getEntries().get(i);
                    if (u.startsWith("classpath:")) {
                        InputStream uin = ResourceUtils.create(this).getResourceFromUrl(u);
                        File f = Os.newTempFile((String)("brooklyn-catalog-" + u), null);
                        FileOutputStream fout = new FileOutputStream(f);
                        try {
                            Streams.copy((InputStream)uin, (OutputStream)fout);
                        }
                        finally {
                            Streams.closeQuietly((Closeable)fout);
                            Streams.closeQuietly((Closeable)uin);
                        }
                        u = f.toURI().toString();
                    }
                    this.urls[i] = new URL(u);
                    continue;
                }
                catch (Exception e) {
                    Exceptions.propagateIfFatal((Throwable)e);
                    log.error("Error loading URL " + this.classpath.getEntries().get(i) + " in definition of catalog " + this.catalog + "; skipping definition");
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        }
        String prefix = null;
        if (this.scanMode == null || this.scanMode == CatalogScanningModes.NONE) {
            return;
        }
        Stopwatch timer = Stopwatch.createStarted();
        ReflectionScanner scanner = null;
        if (!this.catalog.isLocal()) {
            log.warn("Scanning not supported for remote catalogs; ignoring scan request in " + this.catalog);
        } else if (this.classpath.getEntries() == null || this.classpath.getEntries().isEmpty()) {
            ClassLoader baseCL = null;
            Iterable<URL> baseCP = null;
            if (this.catalog.mgmt instanceof ManagementContextInternal) {
                baseCL = ((ManagementContextInternal)this.catalog.mgmt).getBaseClassLoader();
                baseCP = ((ManagementContextInternal)this.catalog.mgmt).getBaseClassPathForScanning();
            }
            if ((scanner = new ReflectionScanner(baseCP, prefix, baseCL, this.catalog.getRootClassLoader())).getSubTypesOf(Entity.class).isEmpty()) {
                try {
                    ((ManagementContextInternal)this.catalog.mgmt).setBaseClassPathForScanning(ClasspathHelper.forJavaClassPath());
                    log.debug("Catalog scan of default classloader returned nothing; reverting to java.class.path");
                    baseCP = ((ManagementContextInternal)this.catalog.mgmt).getBaseClassPathForScanning();
                    scanner = new ReflectionScanner(baseCP, prefix, baseCL, this.catalog.getRootClassLoader());
                }
                catch (Exception e) {
                    log.info("Catalog scan is empty, and unable to use java.class.path (base classpath is " + baseCP + "): " + e);
                    Exceptions.propagateIfFatal((Throwable)e);
                }
            }
        } else {
            scanner = new ReflectionScanner(this.urls == null || this.urls.length == 0 ? null : Arrays.asList(this.urls), prefix, this.getLocalClassLoader());
        }
        if (scanner != null) {
            int count = 0;
            int countApps = 0;
            if (this.scanMode == CatalogScanningModes.ANNOTATIONS) {
                Set<Class<?>> catalogClasses = scanner.getTypesAnnotatedWith(Catalog.class);
                for (Class<?> c : catalogClasses) {
                    try {
                        CatalogItem<?, ?> catalogItem = this.addCatalogEntry(c);
                        ++count;
                        if (!CatalogTemplateItemDto.class.isInstance(catalogItem)) continue;
                        ++countApps;
                    }
                    catch (Exception exception) {
                        log.warn("Failed to add catalog entry for " + c + "; continuing scan...", (Throwable)exception);
                    }
                }
            } else if (this.scanMode == CatalogScanningModes.TYPES) {
                Iterable entities = this.excludeInvalidClasses(Iterables.concat(scanner.getSubTypesOf(Entity.class), scanner.getSubTypesOf(Application.class), scanner.getSubTypesOf(ApplicationBuilder.class)));
                for (Class c : entities) {
                    if (Application.class.isAssignableFrom(c) || ApplicationBuilder.class.isAssignableFrom(c)) {
                        this.addCatalogEntry(new CatalogTemplateItemDto(), c);
                        ++countApps;
                    } else {
                        this.addCatalogEntry(new CatalogEntityItemDto(), c);
                    }
                    ++count;
                }
                Iterable policies = this.excludeInvalidClasses(scanner.getSubTypesOf(Policy.class));
                for (Class clazz : policies) {
                    this.addCatalogEntry(new CatalogPolicyItemDto(), clazz);
                    ++count;
                }
                Iterable locations = this.excludeInvalidClasses(scanner.getSubTypesOf(Location.class));
                for (Class clazz : locations) {
                    this.addCatalogEntry(new CatalogLocationItemDto(), clazz);
                    ++count;
                }
            } else {
                throw new IllegalStateException("Unsupported catalog scan mode " + (Object)((Object)this.scanMode) + " for " + this);
            }
            log.debug("Catalog '" + this.catalog.dto.name + "' classpath scan completed: loaded " + count + " item" + Strings.s((int)count) + " (" + countApps + " app" + Strings.s((int)countApps) + ") in " + Time.makeTimeStringRounded((Stopwatch)timer));
        }
        this.isLoaded = true;
    }

    private <T> Iterable<Class<? extends T>> excludeInvalidClasses(Iterable<Class<? extends T>> input) {
        Predicate f = new Predicate<Class<? extends T>>(){

            public boolean apply(@Nullable Class<? extends T> input) {
                if (input == null) {
                    return false;
                }
                if (input.isLocalClass() || input.isAnonymousClass()) {
                    return false;
                }
                if (Modifier.isAbstract(input.getModifiers()) && input.getAnnotation(ImplementedBy.class) == null) {
                    return false;
                }
                if (!input.isMemberClass()) {
                    return true;
                }
                return Modifier.isStatic(input.getModifiers());
            }
        };
        return Iterables.filter(input, (Predicate)f);
    }

    @Deprecated
    public CatalogItem<?, ?> addCatalogEntry(Class<?> c) {
        if (Application.class.isAssignableFrom(c)) {
            return this.addCatalogEntry(new CatalogTemplateItemDto(), c);
        }
        if (ApplicationBuilder.class.isAssignableFrom(c)) {
            return this.addCatalogEntry(new CatalogTemplateItemDto(), c);
        }
        if (Entity.class.isAssignableFrom(c)) {
            return this.addCatalogEntry(new CatalogEntityItemDto(), c);
        }
        if (Policy.class.isAssignableFrom(c)) {
            return this.addCatalogEntry(new CatalogPolicyItemDto(), c);
        }
        if (Location.class.isAssignableFrom(c)) {
            return this.addCatalogEntry(new CatalogLocationItemDto(), c);
        }
        throw new IllegalStateException("Cannot add " + c + " to catalog: unsupported type " + c.getName());
    }

    @Deprecated
    public CatalogItem<?, ?> addCatalogEntry(CatalogItemDtoAbstract<?, ?> item, Class<?> c) {
        Catalog annotations = c.getAnnotation(Catalog.class);
        item.setSymbolicName(c.getName());
        item.setJavaType(c.getName());
        item.setDisplayName(CatalogClasspathDo.firstNonEmpty(c.getSimpleName(), c.getName()));
        if (annotations != null) {
            item.setDisplayName(CatalogClasspathDo.firstNonEmpty(annotations.name(), item.getDisplayName()));
            item.setDescription(CatalogClasspathDo.firstNonEmpty(annotations.description()));
            item.setIconUrl(CatalogClasspathDo.firstNonEmpty(annotations.iconUrl()));
        }
        if (log.isTraceEnabled()) {
            log.trace("adding to catalog: " + c + " (from catalog " + this.catalog + ")");
        }
        this.catalog.addEntry(item);
        return item;
    }

    private static String firstNonEmpty(String ... candidates) {
        for (String c : candidates) {
            if (c == null || c.isEmpty()) continue;
            return c;
        }
        return null;
    }

    public ClassLoader getLocalClassLoader() {
        if (!this.classloaderLoaded) {
            this.loadLocalClassLoader();
        }
        return this.classloader;
    }

    protected synchronized void loadLocalClassLoader() {
        if (this.classloaderLoaded) {
            return;
        }
        if (this.urls == null) {
            return;
        }
        this.classloader.addFirst((ClassLoader)new UrlClassLoader(this.urls));
        this.classloaderLoaded = true;
    }

    public void addToClasspath(URL u, boolean updateDto) {
        if (updateDto) {
            this.classpath.getEntries().add(u.toExternalForm());
        }
        this.addToClasspath(new UrlClassLoader(u));
    }

    public void addToClasspath(ClassLoader loader) {
        this.classloader.addFirst(loader);
    }

    public static enum CatalogScanningModes {
        NONE,
        ANNOTATIONS,
        TYPES;

    }
}

