/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.catalog.CatalogItem;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class CatalogBundleDto
implements CatalogItem.CatalogBundle {
    private String symbolicName;
    private String version;
    private String url;

    public CatalogBundleDto() {
    }

    public CatalogBundleDto(String name, String version, String url) {
        if (name == null && version == null) {
            Preconditions.checkNotNull((Object)url, (Object)"url to an OSGi bundle is required");
        } else {
            Preconditions.checkNotNull((Object)name, (Object)"both name and version are required");
            Preconditions.checkNotNull((Object)version, (Object)"both name and version are required");
        }
        this.symbolicName = name;
        this.version = version;
        this.url = url;
    }

    public boolean isNamed() {
        return this.symbolicName != null && this.version != null;
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public String getVersion() {
        return this.version;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("symbolicName", (Object)this.symbolicName).add("version", (Object)this.version).add("url", (Object)this.url).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbolicName, this.version, this.url});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CatalogBundleDto other = (CatalogBundleDto)obj;
        if (!Objects.equal((Object)this.symbolicName, (Object)other.symbolicName)) {
            return false;
        }
        if (!Objects.equal((Object)this.version, (Object)other.version)) {
            return false;
        }
        return Objects.equal((Object)this.url, (Object)other.url);
    }
}

