/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog.internal;

import brooklyn.basic.AbstractBrooklynObject;
import brooklyn.basic.AbstractBrooklynObjectSpec;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.camp.brooklyn.api.AssemblyTemplateSpecInstantiator;
import brooklyn.catalog.BrooklynCatalog;
import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.CatalogPredicates;
import brooklyn.catalog.internal.CatalogClasspathDo;
import brooklyn.catalog.internal.CatalogDo;
import brooklyn.catalog.internal.CatalogDto;
import brooklyn.catalog.internal.CatalogItemBuilder;
import brooklyn.catalog.internal.CatalogItemComparator;
import brooklyn.catalog.internal.CatalogItemDo;
import brooklyn.catalog.internal.CatalogItemDtoAbstract;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.catalog.internal.CatalogXmlSerializer;
import brooklyn.config.BrooklynServerConfig;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.location.basic.BasicLocationRegistry;
import brooklyn.management.ManagementContext;
import brooklyn.management.classloading.BrooklynClassLoadingContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.AggregateClassLoader;
import brooklyn.util.javalang.LoadedClassLoader;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import brooklyn.util.time.Time;
import brooklyn.util.yaml.Yamls;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.instantiate.AssemblyTemplateInstantiator;
import io.brooklyn.camp.spi.pdp.DeploymentPlan;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class BasicBrooklynCatalog
implements BrooklynCatalog {
    private static final String POLICIES_KEY = "brooklyn.policies";
    private static final String LOCATIONS_KEY = "brooklyn.locations";
    public static final String NO_VERSION = "0.0.0.SNAPSHOT";
    private static final Logger log = LoggerFactory.getLogger(BasicBrooklynCatalog.class);
    private final ManagementContext mgmt;
    private CatalogDo catalog;
    private volatile CatalogDo manualAdditionsCatalog;
    private volatile LoadedClassLoader manualAdditionsClasses;
    private final AggregateClassLoader rootClassLoader = AggregateClassLoader.newInstanceWithNoLoaders();
    transient CatalogXmlSerializer serializer;

    public BasicBrooklynCatalog(ManagementContext mgmt) {
        this(mgmt, CatalogDto.newNamedInstance("empty catalog", "empty catalog", "empty catalog, expected to be reset later"));
    }

    public BasicBrooklynCatalog(ManagementContext mgmt, CatalogDto dto) {
        this.mgmt = (ManagementContext)Preconditions.checkNotNull((Object)mgmt, (Object)"managementContext");
        this.catalog = new CatalogDo(mgmt, dto);
    }

    public boolean blockIfNotLoaded(Duration timeout) {
        try {
            return this.getCatalog().blockIfNotLoaded(timeout);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public void reset(CatalogDto dto) {
        this.reset(dto, true);
    }

    public void reset(CatalogDto dto, boolean failOnLoadError) {
        for (CatalogItem toRemove : this.getCatalogItems()) {
            if (log.isTraceEnabled()) {
                log.trace("Scheduling item for persistence removal: {}", (Object)toRemove.getId());
            }
            this.mgmt.getRebindManager().getChangeListener().onUnmanaged(toRemove);
        }
        CatalogDo catalog = new CatalogDo(this.mgmt, dto);
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Resetting " + this + " catalog to " + dto, new Object[0]);
        catalog.load(this.mgmt, null, failOnLoadError);
        CatalogUtils.logDebugOrTraceIfRebinding(log, "Reloaded catalog for " + this + ", now switching", new Object[0]);
        this.catalog = catalog;
        this.resetRootClassLoader();
        this.manualAdditionsCatalog = null;
        for (CatalogItem entry : this.getCatalogItems()) {
            CatalogItemDo cid;
            boolean setManagementContext = false;
            if (entry instanceof CatalogItemDo && (cid = (CatalogItemDo)CatalogItemDo.class.cast(entry)).getDto() instanceof CatalogItemDtoAbstract) {
                CatalogItemDtoAbstract cdto = (CatalogItemDtoAbstract)CatalogItemDtoAbstract.class.cast(cid.getDto());
                if (cdto.getManagementContext() == null) {
                    cdto.setManagementContext((ManagementContextInternal)this.mgmt);
                }
                setManagementContext = true;
            }
            if (!setManagementContext) {
                log.warn("Can't set management context on entry with unexpected type in catalog. type={}, expected={}", entry, CatalogItemDo.class);
            }
            if (log.isTraceEnabled()) {
                log.trace("Scheduling item for persistence addition: {}", (Object)entry.getId());
            }
            this.mgmt.getRebindManager().getChangeListener().onManaged(entry);
        }
    }

    public void reset(Collection<CatalogItem<?, ?>> entries) {
        CatalogDto newDto = CatalogDto.newDtoFromCatalogItems(entries, "explicit-catalog-reset");
        this.reset(newDto);
    }

    public CatalogDo getCatalog() {
        return this.catalog;
    }

    protected CatalogItemDo<?, ?> getCatalogItemDo(String symbolicName, String version) {
        String fixedVersionId = this.getFixedVersionId(symbolicName, version);
        if (fixedVersionId == null) {
            return null;
        }
        return this.catalog.getIdCache().get(CatalogUtils.getVersionedId(symbolicName, fixedVersionId));
    }

    private String getFixedVersionId(String symbolicName, String version) {
        if (!"0.0.0_DEFAULT_VERSION".equals(version)) {
            return version;
        }
        return this.getDefaultVersion(symbolicName);
    }

    private String getDefaultVersion(String symbolicName) {
        Iterable versions = this.getCatalogItems(CatalogPredicates.symbolicName((Predicate<? super String>)Predicates.equalTo((Object)symbolicName)));
        Collection orderedVersions = this.sortVersionsDesc(versions);
        if (!orderedVersions.isEmpty()) {
            return orderedVersions.iterator().next().getVersion();
        }
        return null;
    }

    private <T, SpecT> Collection<CatalogItem<T, SpecT>> sortVersionsDesc(Iterable<CatalogItem<T, SpecT>> versions) {
        return ImmutableSortedSet.orderedBy(CatalogItemComparator.getInstance()).addAll(versions).build();
    }

    @Deprecated
    public CatalogItem<?, ?> getCatalogItem(String symbolicName) {
        return this.getCatalogItem(symbolicName, "0.0.0_DEFAULT_VERSION");
    }

    public CatalogItem<?, ?> getCatalogItem(String symbolicName, String version) {
        if (symbolicName == null) {
            return null;
        }
        Preconditions.checkNotNull((Object)version, (Object)"version");
        CatalogItemDo<?, ?> itemDo = this.getCatalogItemDo(symbolicName, version);
        if (itemDo == null) {
            return null;
        }
        return itemDo.getDto();
    }

    @Deprecated
    public void deleteCatalogItem(String id) {
        this.deleteCatalogItem(id, NO_VERSION);
    }

    public void deleteCatalogItem(String symbolicName, String version) {
        log.debug("Deleting manual catalog item from " + this.mgmt + ": " + symbolicName + ":" + version);
        Preconditions.checkNotNull((Object)symbolicName, (Object)"id");
        Preconditions.checkNotNull((Object)version, (Object)"version");
        if ("0.0.0_DEFAULT_VERSION".equals(version)) {
            throw new IllegalStateException("Deleting items with unspecified version (argument DEFAULT_VERSION) not supported.");
        }
        CatalogItem<?, ?> item = this.getCatalogItem(symbolicName, version);
        CatalogItemDtoAbstract<Location, LocationSpec<?>> itemDto = this.getAbstractCatalogItem(item);
        if (itemDto == null) {
            throw new NoSuchElementException("No catalog item found with id " + symbolicName);
        }
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.deleteEntry(itemDto);
        this.getCatalog().deleteEntry(itemDto);
        if (log.isTraceEnabled()) {
            log.trace("Scheduling item for persistence removal: {}", (Object)itemDto.getId());
        }
        if (itemDto.getCatalogItemType() == CatalogItem.CatalogItemType.LOCATION) {
            CatalogItemDtoAbstract<Location, LocationSpec<?>> locationItem = itemDto;
            ((BasicLocationRegistry)this.mgmt.getLocationRegistry()).removeDefinedLocation(locationItem);
        }
        this.mgmt.getRebindManager().getChangeListener().onUnmanaged(itemDto);
    }

    @Deprecated
    public <T, SpecT> CatalogItem<T, SpecT> getCatalogItem(Class<T> type, String id) {
        return this.getCatalogItem(type, id, "0.0.0_DEFAULT_VERSION");
    }

    public <T, SpecT> CatalogItem<T, SpecT> getCatalogItem(Class<T> type, String id, String version) {
        if (id == null || version == null) {
            return null;
        }
        CatalogItem<?, ?> result = this.getCatalogItem(id, version);
        if (result == null) {
            return null;
        }
        if (type == null || type.isAssignableFrom(result.getCatalogItemJavaType())) {
            return result;
        }
        return null;
    }

    public void persist(CatalogItem<?, ?> catalogItem) {
        Preconditions.checkArgument((this.getCatalogItem(catalogItem.getSymbolicName(), catalogItem.getVersion()) != null ? 1 : 0) != 0, (String)"Unknown catalog item %s", (Object[])new Object[]{catalogItem});
        this.mgmt.getRebindManager().getChangeListener().onChanged(catalogItem);
    }

    public ClassLoader getRootClassLoader() {
        if (this.rootClassLoader.isEmpty() && this.catalog != null) {
            this.resetRootClassLoader();
        }
        return this.rootClassLoader;
    }

    private void resetRootClassLoader() {
        this.rootClassLoader.reset((Collection)ImmutableList.of((Object)this.catalog.getRootClassLoader()));
    }

    public void load() {
        log.debug("Loading catalog for " + this.mgmt);
        this.getCatalog().load(this.mgmt, null);
        if (log.isDebugEnabled()) {
            log.debug("Loaded catalog for " + this.mgmt + ": " + this.catalog + "; search classpath is " + this.catalog.getRootClassLoader());
        }
    }

    public <T, SpecT> SpecT createSpec(CatalogItem<T, SpecT> item) {
        Method method;
        CatalogItemDo<?, ?> loadedItem = this.getCatalogItemDo(item.getSymbolicName(), item.getVersion());
        if (loadedItem == null) {
            return null;
        }
        Class<?> specType = loadedItem.getSpecType();
        if (specType == null) {
            return null;
        }
        String yaml = loadedItem.getPlanYaml();
        if (yaml != null) {
            SpecT spec;
            DeploymentPlan plan = this.makePlanFromYaml(yaml);
            BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext(this.mgmt, item);
            switch (item.getCatalogItemType()) {
                case TEMPLATE: 
                case ENTITY: {
                    spec = this.createEntitySpec(loadedItem.getSymbolicName(), plan, loader);
                    break;
                }
                case POLICY: {
                    spec = this.createPolicySpec(loadedItem.getSymbolicName(), plan, loader);
                    break;
                }
                case LOCATION: {
                    spec = this.createLocationSpec(plan, loader);
                    break;
                }
                default: {
                    throw new RuntimeException("Only entity, policy & location catalog items are supported. Unsupported catalog item type " + item.getCatalogItemType());
                }
            }
            ((AbstractBrooklynObjectSpec)spec).catalogItemId(item.getId());
            return spec;
        }
        Object spec = null;
        try {
            method = Reflections.findMethod(specType, (String)"create", (Class[])new Class[]{Class.class});
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Unsupported creation of spec type " + specType + "; it must have a public static create(Class) method", e);
        }
        try {
            if (loadedItem.getJavaType() != null) {
                Object specT;
                spec = specT = method.invoke(null, loadedItem.loadJavaClass(this.mgmt));
            }
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            throw new IllegalStateException("Error creating " + specType + " " + loadedItem.getJavaType() + ": " + e, e);
        }
        if (spec == null) {
            throw new IllegalStateException("Unknown how to create instance of " + this);
        }
        return (SpecT)spec;
    }

    private <T, SpecT> SpecT createSpec(String optionalId, CatalogItem.CatalogItemType ciType, DeploymentPlan plan, BrooklynClassLoadingContext loader) {
        Preconditions.checkNotNull((Object)ciType, (Object)("catalog item type for " + plan));
        switch (ciType) {
            case TEMPLATE: 
            case ENTITY: {
                return this.createEntitySpec(optionalId, plan, loader);
            }
            case LOCATION: {
                return this.createLocationSpec(plan, loader);
            }
            case POLICY: {
                return this.createPolicySpec(optionalId, plan, loader);
            }
        }
        throw new IllegalStateException("Unknown CI Type " + ciType + " for " + plan);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, SpecT> SpecT createEntitySpec(String symbolicName, DeploymentPlan plan, BrooklynClassLoadingContext loader) {
        AssemblyTemplate at;
        CampPlatform camp = (CampPlatform)BrooklynServerConfig.getCampPlatform(this.mgmt).get();
        BrooklynLoaderTracker.setLoader(loader);
        try {
            at = camp.pdp().registerDeploymentPlan(plan);
        }
        finally {
            BrooklynLoaderTracker.unsetLoader(loader);
        }
        try {
            AssemblyTemplateInstantiator instantiator = (AssemblyTemplateInstantiator)at.getInstantiator().newInstance();
            if (instantiator instanceof AssemblyTemplateSpecInstantiator) {
                return (SpecT)((AssemblyTemplateSpecInstantiator)instantiator).createNestedSpec(at, camp, loader, (Set<String>)this.getInitialEncounteredSymbol(symbolicName));
            }
            throw new IllegalStateException("Unable to instantiate YAML; incompatible instantiator " + instantiator + " for " + at);
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private MutableSet<String> getInitialEncounteredSymbol(String symbolicName) {
        return symbolicName == null ? MutableSet.of() : MutableSet.of((Object)symbolicName);
    }

    private <T, SpecT> SpecT createPolicySpec(String symbolicName, DeploymentPlan plan, BrooklynClassLoadingContext loader) {
        return this.createPolicySpec(plan, loader, (Set<String>)this.getInitialEncounteredSymbol(symbolicName));
    }

    private <T, SpecT> SpecT createPolicySpec(DeploymentPlan plan, BrooklynClassLoadingContext loader, Set<String> encounteredCatalogTypes) {
        Object policies = Preconditions.checkNotNull(plan.getCustomAttributes().get(POLICIES_KEY), (Object)"policy config");
        if (!(policies instanceof Iterable)) {
            throw new IllegalStateException("The value of brooklyn.policies must be an Iterable.");
        }
        Object policy = Iterables.getOnlyElement((Iterable)((Iterable)policies));
        return this.createPolicySpec(loader, policy, encounteredCatalogTypes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T, SpecT> SpecT createPolicySpec(BrooklynClassLoadingContext loader, Object policy, Set<String> encounteredCatalogTypes) {
        Map brooklynConfig;
        PolicySpec spec;
        Object itemMap;
        if (policy instanceof String) {
            itemMap = ImmutableMap.of((Object)"type", (Object)policy);
        } else {
            if (!(policy instanceof Map)) throw new IllegalStateException("Policy expected to be string or map. Unsupported object type " + policy.getClass().getName() + " (" + policy.toString() + ")");
            itemMap = (Map)policy;
        }
        String versionedId = (String)Preconditions.checkNotNull((Object)Yamls.getMultinameAttribute((Map)itemMap, (String[])new String[]{"policy_type", "policyType", "type"}), (Object)"policy type");
        CatalogItem<?, ?> policyItem = CatalogUtils.getCatalogItemOptionalVersion(this.mgmt, versionedId);
        if (policyItem != null && !encounteredCatalogTypes.contains(policyItem.getSymbolicName())) {
            if (policyItem.getCatalogItemType() != CatalogItem.CatalogItemType.POLICY) {
                throw new IllegalStateException("Non-policy catalog item in policy context: " + policyItem);
            }
            BrooklynClassLoadingContext itemLoader = CatalogUtils.newClassLoadingContext(this.mgmt, policyItem);
            if (policyItem.getPlanYaml() != null) {
                DeploymentPlan plan = this.makePlanFromYaml(policyItem.getPlanYaml());
                encounteredCatalogTypes.add(policyItem.getSymbolicName());
                return this.createPolicySpec(plan, itemLoader, encounteredCatalogTypes);
            }
            if (policyItem.getJavaType() == null) throw new IllegalStateException("Invalid policy item - neither yaml nor javaType: " + policyItem);
            spec = PolicySpec.create((Class)itemLoader.loadClass(policyItem.getJavaType()));
        } else {
            spec = PolicySpec.create((Class)loader.loadClass(versionedId, Policy.class));
        }
        if ((brooklynConfig = (Map)itemMap.get("brooklyn.config")) == null) return (SpecT)spec;
        spec.configure(brooklynConfig);
        return (SpecT)spec;
    }

    private <T, SpecT> SpecT createLocationSpec(DeploymentPlan plan, BrooklynClassLoadingContext loader) {
        Object locations = Preconditions.checkNotNull(plan.getCustomAttributes().get(LOCATIONS_KEY), (Object)"location config");
        if (!(locations instanceof Iterable)) {
            throw new IllegalStateException("The value of brooklyn.locations must be an Iterable.");
        }
        Object location = Iterables.getOnlyElement((Iterable)((Iterable)locations));
        return this.createLocationSpec(loader, location);
    }

    private <T, SpecT> SpecT createLocationSpec(BrooklynClassLoadingContext loader, Object location) {
        Object itemMap;
        if (location instanceof String) {
            itemMap = ImmutableMap.of((Object)"type", (Object)location);
        } else if (location instanceof Map) {
            itemMap = (Map)location;
        } else {
            throw new IllegalStateException("Location expected to be string or map. Unsupported object type " + location.getClass().getName() + " (" + location.toString() + ")");
        }
        String type = (String)Preconditions.checkNotNull((Object)Yamls.getMultinameAttribute((Map)itemMap, (String[])new String[]{"location_type", "locationType", "type"}), (Object)"location type");
        Map brooklynConfig = (Map)itemMap.get("brooklyn.config");
        Maybe javaClass = loader.tryLoadClass(type, Location.class);
        if (javaClass.isPresent()) {
            LocationSpec spec = LocationSpec.create((Class)((Class)javaClass.get()));
            if (brooklynConfig != null) {
                spec.configure(brooklynConfig);
            }
            return (SpecT)spec;
        }
        Maybe loc = this.mgmt.getLocationRegistry().resolve(type, Boolean.valueOf(false), brooklynConfig);
        if (loc.isPresent()) {
            Map<String, Object> locConfig = ((BrooklynObjectInternal.ConfigurationSupportInternal)((Location)loc.get()).config()).getBag().getAllConfig();
            Class<?> locType = ((Location)loc.get()).getClass();
            Set locTags = ((Location)loc.get()).tags().getTags();
            String locDisplayName = ((Location)loc.get()).getDisplayName();
            return (SpecT)((LocationSpec)LocationSpec.create(locType).configure(locConfig).displayName(locDisplayName)).tags((Iterable)locTags);
        }
        throw new IllegalStateException("No class or resolver found for location type " + type);
    }

    @Deprecated
    public <T, SpecT> Class<? extends T> loadClass(CatalogItem<T, SpecT> item) {
        if (log.isDebugEnabled()) {
            log.debug("Loading class for catalog item " + item);
        }
        Preconditions.checkNotNull(item);
        CatalogItemDo<?, ?> loadedItem = this.getCatalogItemDo(item.getSymbolicName(), item.getVersion());
        if (loadedItem == null) {
            throw new NoSuchElementException("Unable to load '" + item.getId() + "' to instantiate it");
        }
        return loadedItem.getJavaClass();
    }

    @Deprecated
    public <T> Class<? extends T> loadClassByType(String typeName, Class<T> typeClass) {
        CatalogItem<?, ?> resultI = this.getCatalogItemForType(typeName);
        if (resultI == null) {
            throw new NoSuchElementException("Unable to find catalog item for type " + typeName);
        }
        return this.loadClass(resultI);
    }

    @Deprecated
    private <T, SpecT> CatalogItemDtoAbstract<T, SpecT> getAbstractCatalogItem(CatalogItem<T, SpecT> item) {
        while (item instanceof CatalogItemDo) {
            item = ((CatalogItemDo)item).itemDto;
        }
        if (item == null) {
            return null;
        }
        if (item instanceof CatalogItemDtoAbstract) {
            return (CatalogItemDtoAbstract)item;
        }
        throw new IllegalStateException("Cannot unwrap catalog item '" + item + "' (type " + item.getClass() + ") to restore DTO");
    }

    private static <T> Maybe<T> getFirstAs(Map<?, ?> map, Class<T> type, String firstKey, String ... otherKeys) {
        if (map == null) {
            return Maybe.absent((String)"No map available");
        }
        String foundKey = null;
        Object value = null;
        if (map.containsKey(firstKey)) {
            foundKey = firstKey;
        } else {
            for (String key : otherKeys) {
                if (!map.containsKey(key)) continue;
                foundKey = key;
                break;
            }
        }
        if (foundKey == null) {
            return Maybe.absent((String)("Missing entry '" + firstKey + "'"));
        }
        value = map.get(foundKey);
        if (type.equals(String.class) && Number.class.isInstance(value)) {
            value = value.toString();
        }
        if (!type.isInstance(value)) {
            throw new IllegalArgumentException("Entry for '" + firstKey + "' should be of type " + type + ", not " + value.getClass());
        }
        return Maybe.of((Object)value);
    }

    private Maybe<Map<?, ?>> getFirstAsMap(Map<?, ?> map, String firstKey, String ... otherKeys) {
        return BasicBrooklynCatalog.getFirstAs(map, Map.class, firstKey, otherKeys);
    }

    private List<CatalogItemDtoAbstract<?, ?>> collectCatalogItems(String yaml) {
        Map itemDef = (Map)Yamls.getAs((Object)Yamls.parseAll((String)yaml), Map.class);
        Map catalogMetadata = (Map)this.getFirstAsMap(itemDef, "brooklyn.catalog", new String[0]).orNull();
        if (catalogMetadata == null) {
            log.warn("No `brooklyn.catalog` supplied in catalog request; using legacy mode for " + itemDef);
        }
        catalogMetadata = MutableMap.copyOf((Map)catalogMetadata);
        MutableList result = MutableList.of();
        this.collectCatalogItems(Yamls.getTextOfYamlAtPath((String)yaml, (Object[])new Object[]{"brooklyn.catalog"}).getMatchedYamlTextOrWarn(), catalogMetadata, (List<CatalogItemDtoAbstract<?, ?>>)result, null);
        itemDef.remove("brooklyn.catalog");
        catalogMetadata.remove("item");
        catalogMetadata.remove("items");
        if (!itemDef.isEmpty()) {
            log.debug("Reading brooklyn.catalog peer keys as item ('top-level syntax')");
            MutableMap rootItem = MutableMap.of((Object)"item", (Object)itemDef);
            String rootItemYaml = yaml;
            Yamls.YamlExtract yamlExtract = Yamls.getTextOfYamlAtPath((String)rootItemYaml, (Object[])new Object[]{"brooklyn.catalog"});
            String match = yamlExtract.withOriginalIndentation(true).withKeyIncluded(true).getMatchedYamlTextOrWarn();
            if (match != null) {
                rootItemYaml = rootItemYaml.startsWith(match) ? Strings.removeFromStart((String)rootItemYaml, (String)match) : Strings.replaceAllNonRegex((String)rootItemYaml, (String)("\n" + match), (String)"");
            }
            this.collectCatalogItems("item:\n" + this.makeAsIndentedObject(rootItemYaml), (Map<?, ?>)rootItem, (List<CatalogItemDtoAbstract<?, ?>>)result, catalogMetadata);
        }
        return result;
    }

    private void collectCatalogItems(String sourceYaml, Map<?, ?> itemMetadata, List<CatalogItemDtoAbstract<?, ?>> result, Map<?, ?> parentMetadata) {
        PlanInterpreterGuessingType planInterpreter;
        if (sourceYaml == null) {
            sourceYaml = new Yaml().dump(itemMetadata);
        }
        MutableMap catalogMetadata = MutableMap.builder().putAll(parentMetadata).putAll(itemMetadata).build();
        MutableList librariesNew = MutableList.copyOf((Iterable)((Iterable)BasicBrooklynCatalog.getFirstAs(itemMetadata, List.class, "brooklyn.libraries", "libraries").orNull()));
        Collection<CatalogItem.CatalogBundle> libraryBundlesNew = CatalogItemDtoAbstract.parseLibraries(librariesNew);
        MutableList librariesCombined = MutableList.copyOf((Iterable)librariesNew).appendAll((Iterable)BasicBrooklynCatalog.getFirstAs(parentMetadata, List.class, "brooklyn.libraries", "libraries").orNull());
        if (!librariesCombined.isEmpty()) {
            catalogMetadata.put("brooklyn.libraries", librariesCombined);
        }
        Collection<CatalogItem.CatalogBundle> libraryBundles = CatalogItemDtoAbstract.parseLibraries(librariesCombined);
        CatalogUtils.installLibraries(this.mgmt, libraryBundlesNew);
        Boolean scanJavaAnnotations = (Boolean)BasicBrooklynCatalog.getFirstAs(itemMetadata, Boolean.class, "scanJavaAnnotations", "scan_java_annotations").orNull();
        if (scanJavaAnnotations != null && scanJavaAnnotations.booleanValue()) {
            if (!libraryBundlesNew.isEmpty()) {
                result.addAll(this.scanAnnotationsFromBundles(this.mgmt, libraryBundlesNew, (Map<Object, Object>)catalogMetadata));
            } else if (libraryBundles.isEmpty()) {
                result.addAll(this.scanAnnotationsFromLocal(this.mgmt, (Map<Object, Object>)catalogMetadata));
            } else {
                throw new IllegalStateException("Cannot scan catalog node no local bundles, and with inherited bundles we will not scan the classpath");
            }
        }
        Object items = catalogMetadata.remove("items");
        Object item = catalogMetadata.remove("item");
        if (items != null) {
            int count = 0;
            for (Map i : (List)items) {
                this.collectCatalogItems(Yamls.getTextOfYamlAtPath((String)sourceYaml, (Object[])new Object[]{"items", count}).getMatchedYamlTextOrWarn(), i, result, (Map<?, ?>)catalogMetadata);
                ++count;
            }
        }
        if (item == null) {
            return;
        }
        String itemYaml = Yamls.getTextOfYamlAtPath((String)sourceYaml, (Object[])new Object[]{"item"}).getMatchedYamlTextOrWarn();
        sourceYaml = itemYaml != null ? itemYaml : new Yaml().dump(item);
        CatalogItem.CatalogItemType itemType = TypeCoercions.coerce(BasicBrooklynCatalog.getFirstAs(catalogMetadata, Object.class, "itemType", new String[]{"item_type"}).orNull(), CatalogItem.CatalogItemType.class);
        BrooklynClassLoadingContext loader = CatalogUtils.newClassLoadingContext(this.mgmt, "<load>:0", libraryBundles);
        String id = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "id", new String[0]).orNull();
        String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
        String symbolicName = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "symbolicName", new String[0]).orNull();
        String displayName = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "displayName", new String[0]).orNull();
        String name = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "name", new String[0]).orNull();
        if ((Strings.isNonBlank((CharSequence)id) || Strings.isNonBlank((CharSequence)symbolicName)) && Strings.isNonBlank((CharSequence)displayName) && Strings.isNonBlank((CharSequence)name) && !name.equals(displayName)) {
            log.warn("Name property will be ignored due to the existence of displayName and at least one of id, symbolicName");
        }
        if (!(planInterpreter = new PlanInterpreterGuessingType(null, item, sourceYaml, itemType, loader, result).reconstruct()).isResolved()) {
            throw Exceptions.create((String)("Could not resolve item " + (Strings.isNonBlank((CharSequence)id) ? id : (Strings.isNonBlank((CharSequence)symbolicName) ? symbolicName : (Strings.isNonBlank((CharSequence)name) ? name : "<no-name>"))) + ":\n" + sourceYaml), planInterpreter.getErrors());
        }
        itemType = planInterpreter.getCatalogItemType();
        Map<?, ?> itemAsMap = planInterpreter.getItem();
        if (Strings.isBlank((CharSequence)symbolicName)) {
            if (Strings.isNonBlank((CharSequence)id)) {
                symbolicName = CatalogUtils.looksLikeVersionedId(id) ? CatalogUtils.getIdFromVersionedId(id) : id;
            } else if (Strings.isNonBlank((CharSequence)name)) {
                symbolicName = CatalogUtils.looksLikeVersionedId(name) ? CatalogUtils.getIdFromVersionedId(name) : name;
            } else {
                symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "id");
                if (Strings.isBlank((CharSequence)(symbolicName = this.setFromItemIfUnset(symbolicName, itemAsMap, "name")))) {
                    log.error("Can't infer catalog item symbolicName from the following plan:\n" + sourceYaml);
                    throw new IllegalStateException("Can't infer catalog item symbolicName from catalog item metadata");
                }
            }
        }
        if (CatalogUtils.looksLikeVersionedId(id)) {
            String versionFromId = CatalogUtils.getVersionFromVersionedId(id);
            if (versionFromId != null && Strings.isNonBlank((CharSequence)version) && !versionFromId.equals(version)) {
                throw new IllegalArgumentException("Discrepency between version set in id " + versionFromId + " and version property " + version);
            }
            version = versionFromId;
        }
        if (Strings.isBlank((CharSequence)version)) {
            if (CatalogUtils.looksLikeVersionedId(name)) {
                version = CatalogUtils.getVersionFromVersionedId(name);
            } else if (Strings.isBlank((CharSequence)version) && (version = this.setFromItemIfUnset(version, itemAsMap, "version")) == null) {
                log.warn("No version specified for catalog item " + symbolicName + ". Using default value.");
                version = null;
            }
        }
        if (Strings.isBlank((CharSequence)id)) {
            if (Strings.isNonBlank((CharSequence)symbolicName) && Strings.isNonBlank((CharSequence)version)) {
                id = symbolicName + ":" + version;
            }
            if (Strings.isBlank((CharSequence)(id = this.setFromItemIfUnset(id, itemAsMap, "id")))) {
                if (Strings.isNonBlank((CharSequence)symbolicName)) {
                    id = symbolicName;
                } else {
                    log.error("Can't infer catalog item id from the following plan:\n" + sourceYaml);
                    throw new IllegalStateException("Can't infer catalog item id from catalog item metadata");
                }
            }
        }
        if (Strings.isBlank((CharSequence)displayName)) {
            if (Strings.isNonBlank((CharSequence)name)) {
                displayName = name;
            }
            displayName = this.setFromItemIfUnset(displayName, itemAsMap, "name");
        }
        String description = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "description", new String[0]).orNull();
        description = this.setFromItemIfUnset(description, itemAsMap, "description");
        String catalogIconUrl = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "iconUrl", new String[]{"icon_url", "icon.url"}).orNull();
        String deprecated = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "deprecated", new String[0]).orNull();
        Boolean catalogDeprecated = Boolean.valueOf(deprecated);
        planInterpreter = new PlanInterpreterGuessingType(id, item, sourceYaml, itemType, loader, result).reconstruct();
        if (!planInterpreter.isResolved()) {
            throw new IllegalStateException("Could not resolve plan once id and itemType are known (recursive reference?): " + sourceYaml);
        }
        String sourcePlanYaml = planInterpreter.getPlanYaml();
        Object dto = this.createItemBuilder(itemType, symbolicName, version).libraries(libraryBundles).displayName(displayName).description(description).deprecated(catalogDeprecated).iconUrl(catalogIconUrl).plan(sourcePlanYaml).build();
        ((AbstractBrooklynObject)dto).setManagementContext((ManagementContextInternal)this.mgmt);
        result.add((CatalogItemDtoAbstract<?, ?>)dto);
    }

    private String setFromItemIfUnset(String oldValue, Map<?, ?> item, String fieldAttr) {
        Object newValue;
        if (Strings.isNonBlank((CharSequence)oldValue)) {
            return oldValue;
        }
        if (item != null && (newValue = item.get(fieldAttr)) instanceof String && Strings.isNonBlank((CharSequence)((String)newValue))) {
            return (String)newValue;
        }
        return oldValue;
    }

    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsFromLocal(ManagementContext mgmt, Map<Object, Object> catalogMetadata) {
        CatalogDto dto = CatalogDto.newNamedInstance("Local Scanned Catalog", "All annotated Brooklyn entities detected in the classpath", "scanning-local-classpath");
        return this.scanAnnotationsInternal(mgmt, new CatalogDo(dto), catalogMetadata);
    }

    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsFromBundles(ManagementContext mgmt, Collection<CatalogItem.CatalogBundle> libraries, Map<Object, Object> catalogMetadata) {
        CatalogDto dto = CatalogDto.newNamedInstance("Bundles Scanned Catalog", "All annotated Brooklyn entities detected in bundles", "scanning-bundles-classpath-" + libraries.hashCode());
        MutableList urls = MutableList.of();
        for (CatalogItem.CatalogBundle b : libraries) {
            if (!Strings.isNonBlank((CharSequence)b.getUrl())) continue;
            urls.add(b.getUrl());
        }
        if (urls.isEmpty()) {
            log.warn("No bundles to scan: scanJavaAnnotations currently only applies to OSGi bundles provided by URL");
            return MutableList.of();
        }
        CatalogDo subCatalog = new CatalogDo(dto);
        subCatalog.addToClasspath(urls.toArray(new String[0]));
        return this.scanAnnotationsInternal(mgmt, subCatalog, catalogMetadata);
    }

    private Collection<CatalogItemDtoAbstract<?, ?>> scanAnnotationsInternal(ManagementContext mgmt, CatalogDo subCatalog, Map<Object, Object> catalogMetadata) {
        subCatalog.mgmt = mgmt;
        subCatalog.setClasspathScanForEntities(CatalogClasspathDo.CatalogScanningModes.ANNOTATIONS);
        subCatalog.load();
        Collection result = Collections2.transform(subCatalog.getIdCache().values(), BasicBrooklynCatalog.itemDoToDtoAddingSelectedMetadataDuringScan(catalogMetadata));
        return result;
    }

    private String makeAsIndentedList(String yaml) {
        Object[] lines = yaml.split("\n");
        lines[0] = "- " + lines[0];
        for (int i = 1; i < lines.length; ++i) {
            lines[i] = "  " + (String)lines[i];
        }
        return Strings.join((Object[])lines, (String)"\n");
    }

    private String makeAsIndentedObject(String yaml) {
        Object[] lines = yaml.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = "  " + (String)lines[i];
        }
        return Strings.join((Object[])lines, (String)"\n");
    }

    private CatalogItemBuilder<?> createItemBuilder(CatalogItem.CatalogItemType itemType, String itemId, String version) {
        Preconditions.checkNotNull((Object)itemType, (Object)"itemType required");
        switch (itemType) {
            case ENTITY: {
                return CatalogItemBuilder.newEntity(itemId, version);
            }
            case TEMPLATE: {
                return CatalogItemBuilder.newTemplate(itemId, version);
            }
            case POLICY: {
                return CatalogItemBuilder.newPolicy(itemId, version);
            }
            case LOCATION: {
                return CatalogItemBuilder.newLocation(itemId, version);
            }
        }
        throw new IllegalStateException("Unexpected itemType: " + itemType);
    }

    private DeploymentPlan makePlanFromYaml(String yaml) {
        CampPlatform camp = (CampPlatform)BrooklynServerConfig.getCampPlatform(this.mgmt).get();
        return camp.pdp().parseDeploymentPlan(Streams.newReaderWithContents((String)yaml));
    }

    public CatalogItem<?, ?> addItem(String yaml) {
        return this.addItem(yaml, false);
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml) {
        return this.addItems(yaml, false);
    }

    public CatalogItem<?, ?> addItem(String yaml, boolean forceUpdate) {
        return (CatalogItem)Iterables.getOnlyElement((Iterable)this.addItems(yaml, forceUpdate));
    }

    public List<? extends CatalogItem<?, ?>> addItems(String yaml, boolean forceUpdate) {
        log.debug("Adding manual catalog item to " + this.mgmt + ": " + yaml);
        Preconditions.checkNotNull((Object)yaml, (Object)"yaml");
        List<CatalogItemDtoAbstract<?, ?>> result = this.collectCatalogItems(yaml);
        for (CatalogItemDtoAbstract<?, ?> item : result) {
            this.addItemDto(item, forceUpdate);
        }
        return result;
    }

    private CatalogItem<?, ?> addItemDto(CatalogItemDtoAbstract<?, ?> itemDto, boolean forceUpdate) {
        CatalogItem<?, ?> existingDto = this.checkItemAllowedAndIfSoReturnAnyDuplicate(itemDto, true, forceUpdate);
        if (existingDto != null) {
            log.trace("Using existing duplicate for catalog item {}", (Object)itemDto.getId());
            return existingDto;
        }
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.addEntry(itemDto);
        this.getCatalog().addEntry(itemDto);
        if (log.isTraceEnabled()) {
            log.trace("Scheduling item for persistence addition: {}", (Object)itemDto.getId());
        }
        if (itemDto.getCatalogItemType() == CatalogItem.CatalogItemType.LOCATION) {
            CatalogItemDtoAbstract<Location, LocationSpec<?>> locationItem = itemDto;
            ((BasicLocationRegistry)this.mgmt.getLocationRegistry()).updateDefinedLocation(locationItem);
        }
        this.mgmt.getRebindManager().getChangeListener().onManaged(itemDto);
        return itemDto;
    }

    private CatalogItem<?, ?> checkItemAllowedAndIfSoReturnAnyDuplicate(CatalogItem<?, ?> itemDto, boolean allowDuplicates, boolean forceUpdate) {
        if (forceUpdate) {
            return null;
        }
        CatalogItemDo<?, ?> existingItem = this.getCatalogItemDo(itemDto.getSymbolicName(), itemDto.getVersion());
        if (existingItem == null) {
            return null;
        }
        CatalogItem<?, ?> existingDto = existingItem.getDto();
        if (existingDto.equals(itemDto)) {
            if (allowDuplicates) {
                return existingItem;
            }
            throw new IllegalStateException("Updating existing catalog entries, even with the same content, is forbidden: " + itemDto.getSymbolicName() + ":" + itemDto.getVersion() + ". Use forceUpdate argument to override.");
        }
        throw new IllegalStateException("Updating existing catalog entries is forbidden: " + itemDto.getSymbolicName() + ":" + itemDto.getVersion() + ". Use forceUpdate argument to override.");
    }

    @Deprecated
    public void addItem(CatalogItem<?, ?> item) {
        log.debug("Adding manual catalog item to " + this.mgmt + ": " + item);
        Preconditions.checkNotNull(item, (Object)"item");
        CatalogUtils.installLibraries(this.mgmt, item.getLibraries());
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsCatalog.addEntry(this.getAbstractCatalogItem(item));
    }

    @Deprecated
    public CatalogItem<?, ?> addItem(Class<?> type) {
        log.debug("Adding manual catalog item to " + this.mgmt + ": " + type);
        Preconditions.checkNotNull(type, (Object)"type");
        if (this.manualAdditionsCatalog == null) {
            this.loadManualAdditionsCatalog();
        }
        this.manualAdditionsClasses.addClass(type);
        return this.manualAdditionsCatalog.classpath.addCatalogEntry(type);
    }

    private synchronized void loadManualAdditionsCatalog() {
        if (this.manualAdditionsCatalog != null) {
            return;
        }
        CatalogDto manualAdditionsCatalogDto = CatalogDto.newNamedInstance("Manual Catalog Additions", "User-additions to the catalog while Brooklyn is running, created " + Time.makeDateString(), "manual-additions");
        CatalogDo manualAdditionsCatalog = this.catalog.addCatalog(manualAdditionsCatalogDto);
        if (manualAdditionsCatalog == null) {
            log.warn("Blocking until catalog is loaded before changing it");
            boolean loaded = this.blockIfNotLoaded(Duration.TEN_SECONDS);
            if (!loaded) {
                log.warn("Catalog still not loaded after delay; subsequent operations may fail");
            }
            if ((manualAdditionsCatalog = this.catalog.addCatalog(manualAdditionsCatalogDto)) == null) {
                throw new UnsupportedOperationException("Catalogs cannot be added until the base catalog is loaded, and catalog is taking a while to load!");
            }
        }
        log.debug("Creating manual additions catalog for " + this.mgmt + ": " + manualAdditionsCatalog);
        this.manualAdditionsClasses = new LoadedClassLoader();
        ((AggregateClassLoader)manualAdditionsCatalog.classpath.getLocalClassLoader()).addFirst((ClassLoader)this.manualAdditionsClasses);
        this.manualAdditionsCatalog = manualAdditionsCatalog;
    }

    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItems() {
        if (!this.getCatalog().isLoaded()) {
            log.debug("Forcing catalog load on access of catalog items");
            this.load();
        }
        return ImmutableList.copyOf(this.catalog.getIdCache().values());
    }

    /*
     * Exception decompiling
     */
    public <T, SpecT> Iterable<CatalogItem<T, SpecT>> getCatalogItems(Predicate<? super CatalogItem<T, SpecT>> filter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.NullPointerException: Cannot invoke "org.benf.cfr.reader.bytecode.analysis.types.BindingSuperContainer.getBoundAssignable(org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance, org.benf.cfr.reader.bytecode.analysis.types.JavaGenericRefTypeInstance)" because "maybeBindingContainer" is null
         *     at org.benf.cfr.reader.bytecode.analysis.types.GenericTypeBinder.extractBaseBindings(GenericTypeBinder.java:125)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteFunctionInvokation(ExplicitTypeCallRewriter.java:37)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter$InnerExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.applyExpressionRewriterToArgs(StaticFunctionInvokation.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExplicitTypeCallRewriter.rewriteExpression(ExplicitTypeCallRewriter.java:71)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.statement.ReturnValueStatement.rewriteExpressions(ReturnValueStatement.java:62)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.rewrite(Op03SimpleStatement.java:479)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Op03Rewriters.rewriteWith(Op03Rewriters.java:23)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:819)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static <T, SpecT> Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>> itemDoToDto() {
        return new Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>>(){

            public CatalogItem<T, SpecT> apply(@Nullable CatalogItemDo<T, SpecT> item) {
                if (item == null) {
                    return null;
                }
                return item.getDto();
            }
        };
    }

    private static <T, SpecT> Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>> itemDoToDtoAddingSelectedMetadataDuringScan(final Map<Object, Object> catalogMetadata) {
        return new Function<CatalogItemDo<T, SpecT>, CatalogItem<T, SpecT>>(){

            public CatalogItem<T, SpecT> apply(@Nullable CatalogItemDo<T, SpecT> item) {
                Object librariesCombined;
                if (item == null) {
                    return null;
                }
                CatalogItemDtoAbstract dto = (CatalogItemDtoAbstract)item.getDto();
                String version = (String)BasicBrooklynCatalog.getFirstAs(catalogMetadata, String.class, "version", new String[0]).orNull();
                if (Strings.isNonBlank((CharSequence)version)) {
                    dto.setVersion(version);
                }
                if ((librariesCombined = catalogMetadata.get("brooklyn.libraries")) instanceof Collection) {
                    Collection<CatalogItem.CatalogBundle> libraryBundles = CatalogItemDtoAbstract.parseLibraries((Collection)librariesCombined);
                    dto.setLibraries(libraryBundles);
                }
                dto.setSymbolicName(dto.getJavaType());
                switch (dto.getCatalogItemType()) {
                    case TEMPLATE: 
                    case ENTITY: {
                        dto.setPlanYaml("services: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case POLICY: {
                        dto.setPlanYaml("brooklyn.policies: [{ type: " + dto.getJavaType() + " }]");
                        break;
                    }
                    case LOCATION: {
                        dto.setPlanYaml("brooklyn.locations: [{ type: " + dto.getJavaType() + " }]");
                    }
                }
                dto.setJavaType(null);
                return dto;
            }
        };
    }

    public String toXmlString() {
        if (this.serializer == null) {
            this.loadSerializer();
        }
        return this.serializer.toString(this.catalog.dto);
    }

    private synchronized void loadSerializer() {
        if (this.serializer == null) {
            this.serializer = new CatalogXmlSerializer();
        }
    }

    @Deprecated
    public CatalogItem<?, ?> getCatalogItemForType(String typeName) {
        CatalogItem resultI;
        BrooklynCatalog catalog = this.mgmt.getCatalog();
        if (CatalogUtils.looksLikeVersionedId(typeName)) {
            resultI = CatalogUtils.getCatalogItemOptionalVersion(this.mgmt, typeName);
        } else {
            Iterable resultL = catalog.getCatalogItems(CatalogPredicates.javaType((Predicate<? super String>)Predicates.equalTo((Object)typeName)));
            if (!Iterables.isEmpty((Iterable)resultL)) {
                resultI = this.sortVersionsDesc(resultL).iterator().next();
                if (log.isDebugEnabled() && Iterables.size((Iterable)resultL) > 1) {
                    log.debug("Found " + Iterables.size((Iterable)resultL) + " matches in catalog for type " + typeName + "; returning the result with preferred version, " + resultI);
                }
            } else {
                resultI = catalog.getCatalogItem(typeName, "0.0.0_DEFAULT_VERSION");
                if (resultI != null && resultI.getJavaType() == null) {
                    throw new NoSuchElementException("Unable to find catalog item for type " + typeName + ". There is an existing catalog item with ID " + resultI.getId() + " but it doesn't define a class type.");
                }
            }
        }
        return resultI;
    }

    private class PlanInterpreterGuessingType {
        final String id;
        final Map<?, ?> item;
        final String itemYaml;
        final BrooklynClassLoadingContext loader;
        final List<CatalogItemDtoAbstract<?, ?>> itemsDefinedSoFar;
        CatalogItem.CatalogItemType catalogItemType;
        String planYaml;
        DeploymentPlan plan;
        AbstractBrooklynObjectSpec<?, ?> spec;
        boolean resolved = false;
        List<Exception> errors = MutableList.of();

        public PlanInterpreterGuessingType(String id, Object item, @Nullable String itemYaml, CatalogItem.CatalogItemType optionalCiType, BrooklynClassLoadingContext loader, List<CatalogItemDtoAbstract<?, ?>> itemsDefinedSoFar) {
            this.id = id;
            if (item instanceof String) {
                this.item = MutableMap.of((Object)"type", (Object)item);
                this.itemYaml = "type:\n" + BasicBrooklynCatalog.this.makeAsIndentedObject(itemYaml);
            } else {
                this.item = (Map)item;
                this.itemYaml = itemYaml;
            }
            this.catalogItemType = optionalCiType;
            this.loader = loader;
            this.itemsDefinedSoFar = itemsDefinedSoFar;
        }

        public PlanInterpreterGuessingType reconstruct() {
            if (this.catalogItemType == CatalogItem.CatalogItemType.TEMPLATE) {
                this.attemptType(null, CatalogItem.CatalogItemType.TEMPLATE);
            } else {
                this.attemptType(null, CatalogItem.CatalogItemType.ENTITY);
                this.attemptType("services", CatalogItem.CatalogItemType.ENTITY);
                this.attemptType(BasicBrooklynCatalog.POLICIES_KEY, CatalogItem.CatalogItemType.POLICY);
                this.attemptType(BasicBrooklynCatalog.LOCATIONS_KEY, CatalogItem.CatalogItemType.LOCATION);
            }
            if (!this.resolved && this.catalogItemType == CatalogItem.CatalogItemType.TEMPLATE) {
                this.planYaml = this.itemYaml;
                this.resolved = true;
            }
            return this;
        }

        public boolean isResolved() {
            return this.resolved;
        }

        public List<Exception> getErrors() {
            return this.errors;
        }

        public CatalogItem.CatalogItemType getCatalogItemType() {
            return this.catalogItemType;
        }

        public String getPlanYaml() {
            return this.planYaml;
        }

        private boolean attemptType(String key, CatalogItem.CatalogItemType candidateCiType) {
            if (this.resolved) {
                return false;
            }
            if (this.catalogItemType != null && this.catalogItemType != candidateCiType) {
                return false;
            }
            String candidateYaml = key == null ? this.itemYaml : (this.item.containsKey(key) ? this.itemYaml : key + ":\n" + BasicBrooklynCatalog.this.makeAsIndentedList(this.itemYaml));
            String type = (String)this.item.get("type");
            String version = null;
            if (CatalogUtils.looksLikeVersionedId(type)) {
                version = CatalogUtils.getVersionFromVersionedId(type);
                type = CatalogUtils.getIdFromVersionedId(type);
            }
            if (type != null && key != null) {
                for (CatalogItemDtoAbstract<?, ?> candidate : this.itemsDefinedSoFar) {
                    if (candidateCiType != candidate.getCatalogItemType() || !type.equals(candidate.getSymbolicName()) && !type.equals(candidate.getId()) || version != null && !version.equals(candidate.getVersion())) continue;
                    this.catalogItemType = candidateCiType;
                    this.planYaml = candidateYaml;
                    this.resolved = true;
                    return true;
                }
            }
            try {
                DeploymentPlan candidatePlan = BasicBrooklynCatalog.this.makePlanFromYaml(candidateYaml);
                this.spec = (AbstractBrooklynObjectSpec)BasicBrooklynCatalog.this.createSpec(this.id, candidateCiType, candidatePlan, this.loader);
                if (this.spec != null) {
                    this.catalogItemType = candidateCiType;
                    this.plan = candidatePlan;
                    this.planYaml = candidateYaml;
                    this.resolved = true;
                }
                return true;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                if (this.item.containsKey("services") && (candidateCiType == CatalogItem.CatalogItemType.ENTITY || candidateCiType == CatalogItem.CatalogItemType.TEMPLATE)) {
                    this.errors.add(e);
                } else if (this.catalogItemType != null && key != null) {
                    this.errors.add(e);
                } else if (log.isTraceEnabled()) {
                    log.trace("Guessing type of plan, it looks like it isn't " + candidateCiType + "/" + key + ": " + e);
                }
                if (type != null && key != null) {
                    try {
                        String cutDownYaml = key + ":\n" + BasicBrooklynCatalog.this.makeAsIndentedList("type: " + type);
                        DeploymentPlan candidatePlan = BasicBrooklynCatalog.this.makePlanFromYaml(cutDownYaml);
                        Object cutdownSpec = BasicBrooklynCatalog.this.createSpec(this.id, candidateCiType, candidatePlan, this.loader);
                        if (cutdownSpec != null) {
                            this.catalogItemType = candidateCiType;
                            this.planYaml = candidateYaml;
                            this.resolved = true;
                        }
                        return true;
                    }
                    catch (Exception e2) {
                        Exceptions.propagateIfFatal((Throwable)e2);
                    }
                }
                return false;
            }
        }

        public Map<?, ?> getItem() {
            return this.item;
        }
    }

    public static class BrooklynLoaderTracker {
        public static final ThreadLocal<BrooklynClassLoadingContext> loader = new ThreadLocal();

        public static void setLoader(BrooklynClassLoadingContext val) {
            loader.set(val);
        }

        public static void unsetLoader(BrooklynClassLoadingContext val) {
            loader.set(null);
        }

        public static BrooklynClassLoadingContext getLoader() {
            return loader.get();
        }
    }
}

