/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.catalog;

import brooklyn.catalog.CatalogItem;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.location.Location;
import brooklyn.location.LocationSpec;
import brooklyn.management.ManagementContext;
import brooklyn.management.entitlement.Entitlements;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import javax.annotation.Nullable;

public class CatalogPredicates {
    public static final Predicate<CatalogItem<Application, EntitySpec<? extends Application>>> IS_TEMPLATE = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.TEMPLATE);
    public static final Predicate<CatalogItem<Entity, EntitySpec<?>>> IS_ENTITY = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.ENTITY);
    public static final Predicate<CatalogItem<Policy, PolicySpec<?>>> IS_POLICY = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.POLICY);
    public static final Predicate<CatalogItem<Location, LocationSpec<?>>> IS_LOCATION = CatalogPredicates.isCatalogItemType(CatalogItem.CatalogItemType.LOCATION);
    public static final Function<CatalogItem<?, ?>, String> ID_OF_ITEM_TRANSFORMER = new Function<CatalogItem<?, ?>, String>(){

        @Nullable
        public String apply(@Nullable CatalogItem<?, ?> input) {
            if (input == null) {
                return null;
            }
            return input.getId();
        }
    };

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> isCatalogItemType(final CatalogItem.CatalogItemType ciType) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && item.getCatalogItemType() == ciType;
            }
        };
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> deprecated(final boolean deprecated) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && item.isDeprecated() == deprecated;
            }
        };
    }

    @Deprecated
    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> name(Predicate<? super String> filter) {
        return CatalogPredicates.displayName(filter);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> displayName(final Predicate<? super String> filter) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && filter.apply((Object)item.getDisplayName());
            }
        };
    }

    @Deprecated
    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> registeredTypeName(Predicate<? super String> filter) {
        return CatalogPredicates.symbolicName(filter);
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> symbolicName(final Predicate<? super String> filter) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && filter.apply((Object)item.getSymbolicName());
            }
        };
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> javaType(final Predicate<? super String> filter) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && filter.apply((Object)item.getJavaType());
            }
        };
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> xml(final Predicate<? super String> filter) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && filter.apply((Object)item.toXmlString());
            }
        };
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> entitledToSee(final ManagementContext mgmt) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return item != null && Entitlements.isEntitled(mgmt.getEntitlementManager(), Entitlements.SEE_CATALOG_ITEM, item.getCatalogItemId());
            }
        };
    }

    public static <T, SpecT> Predicate<CatalogItem<T, SpecT>> isBestVersion(final ManagementContext mgmt) {
        return new Predicate<CatalogItem<T, SpecT>>(){

            public boolean apply(@Nullable CatalogItem<T, SpecT> item) {
                return CatalogUtils.isBestVersion(mgmt, item);
            }
        };
    }
}

