/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.basic;

import brooklyn.basic.BrooklynDynamicType;
import brooklyn.basic.BrooklynObject;
import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.EnricherDynamicType;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.event.Sensor;
import brooklyn.location.Location;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.policy.basic.PolicyDynamicType;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.collect.Maps;
import java.util.Map;

public class BrooklynTypes {
    private static final Map<Class, BrooklynDynamicType<?, ?>> cache = Maps.newConcurrentMap();

    public static EntityDynamicType getDefinedEntityType(Class<? extends Entity> entityClass) {
        return (EntityDynamicType)BrooklynTypes.getDefinedBrooklynType(entityClass);
    }

    public static BrooklynDynamicType<?, ?> getDefinedBrooklynType(Class<? extends BrooklynObject> brooklynClass) {
        BrooklynDynamicType<?, ?> t = cache.get(brooklynClass);
        if (t != null) {
            return t;
        }
        return BrooklynTypes.loadDefinedBrooklynType(brooklynClass);
    }

    private static synchronized BrooklynDynamicType<?, ?> loadDefinedBrooklynType(Class<? extends BrooklynObject> brooklynClass) {
        BrooklynDynamicType type = cache.get(brooklynClass);
        if (type != null) {
            return type;
        }
        if (Entity.class.isAssignableFrom(brooklynClass)) {
            type = new ImmutableEntityType((Class<? extends Entity>)brooklynClass);
        } else if (Location.class.isAssignableFrom(brooklynClass)) {
            type = new ImmutableEntityType((Class<? extends Entity>)brooklynClass);
        } else if (Policy.class.isAssignableFrom(brooklynClass)) {
            type = new PolicyDynamicType((Class<? extends Policy>)brooklynClass);
        } else if (Enricher.class.isAssignableFrom(brooklynClass)) {
            type = new EnricherDynamicType((Class<? extends Enricher>)brooklynClass);
        } else {
            throw new IllegalStateException("Invalid brooklyn type " + brooklynClass);
        }
        cache.put(brooklynClass, type);
        return type;
    }

    public static Map<String, ConfigKey<?>> getDefinedConfigKeys(Class<? extends BrooklynObject> brooklynClass) {
        return BrooklynTypes.getDefinedBrooklynType(brooklynClass).getConfigKeys();
    }

    public static Map<String, ConfigKey<?>> getDefinedConfigKeys(String brooklynTypeName) {
        try {
            return BrooklynTypes.getDefinedConfigKeys(Class.forName(brooklynTypeName));
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public static Map<String, Sensor<?>> getDefinedSensors(Class<? extends Entity> entityClass) {
        return BrooklynTypes.getDefinedEntityType(entityClass).getSensors();
    }

    public static Map<String, Sensor<?>> getDefinedSensors(String entityTypeName) {
        try {
            return BrooklynTypes.getDefinedSensors(Class.forName(entityTypeName));
        }
        catch (ClassNotFoundException e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private static class ImmutableEntityType
    extends EntityDynamicType {
        public ImmutableEntityType(Class<? extends Entity> clazz) {
            super(clazz);
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSensor(Sensor<?> newSensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSensorIfAbsent(Sensor<?> newSensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Sensor<?> addSensorIfAbsentWithoutPublishing(Sensor<?> newSensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addSensors(Iterable<? extends Sensor<?>> newSensors) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeSensor(Sensor<?> sensor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Sensor<?> removeSensor(String sensorName) {
            throw new UnsupportedOperationException();
        }
    }
}

