/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.basic;

import brooklyn.basic.BrooklynType;
import brooklyn.config.ConfigKey;
import brooklyn.util.text.Strings;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;

public class BrooklynTypeSnapshot
implements BrooklynType {
    private static final long serialVersionUID = 4670930188951106009L;
    private final String name;
    private volatile transient String simpleName;
    private final Map<String, ConfigKey<?>> configKeys;
    private final Set<ConfigKey<?>> configKeysSet;

    protected BrooklynTypeSnapshot(String name, Map<String, ConfigKey<?>> configKeys) {
        this.name = name;
        this.configKeys = ImmutableMap.copyOf(configKeys);
        this.configKeysSet = ImmutableSet.copyOf(this.configKeys.values());
    }

    public String getName() {
        return this.name;
    }

    private String toSimpleName(String name) {
        String simpleName = name.substring(name.lastIndexOf(".") + 1);
        if (Strings.isBlank((CharSequence)simpleName)) {
            simpleName = name.trim();
        }
        return Strings.makeValidFilename((String)simpleName);
    }

    public String getSimpleName() {
        String sn = this.simpleName;
        if (sn == null) {
            this.simpleName = sn = this.toSimpleName(this.getName());
        }
        return sn;
    }

    public Set<ConfigKey<?>> getConfigKeys() {
        return this.configKeysSet;
    }

    public ConfigKey<?> getConfigKey(String name) {
        return this.configKeys.get(name);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.configKeys});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BrooklynTypeSnapshot)) {
            return false;
        }
        BrooklynTypeSnapshot o = (BrooklynTypeSnapshot)obj;
        return Objects.equal((Object)this.name, (Object)o.name) && Objects.equal(this.configKeys, o.configKeys);
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper((String)this.name).add("configKeys", this.configKeys);
    }
}

