/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.basic;

import brooklyn.camp.brooklyn.api.HasBrooklynManagementContext;
import brooklyn.config.ConfigKey;
import brooklyn.entity.trait.Configurable;
import brooklyn.entity.trait.Identifiable;
import brooklyn.management.ManagementContext;
import brooklyn.management.ManagementContextInjectable;
import brooklyn.management.Task;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.text.Identifiers;

public class BasicConfigurableObject
implements Configurable,
Identifiable,
ManagementContextInjectable,
HasBrooklynManagementContext {
    @SetFromFlag(value="id")
    private String id = Identifiers.makeRandomId((int)8);
    private volatile ManagementContext managementContext;
    private BasicConfigurationSupport config = new BasicConfigurationSupport();

    @Override
    public void injectManagementContext(ManagementContext managementContext) {
        this.managementContext = managementContext;
    }

    @Override
    public ManagementContext getBrooklynManagementContext() {
        return this.managementContext;
    }

    public String getId() {
        return this.id;
    }

    public Configurable.ConfigurationSupport config() {
        return this.config;
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, T value) {
        return (T)this.config().set(key, value);
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return (T)this.config().get(key);
    }

    private static class BasicConfigurationSupport
    implements Configurable.ConfigurationSupport {
        private final ConfigBag config = ConfigBag.newInstance();

        private BasicConfigurationSupport() {
        }

        public <T> T get(ConfigKey<T> key) {
            return this.config.get(key);
        }

        public <T> T get(ConfigKey.HasConfigKey<T> key) {
            return this.get(key.getConfigKey());
        }

        public <T> T set(ConfigKey<T> key, T val) {
            T old = this.config.get(key);
            this.config.configure(key, val);
            return old;
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, T val) {
            return this.set(key.getConfigKey(), val);
        }

        public <T> T set(ConfigKey<T> key, Task<T> val) {
            throw new UnsupportedOperationException();
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, Task<T> val) {
            return this.set(key.getConfigKey(), val);
        }
    }
}

