/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.basic;

import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.basic.internal.ApiObjectsFactory;
import brooklyn.entity.proxying.InternalFactory;
import brooklyn.entity.rebind.RebindManagerImpl;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.text.Identifiers;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBrooklynObject
implements BrooklynObjectInternal {
    private static final Logger log = LoggerFactory.getLogger(AbstractBrooklynObject.class);
    private boolean _legacyConstruction;
    private boolean hasWarnedOfNoManagementContextWhenPersistRequested;
    @SetFromFlag(value="id")
    private String id = Identifiers.makeRandomId((int)8);
    private String catalogItemId;
    @SetFromFlag(value="tags")
    private final Set<Object> tags = Sets.newLinkedHashSet();
    private volatile ManagementContext managementContext;

    public abstract void setDisplayName(String var1);

    public AbstractBrooklynObject() {
        this(Maps.newLinkedHashMap());
    }

    public AbstractBrooklynObject(Map<?, ?> properties) {
        boolean bl = this._legacyConstruction = !InternalFactory.FactoryConstructionTracker.isConstructing();
        if (!this._legacyConstruction && properties != null && !properties.isEmpty()) {
            log.warn("Forcing use of deprecated old-style construction for {} because properties were specified ({}); instead use specs (e.g. LocationSpec, EntitySpec, etc)", (Object)this.getClass().getName(), properties);
            if (log.isDebugEnabled()) {
                log.debug("Source of use of old-style construction", new Throwable("Source of use of old-style construction"));
            }
            this._legacyConstruction = true;
        }
        this.catalogItemId = ApiObjectsFactory.get().getCatalogItemIdFromContext();
    }

    @Deprecated
    protected AbstractBrooklynObject configure() {
        return this.configure(Collections.emptyMap());
    }

    @Deprecated
    protected abstract AbstractBrooklynObject configure(Map<?, ?> var1);

    protected boolean isLegacyConstruction() {
        return this._legacyConstruction;
    }

    public void init() {
    }

    public void rebind() {
    }

    public void setManagementContext(ManagementContextInternal managementContext) {
        this.managementContext = managementContext;
    }

    public ManagementContext getManagementContext() {
        return this.managementContext;
    }

    protected boolean isRebinding() {
        return RebindManagerImpl.RebindTracker.isRebinding();
    }

    protected void requestPersist() {
        if (this.getManagementContext() != null) {
            this.getManagementContext().getRebindManager().getChangeListener().onChanged((BrooklynObject)this);
        } else if (log.isTraceEnabled() && !this.hasWarnedOfNoManagementContextWhenPersistRequested) {
            log.trace("Cannot fulfil request to persist {} because it has no management context. This warning will not be logged for this object again.", (Object)this);
            this.hasWarnedOfNoManagementContextWhenPersistRequested = true;
        }
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void setCatalogItemId(String id) {
        this.catalogItemId = id;
    }

    public String getCatalogItemId() {
        return this.catalogItemId;
    }

    protected void onTagsChanged() {
        this.requestPersist();
    }

    public BrooklynObject.TagSupport tags() {
        return new BasicTagSupport();
    }

    @Deprecated
    public BrooklynObject.TagSupport getTagSupport() {
        return this.tags();
    }

    protected class BasicTagSupport
    implements BrooklynObject.TagSupport {
        protected BasicTagSupport() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Object> getTags() {
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                return ImmutableSet.copyOf((Collection)AbstractBrooklynObject.this.tags);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean containsTag(Object tag) {
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                return AbstractBrooklynObject.this.tags.contains(tag);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTag(Object tag) {
            boolean result;
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                result = AbstractBrooklynObject.this.tags.add(tag);
            }
            AbstractBrooklynObject.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addTags(Iterable<?> newTags) {
            boolean result;
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                result = Iterables.addAll((Collection)AbstractBrooklynObject.this.tags, newTags);
            }
            AbstractBrooklynObject.this.onTagsChanged();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeTag(Object tag) {
            boolean result;
            Set set = AbstractBrooklynObject.this.tags;
            synchronized (set) {
                result = AbstractBrooklynObject.this.tags.remove(tag);
            }
            AbstractBrooklynObject.this.onTagsChanged();
            return result;
        }
    }
}

