/*
 * Decompiled with CFR 0.152.
 */
package brooklyn;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.osgi.Osgis;
import brooklyn.util.stream.Streams;
import brooklyn.util.text.Strings;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.Attributes;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrooklynVersion {
    private static final Logger log = LoggerFactory.getLogger(BrooklynVersion.class);
    private static final String MVN_VERSION_RESOURCE_FILE = "META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final String BROOKLYN_CORE_SYMBOLIC_NAME = "org.apache.brooklyn.core";
    private static final String MVN_VERSION_PROPERTY_NAME = "version";
    private static final String OSGI_VERSION_PROPERTY_NAME = Attributes.Name.IMPLEMENTATION_VERSION.toString();
    private static final String OSGI_SHA1_PROPERTY_NAME = "Implementation-SHA-1";
    private static final String VERSION_FROM_STATIC = "0.7.0-20150614.2158";
    private static final AtomicReference<Boolean> IS_DEV_ENV = new AtomicReference();
    public static final BrooklynVersion INSTANCE = new BrooklynVersion();
    private final Properties versionProperties = new Properties();

    public BrooklynVersion() {
        this.readPropertiesFromMavenResource(BrooklynVersion.class.getClassLoader());
        this.readPropertiesFromOsgiResource(BrooklynVersion.class.getClassLoader(), BROOKLYN_CORE_SYMBOLIC_NAME);
        this.checkVersions();
    }

    public void checkVersions() {
        String mvnVersion = this.getVersionFromMavenProperties();
        if (mvnVersion != null && !VERSION_FROM_STATIC.equals(mvnVersion)) {
            throw new IllegalStateException("Version error: maven " + mvnVersion + " / code " + VERSION_FROM_STATIC);
        }
        String osgiVersion = this.versionProperties.getProperty(OSGI_VERSION_PROPERTY_NAME);
        if (osgiVersion != null && !VERSION_FROM_STATIC.equals(osgiVersion)) {
            throw new IllegalStateException("Version error: osgi " + osgiVersion + " / code " + VERSION_FROM_STATIC);
        }
    }

    @Deprecated
    public String getVersionFromClasspath() {
        String v = this.getVersionFromMavenProperties();
        if (Strings.isNonBlank((CharSequence)v)) {
            return v;
        }
        v = this.getVersionFromOsgiManifest();
        if (Strings.isNonBlank((CharSequence)v)) {
            return v;
        }
        return "0.0.0-SNAPSHOT";
    }

    @Nullable
    public String getVersionFromMavenProperties() {
        return this.versionProperties.getProperty(MVN_VERSION_PROPERTY_NAME);
    }

    @Nullable
    public String getVersionFromOsgiManifest() {
        return this.versionProperties.getProperty(OSGI_VERSION_PROPERTY_NAME);
    }

    @Nullable
    public String getSha1FromOsgiManifest() {
        return this.versionProperties.getProperty(OSGI_SHA1_PROPERTY_NAME);
    }

    public String getVersion() {
        return VERSION_FROM_STATIC;
    }

    public boolean isSnapshot() {
        return this.getVersion().indexOf("-SNAPSHOT") >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertiesFromMavenResource(ClassLoader resourceLoader) {
        InputStream versionStream = null;
        try {
            versionStream = resourceLoader.getResourceAsStream(MVN_VERSION_RESOURCE_FILE);
            if (versionStream == null) {
                if (BrooklynVersion.isDevelopmentEnvironment()) {
                    log.trace("No maven resource file META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties available");
                } else {
                    log.warn("No maven resource file META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties available");
                }
                return;
            }
            this.versionProperties.load((InputStream)Preconditions.checkNotNull((Object)versionStream));
        }
        catch (IOException e) {
            log.warn("Error reading maven resource file META-INF/maven/org.apache.brooklyn/brooklyn-core/pom.properties: " + e, (Throwable)e);
        }
        finally {
            Streams.closeQuietly((Closeable)versionStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPropertiesFromOsgiResource(ClassLoader resourceLoader, String symbolicName) {
        Enumeration<URL> paths;
        try {
            paths = BrooklynVersion.class.getClassLoader().getResources(MANIFEST_PATH);
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        while (paths.hasMoreElements()) {
            URL u = paths.nextElement();
            InputStream us = null;
            try {
                us = u.openStream();
                Osgis.ManifestHelper mh = Osgis.ManifestHelper.forManifest(us);
                if (!BROOKLYN_CORE_SYMBOLIC_NAME.equals(mh.getSymbolicName())) continue;
                Attributes attrs = mh.getManifest().getMainAttributes();
                for (Object key : attrs.keySet()) {
                    this.versionProperties.put(key.toString(), attrs.getValue(key.toString()));
                }
                return;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Error reading OSGi manifest from " + u + " when determining version properties: " + e, (Throwable)e);
            }
            finally {
                Streams.closeQuietly((Closeable)us);
            }
        }
        if (BrooklynVersion.isDevelopmentEnvironment()) {
            log.trace("No OSGi manifest available to determine version properties");
        } else {
            log.warn("No OSGi manifest available to determine version properties");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isDevelopmentEnvironment() {
        Boolean isDevEnv = IS_DEV_ENV.get();
        if (isDevEnv != null) {
            return isDevEnv;
        }
        AtomicReference<Boolean> atomicReference = IS_DEV_ENV;
        synchronized (atomicReference) {
            isDevEnv = BrooklynVersion.computeIsDevelopmentEnvironment();
            IS_DEV_ENV.set(isDevEnv);
            return isDevEnv;
        }
    }

    private static boolean computeIsDevelopmentEnvironment() {
        Enumeration<URL> paths;
        try {
            paths = BrooklynVersion.class.getClassLoader().getResources("brooklyn/BrooklynVersion.class");
        }
        catch (IOException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        while (paths.hasMoreElements()) {
            URL u = paths.nextElement();
            if (!u.getPath().endsWith("classes/brooklyn/BrooklynVersion.class")) continue;
            try {
                log.debug("Brooklyn dev/src environment detected: BrooklynVersion class is at: " + u);
                return true;
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                log.warn("Error reading manifest to determine whether this is a development environment: " + e, (Throwable)e);
            }
        }
        return false;
    }

    public void logSummary() {
        log.debug("Brooklyn version " + this.getVersion() + " (git SHA1 " + this.getSha1FromOsgiManifest() + ")");
    }

    @Deprecated
    public static String getVersionFromStatic() {
        return VERSION_FROM_STATIC;
    }

    public static String get() {
        return INSTANCE.getVersion();
    }
}

