/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.ec2.domain;

public enum ImageAttribute {
    PRODUCT_CODES,
    RAMDISK,
    KERNEL,
    LAUNCH_PERMISSION,
    PLATFORM,
    BLOCK_DEVICE_MAPPING,
    UNRECOGNIZED;


    public String value() {
        switch (this) {
            case PRODUCT_CODES: {
                return "productCodes";
            }
            case RAMDISK: {
                return "ramdisk";
            }
            case KERNEL: {
                return "kernel";
            }
            case LAUNCH_PERMISSION: {
                return "launchPermission";
            }
            case PLATFORM: {
                return "platform";
            }
            case BLOCK_DEVICE_MAPPING: {
                return "blockDeviceMapping";
            }
        }
        throw new IllegalArgumentException("unmapped attribute: " + super.name());
    }

    public String toString() {
        return this.value();
    }

    public static ImageAttribute fromValue(String attribute) {
        if ("productCodes".equals(attribute)) {
            return PRODUCT_CODES;
        }
        if ("ramdisk".equals(attribute)) {
            return RAMDISK;
        }
        if ("kernel".equals(attribute)) {
            return KERNEL;
        }
        if ("launchPermission".equals(attribute)) {
            return LAUNCH_PERMISSION;
        }
        if ("platform".equals(attribute)) {
            return PLATFORM;
        }
        if ("blockDeviceMapping".equals(attribute)) {
            return BLOCK_DEVICE_MAPPING;
        }
        return UNRECOGNIZED;
    }
}

