/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.rest.util;

import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Urls;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.dto.ApplicationComponentDto;
import io.brooklyn.camp.dto.ApplicationComponentTemplateDto;
import io.brooklyn.camp.dto.AssemblyDto;
import io.brooklyn.camp.dto.AssemblyTemplateDto;
import io.brooklyn.camp.dto.PlatformComponentDto;
import io.brooklyn.camp.dto.PlatformComponentTemplateDto;
import io.brooklyn.camp.dto.PlatformDto;
import io.brooklyn.camp.rest.resource.AbstractCampRestResource;
import io.brooklyn.camp.rest.resource.ApplicationComponentRestResource;
import io.brooklyn.camp.rest.resource.ApplicationComponentTemplateRestResource;
import io.brooklyn.camp.rest.resource.AssemblyRestResource;
import io.brooklyn.camp.rest.resource.AssemblyTemplateRestResource;
import io.brooklyn.camp.rest.resource.PlatformComponentRestResource;
import io.brooklyn.camp.rest.resource.PlatformComponentTemplateRestResource;
import io.brooklyn.camp.rest.resource.PlatformRestResource;
import io.brooklyn.camp.rest.util.CampRestGuavas;
import io.brooklyn.camp.spi.AbstractResource;
import io.brooklyn.camp.spi.ApplicationComponent;
import io.brooklyn.camp.spi.ApplicationComponentTemplate;
import io.brooklyn.camp.spi.Assembly;
import io.brooklyn.camp.spi.AssemblyTemplate;
import io.brooklyn.camp.spi.PlatformComponent;
import io.brooklyn.camp.spi.PlatformComponentTemplate;
import io.brooklyn.camp.spi.PlatformRootSummary;
import java.util.Map;
import javax.ws.rs.Path;

public class DtoFactory {
    private CampPlatform platform;
    private String uriBase;
    private UriFactory uriFactory;

    public DtoFactory(CampPlatform campPlatform, String uriBase) {
        this.platform = campPlatform;
        this.uriBase = uriBase;
        this.uriFactory = new UriFactory();
        this.uriFactory.registerIdentifiableRestResource(PlatformRootSummary.class, PlatformRestResource.class);
        this.uriFactory.registerIdentifiableRestResource(AssemblyTemplate.class, AssemblyTemplateRestResource.class);
        this.uriFactory.registerIdentifiableRestResource(PlatformComponentTemplate.class, PlatformComponentTemplateRestResource.class);
        this.uriFactory.registerIdentifiableRestResource(ApplicationComponentTemplate.class, ApplicationComponentTemplateRestResource.class);
        this.uriFactory.registerIdentifiableRestResource(Assembly.class, AssemblyRestResource.class);
        this.uriFactory.registerIdentifiableRestResource(PlatformComponent.class, PlatformComponentRestResource.class);
        this.uriFactory.registerIdentifiableRestResource(ApplicationComponent.class, ApplicationComponentRestResource.class);
    }

    public CampPlatform getPlatform() {
        return this.platform;
    }

    public UriFactory getUriFactory() {
        return this.uriFactory;
    }

    public String uri(AbstractResource x) {
        return this.getUriFactory().uri(x);
    }

    public String uri(Class<? extends AbstractResource> targetType, String id) {
        return this.getUriFactory().uri(targetType, id);
    }

    public AssemblyTemplateDto adapt(AssemblyTemplate assemblyTemplate) {
        return AssemblyTemplateDto.newInstance(this, assemblyTemplate);
    }

    public PlatformComponentTemplateDto adapt(PlatformComponentTemplate platformComponentTemplate) {
        return PlatformComponentTemplateDto.newInstance(this, platformComponentTemplate);
    }

    public ApplicationComponentTemplateDto adapt(ApplicationComponentTemplate applicationComponentTemplate) {
        return ApplicationComponentTemplateDto.newInstance(this, applicationComponentTemplate);
    }

    public AssemblyDto adapt(Assembly assembly) {
        return AssemblyDto.newInstance(this, assembly);
    }

    public PlatformComponentDto adapt(PlatformComponent platformComponent) {
        return PlatformComponentDto.newInstance(this, platformComponent);
    }

    public ApplicationComponentDto adapt(ApplicationComponent applicationComponent) {
        return ApplicationComponentDto.newInstance(this, applicationComponent);
    }

    public PlatformDto adapt(PlatformRootSummary root) {
        return PlatformDto.newInstance(this, root);
    }

    public class UriFactory {
        Map<Class<?>, Function<Object, String>> registryResource = new MutableMap();
        Map<Class<?>, Function<String, String>> registryId = new MutableMap();

        public synchronized <T> void registerResourceUriFunction(Class<T> type, Function<T, String> fnUri) {
            this.registryResource.put(type, fnUri);
        }

        public synchronized <T> void registerIdentityFunction(Class<T> type, final String resourceTypeUriBase, Function<T, String> fnIdentity) {
            Function<String, String> fnUriFromId = new Function<String, String>(){

                public String apply(String id) {
                    return Urls.mergePaths((String[])new String[]{resourceTypeUriBase, id});
                }
            };
            this.registryId.put(type, fnUriFromId);
            this.registerResourceUriFunction(type, new Function<T, String>((Function)fnUriFromId, fnIdentity){
                final /* synthetic */ Function val$fnUriFromId;
                final /* synthetic */ Function val$fnIdentity;
                {
                    this.val$fnUriFromId = function;
                    this.val$fnIdentity = function2;
                }

                public String apply(T input) {
                    return (String)this.val$fnUriFromId.apply(this.val$fnIdentity.apply(input));
                }
            });
        }

        public synchronized <T extends AbstractResource> void registerIdentifiableRestResource(Class<T> type, Class<? extends AbstractCampRestResource> restResource) {
            this.registerIdentityFunction(type, this.uriOfRestResource(restResource), CampRestGuavas.IDENTITY_OF_REST_RESOURCE);
        }

        public String uri(Class<? extends AbstractResource> targetType, String id) {
            return (String)((Function)Preconditions.checkNotNull(this.registryId.get(targetType), (String)"No REST ID converter registered for %s (id %s)", (Object[])new Object[]{targetType, id})).apply((Object)id);
        }

        public String uri(AbstractResource x) {
            return (String)((Function)Preconditions.checkNotNull(this.registryResource.get(x.getClass()), (String)"No REST converter registered for %s (%s)", (Object[])new Object[]{x.getClass(), x})).apply((Object)x);
        }

        public String uriOfRestResource(Class<?> restResourceClass) {
            return Urls.mergePaths((String[])new String[]{DtoFactory.this.uriBase, ((Path)Preconditions.checkNotNull((Object)restResourceClass.getAnnotation(Path.class), (String)"No @Path on type %s", (Object[])new Object[]{restResourceClass})).value()});
        }
    }
}

