/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.rest.resource;

import brooklyn.rest.apidoc.Apidoc;
import com.wordnik.swagger.core.ApiOperation;
import io.brooklyn.camp.dto.PlatformDto;
import io.brooklyn.camp.rest.resource.AbstractCampRestResource;
import io.brooklyn.camp.rest.util.WebResourceUtils;
import io.brooklyn.camp.spi.AssemblyTemplate;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/camp/v11")
@Apidoc(value="Platform (root)")
@Produces(value={"application/json"})
public class PlatformRestResource
extends AbstractCampRestResource {
    private static final Logger log = LoggerFactory.getLogger(PlatformRestResource.class);
    public static final String CAMP_URI_PATH = "/camp/v11";

    @ApiOperation(value="Return the Platform (root) resource", responseClass="io.brooklyn.camp.dto.PlatformDto")
    @GET
    public PlatformDto get() {
        return this.dto().adapt(this.camp().root());
    }

    @POST
    @Consumes(value={"application/json"})
    public Response postJson(@Context UriInfo info, String json) {
        return this.postYaml(info, json);
    }

    @POST
    @Consumes(value={"application/x-yaml"})
    public Response postYaml(@Context UriInfo info, String yaml) {
        log.debug("YAML pdp:\n" + yaml);
        AssemblyTemplate template = this.camp().pdp().registerDeploymentPlan((Reader)new StringReader(yaml));
        return this.created(info, template);
    }

    @POST
    @Consumes(value={"application/x-tar", "application/x-tgz", "application/x-zip"})
    public Response postArchive(@Context UriInfo info, InputStream archiveInput) {
        log.debug("ARCHIVE pdp");
        AssemblyTemplate template = this.camp().pdp().registerPdpFromArchive(archiveInput);
        return this.created(info, template);
    }

    protected Response created(UriInfo info, AssemblyTemplate template) {
        return WebResourceUtils.created(info, this.dto().adapt(template).getUri());
    }
}

