/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import io.brooklyn.camp.dto.LinkDto;
import io.brooklyn.camp.dto.ResourceDto;
import io.brooklyn.camp.rest.util.DtoFactory;
import io.brooklyn.camp.spi.AbstractResource;
import io.brooklyn.camp.spi.ApplicationComponent;
import io.brooklyn.camp.spi.Link;
import io.brooklyn.camp.spi.PlatformComponent;
import java.util.ArrayList;
import java.util.List;

public class PlatformComponentDto
extends ResourceDto {
    public static final String CLASS_NAME = "io.brooklyn.camp.dto.PlatformComponentDto";
    private List<LinkDto> platformComponents;
    private List<LinkDto> applicationComponents;
    private String externalManagementUri;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected PlatformComponentDto() {
    }

    protected PlatformComponentDto(DtoFactory dtoFactory, PlatformComponent x) {
        super(dtoFactory, (AbstractResource)x);
        this.setExternalManagementUri(x.getExternalManagementUri());
        this.platformComponents = new ArrayList<LinkDto>();
        for (Link t : x.getPlatformComponents().links()) {
            this.platformComponents.add(LinkDto.newInstance(dtoFactory, PlatformComponent.class, t));
        }
        this.applicationComponents = new ArrayList<LinkDto>();
        for (Link t : x.getApplicationComponents().links()) {
            this.applicationComponents.add(LinkDto.newInstance(dtoFactory, ApplicationComponent.class, t));
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LinkDto> getPlatformComponents() {
        return this.platformComponents;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<LinkDto> getApplicationComponents() {
        return this.applicationComponents;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getExternalManagementUri() {
        return this.externalManagementUri;
    }

    private void setExternalManagementUri(String externalManagementUri) {
        this.externalManagementUri = externalManagementUri;
    }

    public static PlatformComponentDto newInstance(DtoFactory dtoFactory, PlatformComponent x) {
        return new PlatformComponentDto(dtoFactory, x);
    }

    static {
        boolean bl = $assertionsDisabled = !PlatformComponentDto.class.desiredAssertionStatus();
        if (!$assertionsDisabled && !CLASS_NAME.equals(PlatformComponentDto.class.getCanonicalName())) {
            throw new AssertionError();
        }
    }
}

