/*
 * Decompiled with CFR 0.152.
 */
package io.brooklyn.camp;

import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.Networking;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.sun.jersey.api.core.DefaultResourceConfig;
import com.sun.jersey.spi.container.servlet.ServletContainer;
import io.brooklyn.camp.CampPlatform;
import io.brooklyn.camp.CampRestResources;
import io.brooklyn.camp.rest.util.DtoFactory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.ws.rs.core.Application;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.eclipse.jetty.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CampServer {
    private static final Logger log = LoggerFactory.getLogger(CampServer.class);
    public static final String CAMP_PLATFORM_ATTRIBUTE = CampPlatform.class.getCanonicalName();
    public static final String DTO_FACTORY = DtoFactory.class.getCanonicalName();
    private final CampPlatform platform;
    private final String uriBase;
    private DtoFactory dtoFactory;
    WebAppContext webAppContext;
    Server server;

    public CampServer(CampPlatform platform, String uriBase) {
        this.platform = platform;
        this.uriBase = uriBase;
    }

    public CampPlatform getPlatform() {
        return this.platform;
    }

    public String getUriBase() {
        return this.uriBase;
    }

    public WebAppContext getWebAppContext() {
        return this.webAppContext;
    }

    public synchronized DtoFactory getDtoFactory() {
        if (this.dtoFactory != null) {
            return this.dtoFactory;
        }
        this.dtoFactory = this.createDtoFactory();
        return this.dtoFactory;
    }

    protected DtoFactory createDtoFactory() {
        return new DtoFactory(this.getPlatform(), this.getUriBase());
    }

    public synchronized CampServer start() {
        if (this.webAppContext != null) {
            throw new IllegalStateException("Already started");
        }
        this.webAppContext = new WebAppContext();
        this.webAppContext.setContextPath("/");
        this.webAppContext.setAttribute(CAMP_PLATFORM_ATTRIBUTE, (Object)this.getPlatform());
        this.webAppContext.setAttribute(DTO_FACTORY, (Object)this.getDtoFactory());
        this.webAppContext.setWar(CampServerUtils.createTempWebDirWithIndexHtml("CAMP REST API <p> (no gui available - rest endpoint at <a href=\"/camp/v11\">/camp/v11</a>)"));
        CampServerUtils.installAsServletFilter((ServletContextHandler)this.webAppContext);
        this.server = CampServerUtils.startServer((ContextHandler)this.webAppContext, "CAMP server");
        return this;
    }

    public synchronized void stop() {
        try {
            this.server.stop();
            this.server = null;
            this.webAppContext.stop();
            this.webAppContext = null;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
    }

    public Integer getPort() {
        if (this.server == null) {
            return null;
        }
        return this.server.getConnectors()[0].getLocalPort();
    }

    public static class CampServerUtils {
        public static void installAsServletFilter(ServletContextHandler context) {
            DefaultResourceConfig config = new DefaultResourceConfig();
            for (Object r : CampRestResources.getAllResources()) {
                config.getSingletons().add(r);
            }
            config.getProperties().put("com.sun.jersey.config.property.WebPageContentRegex", "(/?|[^?]*/assets/[^?]+\\.[A-Za-z0-9_]+)");
            config.getFeatures().put("com.sun.jersey.config.feature.FilterForwardOn404", true);
            FilterHolder filterHolder = new FilterHolder((Filter)new ServletContainer((Application)config));
            context.addFilter(filterHolder, "/*", EnumSet.allOf(DispatcherType.class));
        }

        public static Server startServer(ContextHandler context, String summary) {
            int port = Networking.nextAvailablePort((int)8080);
            Server server = new Server(port);
            server.setHandler((Handler)context);
            QueuedThreadPool threadPool = new QueuedThreadPool();
            threadPool.setName("camp-jetty-server-" + port + "-" + threadPool.getName());
            server.setThreadPool((ThreadPool)threadPool);
            try {
                server.start();
            }
            catch (Exception e) {
                throw Exceptions.propagate((Throwable)e);
            }
            log.info("CAMP REST server started (" + summary + ") on");
            log.info("  http://localhost:" + server.getConnectors()[0].getLocalPort() + "/");
            return server;
        }

        public static String createTempWebDirWithIndexHtml(String indexHtmlContent) {
            File dir = Files.createTempDir();
            dir.deleteOnExit();
            try {
                Files.write((CharSequence)indexHtmlContent, (File)new File(dir, "index.html"), (Charset)Charsets.UTF_8);
            }
            catch (IOException e) {
                Exceptions.propagate((Throwable)e);
            }
            return dir.getAbsolutePath();
        }
    }
}

