/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.rubyrep;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.rubyrep.RubyRepDriver;
import brooklyn.entity.database.rubyrep.RubyRepNode;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.util.time.Duration;
import java.net.URI;

public class RubyRepNodeImpl
extends SoftwareProcessImpl
implements RubyRepNode {
    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
    }

    public void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        super.disconnectSensors();
    }

    protected void preStart() {
        DatastoreMixins.DatastoreCommon rightNode;
        super.preStart();
        DatastoreMixins.DatastoreCommon leftNode = (DatastoreMixins.DatastoreCommon)this.getConfig(LEFT_DATABASE);
        if (leftNode != null) {
            this.setAttribute(LEFT_DATASTORE_URL, ((Task)Entities.submit((Entity)this, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)leftNode, (AttributeSensor)DatastoreMixins.DatastoreCommon.DATASTORE_URL))).getUnchecked(this.getDatabaseStartupDelay()));
        }
        if ((rightNode = (DatastoreMixins.DatastoreCommon)this.getConfig(RIGHT_DATABASE)) != null) {
            this.setAttribute(RIGHT_DATASTORE_URL, ((Task)Entities.submit((Entity)this, (TaskAdaptable)DependentConfiguration.attributeWhenReady((Entity)rightNode, (AttributeSensor)DatastoreMixins.DatastoreCommon.DATASTORE_URL))).getUnchecked(this.getDatabaseStartupDelay()));
        }
    }

    public Class<?> getDriverInterface() {
        return RubyRepDriver.class;
    }

    public Duration getDatabaseStartupDelay() {
        return Duration.seconds((Number)((Number)this.getConfig(DATABASE_STARTUP_TIMEOUT)));
    }

    public int getReplicationInterval() {
        return (Integer)this.getConfig(REPLICATION_INTERVAL);
    }

    public String getTableRegex() {
        return (String)this.getConfig(TABLE_REGEXP);
    }

    public URI getLeftDatabaseUrl() {
        return URI.create((String)this.getAttribute(LEFT_DATASTORE_URL));
    }

    public String getLeftDatabaseName() {
        return (String)this.getConfig(LEFT_DATABASE_NAME);
    }

    public String getLeftUsername() {
        return (String)this.getConfig(LEFT_USERNAME);
    }

    public String getLeftPassword() {
        return (String)this.getConfig(LEFT_PASSWORD);
    }

    public URI getRightDatabaseUrl() {
        return URI.create((String)this.getAttribute(RIGHT_DATASTORE_URL));
    }

    public String getRightDatabaseName() {
        return (String)this.getConfig(RIGHT_DATABASE_NAME);
    }

    public String getRightUsername() {
        return (String)this.getConfig(RIGHT_USERNAME);
    }

    public String getRightPassword() {
        return (String)this.getConfig(RIGHT_PASSWORD);
    }
}

