/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.rubyrep;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.rubyrep.RubyRepNodeImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="RubyRep Node", description="RubyRep is a database replication system", iconUrl="classpath:///rubyrep-logo.jpeg")
@ImplementedBy(value=RubyRepNodeImpl.class)
public interface RubyRepNode
extends SoftwareProcess {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"1.2.0");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey((AttributeSensorAndConfigKey)Attributes.DOWNLOAD_URL, "http://files.rubyforge.vm.bytemark.co.uk/rubyrep/rubyrep-${version}.zip");
    @SetFromFlag(value="configurationScriptUrl")
    public static final ConfigKey<String> CONFIGURATION_SCRIPT_URL = ConfigKeys.newStringConfigKey((String)"database.rubyrep.configScriptUrl", (String)"URL where RubyRep configuration can be found - disables other configuration options (except version)");
    @SetFromFlag(value="templateUrl")
    public static final ConfigKey<String> TEMPLATE_CONFIGURATION_URL = ConfigKeys.newStringConfigKey((String)"database.rubyrep.templateConfigurationUrl", (String)"Template file (in freemarker format) for the rubyrep.conf file", (String)"classpath://brooklyn/entity/database/rubyrep/rubyrep.conf");
    @SetFromFlag(value="tables")
    public static final ConfigKey<String> TABLE_REGEXP = ConfigKeys.newStringConfigKey((String)"database.rubyrep.tableRegex", (String)"Regular expression to select tables to sync using RubyRep", (String)".");
    @SetFromFlag(value="replicationInterval")
    public static final ConfigKey<Integer> REPLICATION_INTERVAL = ConfigKeys.newIntegerConfigKey((String)"database.rubyrep.replicationInterval", (String)"Replication Interval", (Integer)30);
    @SetFromFlag(value="startupTimeout")
    public static final ConfigKey<Integer> DATABASE_STARTUP_TIMEOUT = ConfigKeys.newIntegerConfigKey((String)"database.rubyrep.startupTimeout", (String)"Time to wait until databases have started up (in seconds)", (Integer)120);
    public static final AttributeSensor<String> LEFT_DATASTORE_URL = Sensors.newSensorWithPrefix((String)"left", DatastoreMixins.DATASTORE_URL);
    @SetFromFlag(value="leftDatabase")
    public static final ConfigKey<? extends DatastoreMixins.DatastoreCommon> LEFT_DATABASE = ConfigKeys.newConfigKey(DatastoreMixins.DatastoreCommon.class, (String)"database.rubyrep.leftDatabase", (String)"Brooklyn database entity to use as the left DBMS");
    @SetFromFlag(value="leftDatabaseName")
    public static final ConfigKey<String> LEFT_DATABASE_NAME = ConfigKeys.newStringConfigKey((String)"database.rubyrep.leftDatabaseName", (String)"name of database to use for left db");
    @SetFromFlag(value="leftUsername")
    public static final ConfigKey<String> LEFT_USERNAME = ConfigKeys.newStringConfigKey((String)"database.rubyrep.leftUsername", (String)"username to connect to left db");
    @SetFromFlag(value="leftPassword")
    public static final ConfigKey<String> LEFT_PASSWORD = ConfigKeys.newStringConfigKey((String)"database.rubyrep.leftPassword", (String)"password to connect to left db");
    public static final AttributeSensor<String> RIGHT_DATASTORE_URL = Sensors.newSensorWithPrefix((String)"right", DatastoreMixins.DATASTORE_URL);
    @SetFromFlag(value="rightDatabase")
    public static final ConfigKey<? extends DatastoreMixins.DatastoreCommon> RIGHT_DATABASE = ConfigKeys.newConfigKey(DatastoreMixins.DatastoreCommon.class, (String)"database.rubyrep.rightDatabase", (String)"Brooklyn database entity to use as the right DBMS");
    @SetFromFlag(value="rightDatabaseName")
    public static final ConfigKey<String> RIGHT_DATABASE_NAME = ConfigKeys.newStringConfigKey((String)"database.rubyrep.rightDatabaseName", (String)"name of database to use for right db");
    @SetFromFlag(value="rightUsername")
    public static final ConfigKey<String> RIGHT_USERNAME = ConfigKeys.newStringConfigKey((String)"database.rubyrep.rightUsername", (String)"username to connect to right db");
    @SetFromFlag(value="rightPassword")
    public static final ConfigKey<String> RIGHT_PASSWORD = ConfigKeys.newStringConfigKey((String)"database.rubyrep.rightPassword", (String)"password to connect to right db");
}

