/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.postgresql;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.postgresql.PostgreSqlDriver;
import brooklyn.entity.database.postgresql.PostgreSqlNode;
import brooklyn.entity.database.postgresql.PostgreSqlNodeImpl;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.AttributeSensor;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskFactory;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.ssh.SshTasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.StringFunctions;
import brooklyn.util.text.Strings;
import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlSshDriver
extends AbstractSoftwareProcessSshDriver
implements PostgreSqlDriver {
    public static final Logger log = LoggerFactory.getLogger(PostgreSqlSshDriver.class);

    public PostgreSqlSshDriver(PostgreSqlNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.setAttribute(Attributes.LOG_FILE_LOCATION, this.getLogFile());
    }

    public void install() {
        String version = (String)this.getEntity().getConfig(SoftwareProcess.SUGGESTED_VERSION);
        String majorMinorVersion = version.substring(0, version.lastIndexOf("-"));
        String shortVersion = majorMinorVersion.replace(".", "");
        String altTarget = "/opt/brooklyn/postgres/";
        String altInstallDir = Urls.mergePaths((String[])new String[]{altTarget, "install/" + majorMinorVersion});
        ImmutableList pgctlLocations = ImmutableList.of((Object)(altInstallDir + "/bin"), (Object)("/usr/lib/postgresql/" + majorMinorVersion + "/bin/"), (Object)("/opt/local/lib/postgresql" + shortVersion + "/bin/"), (Object)("/usr/pgsql-" + majorMinorVersion + "/bin"), (Object)"/usr/local/bin/", (Object)"/usr/bin/", (Object)"/bin/");
        DynamicTasks.queueIfPossible((TaskFactory)SshTasks.dontRequireTtyForSudo((SshMachineLocation)this.getMachine(), (SshTasks.OnFailingTask)SshTasks.OnFailingTask.FAIL)).orSubmitAndBlock();
        DynamicTasks.waitForLast();
        MutableList findOrInstall = MutableList.of().append((Object)"which pg_ctl").appendAll(Iterables.transform((Iterable)pgctlLocations, (Function)StringFunctions.formatter((String)"test -x %s/pg_ctl"))).append((Object)BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)("postgresql" + shortVersion + " postgresql" + shortVersion + "-server"), (Object)"apt", (Object)("postgresql-" + majorMinorVersion), (Object)"port", (Object)("postgresql" + shortVersion + " postgresql" + shortVersion + "-server")), null)).append((Object)BashCommands.warn((String)String.format("WARNING: failed to find or install postgresql %s binaries", majorMinorVersion)));
        MutableList linkFromHere = MutableList.of().append((Object)BashCommands.ifExecutableElse1((String)"pg_ctl", (String)BashCommands.chainGroup((String[])new String[]{"PG_EXECUTABLE=`which pg_ctl`", "PG_DIR=`dirname $PG_EXECUTABLE`", "echo 'found pg_ctl in '$PG_DIR' on path so linking PG bin/ to that dir'", "ln -s $PG_DIR bin"}))).appendAll(Iterables.transform((Iterable)pgctlLocations, PostgreSqlSshDriver.givenDirIfFileExistsInItLinkToDir("pg_ctl", "bin"))).append((Object)BashCommands.fail((String)String.format("WARNING: failed to find postgresql %s binaries for pg_ctl, may already have another version installed; aborting", majorMinorVersion), (int)9));
        this.newScript((String)"installing").body.append(new CharSequence[]{BashCommands.dontRequireTtyForSudo(), BashCommands.ifExecutableElse0((String)"yum", (String)this.getYumRepository(version, majorMinorVersion, shortVersion)), BashCommands.ifExecutableElse0((String)"apt-get", (String)this.getAptRepository()), "rm -f bin", BashCommands.alternativesGroup((Collection)findOrInstall), BashCommands.alternativesGroup((Collection)linkFromHere)}).failOnNonZeroResultCode().queue();
        if ((Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudoAsUser((String)"postgres", (String)("ls " + this.getInstallDir()))}).allowingNonZeroExitCode()).summary("check postgres user can access install dir"))).asTask().getUnchecked() != 0) {
            log.info("Postgres install dir " + this.getInstallDir() + " for " + this.getEntity() + " is not accessible to user 'postgres'; " + "using " + altInstallDir + " instead");
            String newRunDir = Urls.mergePaths((String[])new String[]{altTarget, "apps", this.getEntity().getApplication().getId(), this.getEntity().getId()});
            if ((Integer)((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"ls " + altInstallDir + "/pg_ctl"}).allowingNonZeroExitCode()).summary("check whether " + altInstallDir + " is set up"))).asTask().getUnchecked() != 0) {
                DynamicTasks.queue((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"mkdir -p " + altInstallDir, "rm -rf '" + altInstallDir + "'", "mv " + this.getInstallDir() + " " + altInstallDir, "rm -rf '" + this.getInstallDir() + "'", "ln -s " + altInstallDir + " " + this.getInstallDir(), "mkdir -p " + newRunDir, "chown -R postgres:postgres " + altTarget}).runAsRoot()).requiringExitCodeZero()).summary("move install dir from user to postgres owned space"));
            }
            DynamicTasks.waitForLast();
            this.setInstallDir(altInstallDir);
            this.setRunDir(newRunDir);
        }
    }

    private String getYumRepository(String version, String majorMinorVersion, String shortVersion) {
        OsDetails osDetails = this.getMachine().getMachineDetails().getOsDetails();
        String arch = osDetails.getArch();
        String osMajorVersion = osDetails.getVersion();
        String osName = osDetails.getName();
        log.debug("postgres detecting yum information for " + this.getEntity() + " at " + this.getMachine() + ": " + osName + ", " + osMajorVersion + ", " + arch);
        osName = osName == null ? "" : osName.toLowerCase();
        if (osName.equals("ubuntu")) {
            return "echo skipping yum repo setup as this is not an rpm environment";
        }
        if (osName.equals("rhel")) {
            osName = "redhat";
        } else if (osName.equals("centos")) {
            osName = "centos";
        } else if (osName.equals("sl") || osName.startsWith("scientific")) {
            osName = "sl";
        } else if (osName.equals("fedora")) {
            osName = "fedora";
        } else {
            log.debug("insufficient OS family information '" + osName + "' for " + this.getMachine() + " when installing " + this.getEntity() + " (yum repos); treating as centos");
            osName = "centos";
        }
        if (Strings.isBlank((CharSequence)arch)) {
            log.warn("Insuffient architecture information '" + arch + "' for " + this.getMachine() + "when installing " + this.getEntity() + "; treating as x86_64");
            arch = "x86_64";
        }
        if (Strings.isBlank((CharSequence)osMajorVersion)) {
            osMajorVersion = osName.equals("fedora") ? "20" : "6";
            log.warn("Insuffient OS version information '" + this.getMachine().getOsDetails().getVersion() + "' for " + this.getMachine() + "when installing " + this.getEntity() + " (yum repos); treating as " + osMajorVersion);
        } else if (osMajorVersion.indexOf(".") > 0) {
            osMajorVersion = osMajorVersion.substring(0, osMajorVersion.indexOf(46));
        }
        return BashCommands.chainGroup((String[])new String[]{BashCommands.INSTALL_WGET, BashCommands.sudo((String)String.format("wget http://yum.postgresql.org/%s/redhat/rhel-%s-%s/pgdg-%s%s-%s.noarch.rpm", majorMinorVersion, osMajorVersion, arch, osName, shortVersion, version)), BashCommands.sudo((String)String.format("rpm -Uvh pgdg-%s%s-%s.noarch.rpm", osName, shortVersion, version))});
    }

    private String getAptRepository() {
        return BashCommands.chainGroup((String[])new String[]{BashCommands.INSTALL_WGET, "wget --quiet -O - http://apt.postgresql.org/pub/repos/apt/ACCC4CF8.asc | sudo tee -a apt-key add -", "echo \"deb http://apt.postgresql.org/pub/repos/apt/   $(sudo lsb_release --codename --short)-pgdg main\" | sudo tee -a /etc/apt/sources.list.d/postgresql.list"});
    }

    private static Function<String, String> givenDirIfFileExistsInItLinkToDir(final String filename, final String linkToMake) {
        return new Function<String, String>(){

            public String apply(@Nullable String dir) {
                return BashCommands.ifExecutableElse1((String)Urls.mergePaths((String[])new String[]{dir, filename}), (String)BashCommands.chainGroup((String[])new String[]{"echo 'found " + filename + " in " + dir + " so linking to it in " + linkToMake + "'", "ln -s " + dir + " " + linkToMake}));
            }
        };
    }

    public void customize() {
        ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudoAsUser((String)"postgres", (String)"/etc/init.d/postgresql stop")}).allowingNonZeroExitCode())).get();
        this.newScript((String)"customizing").body.append(new CharSequence[]{BashCommands.sudo((String)("mkdir -p " + this.getDataDir())), BashCommands.sudo((String)("chown postgres:postgres " + this.getDataDir())), BashCommands.sudo((String)("chmod 700 " + this.getDataDir())), BashCommands.sudo((String)("touch " + this.getLogFile())), BashCommands.sudo((String)("chown postgres:postgres " + this.getLogFile())), BashCommands.sudo((String)("touch " + this.getPidFile())), BashCommands.sudo((String)("chown postgres:postgres " + this.getPidFile())), BashCommands.alternativesGroup((String[])new String[]{BashCommands.chainGroup((String[])new String[]{String.format("test -e %s", this.getInstallDir() + "/bin/initdb"), BashCommands.sudoAsUser((String)"postgres", (String)(this.getInstallDir() + "/bin/initdb -D " + this.getDataDir()))}), this.callPgctl("initdb", true)})}).failOnNonZeroResultCode().execute();
        String configUrl = (String)this.getEntity().getConfig(PostgreSqlNode.CONFIGURATION_FILE_URL);
        if (Strings.isBlank((CharSequence)configUrl)) {
            DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.executeCommandThenAsUserTeeOutputToFile((String)BashCommands.chainGroup((String[])new String[]{"echo \"listen_addresses = '*'\"", "echo \"port = " + this.getEntity().getPostgreSqlPort() + "\"", "echo \"max_connections = " + this.getEntity().getMaxConnections() + "\"", "echo \"shared_buffers = " + this.getEntity().getSharedMemory() + "\"", "echo \"external_pid_file = '" + this.getPidFile() + "'\""}), (String)"postgres", (String)(this.getDataDir() + "/postgresql.conf"))}));
        } else {
            String contents = this.processTemplate(configUrl);
            DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)"/tmp/postgresql.conf").contents(contents), (TaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudoAsUser((String)"postgres", (String)("cp /tmp/postgresql.conf " + this.getDataDir() + "/postgresql.conf"))}), (TaskFactory[])new TaskFactory[0]);
        }
        String authConfigUrl = (String)this.getEntity().getConfig(PostgreSqlNode.AUTHENTICATION_CONFIGURATION_FILE_URL);
        if (Strings.isBlank((CharSequence)authConfigUrl)) {
            DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.executeCommandThenAsUserTeeOutputToFile((String)"echo \"host all all 0.0.0.0/0 md5\"", (String)"postgres", (String)(this.getDataDir() + "/pg_hba.conf"))}));
        } else {
            String contents = this.processTemplate(authConfigUrl);
            DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)"/tmp/pg_hba.conf").contents(contents), (TaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.sudoAsUser((String)"postgres", (String)("cp /tmp/pg_hba.conf " + this.getDataDir() + "/pg_hba.conf"))}), (TaskFactory[])new TaskFactory[0]);
        }
        DynamicTasks.waitForLast();
        try {
            this.executeDatabaseCreationScript();
        }
        catch (RuntimeException r) {
            this.logTailOfPostgresLog();
            throw Exceptions.propagate((Throwable)r);
        }
    }

    protected void executeDatabaseCreationScript() {
        if (this.copyDatabaseCreationScript()) {
            this.newScript((String)"running postgres creation script").body.append(new CharSequence[]{"cd " + this.getInstallDir(), this.callPgctl("start", true), BashCommands.sudoAsUser((String)"postgres", (String)(this.getInstallDir() + "/bin/psql -p " + this.entity.getAttribute((AttributeSensor)PostgreSqlNode.POSTGRESQL_PORT) + " --file " + this.getRunDir() + "/creation-script.sql")), this.callPgctl("stop", true)}).failOnNonZeroResultCode().execute();
        }
    }

    private boolean installFile(InputStream contents, String destName) {
        String uid = Identifiers.makeRandomId((int)8);
        this.getMachine().copyTo(contents, "/tmp/" + destName + "_" + uid);
        DynamicTasks.queueIfPossible((TaskFactory)((SshEffectorTasks.SshEffectorTaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), "mv /tmp/" + destName + "_" + uid + " " + destName, "chown postgres:postgres " + destName, "chmod 644 " + destName}).runAsRoot()).requiringExitCodeZero()).orSubmitAndBlock((Entity)this.getEntity()).andWaitForSuccess();
        return true;
    }

    private boolean copyDatabaseCreationScript() {
        InputStream creationScript = DatastoreMixins.getDatabaseCreationScript((Entity)this.entity);
        if (creationScript == null) {
            return false;
        }
        return this.installFile(creationScript, "creation-script.sql");
    }

    public String getDataDir() {
        return this.getRunDir() + "/data";
    }

    public String getLogFile() {
        return this.getRunDir() + "/postgresql.log";
    }

    public String getPidFile() {
        return this.getRunDir() + "/postgresql.pid";
    }

    @Deprecated
    public void copyLogFileContents() {
        this.logTailOfPostgresLog();
    }

    public void logTailOfPostgresLog() {
        try {
            File file = Os.newTempFile((String)("postgresql-" + this.getEntity().getId()), (String)"log");
            int result = this.getMachine().copyFrom(this.getLogFile(), file.getAbsolutePath());
            if (result != 0) {
                throw new IllegalStateException("Could not access log file " + this.getLogFile());
            }
            log.info("Saving {} contents as {}", (Object)this.getLogFile(), (Object)file);
            Streams.logStreamTail((Logger)log, (String)"postgresql.log", (ByteArrayOutputStream)Streams.byteArrayOfString((String)Files.toString((File)file, (Charset)Charsets.UTF_8)), (int)1024);
            file.delete();
        }
        catch (IOException ioe) {
            log.debug("Error reading copied log file: {}", (Throwable)ioe);
        }
    }

    protected String callPgctl(String command, boolean waitForIt) {
        return BashCommands.sudoAsUser((String)"postgres", (String)(this.getInstallDir() + "/bin/pg_ctl -D " + this.getDataDir() + " -l " + this.getLogFile() + (waitForIt ? " -w " : " ") + command));
    }

    public void launch() {
        log.info(String.format("Starting entity %s at %s", this, this.getLocation()));
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"launching").body.append((CharSequence)this.callPgctl("start", false)).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile()), (String)"check-running").body.append((CharSequence)this.getStatusCmd()).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"stopping").body.append((CharSequence)this.callPgctl(((Boolean)this.entity.getConfig(PostgreSqlNode.DISCONNECT_ON_STOP) != false ? "-m immediate " : "") + "stop", false)).failOnNonZeroResultCode().execute();
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFile(), (Object)"processOwner", (Object)"postgres"), "stopping").execute();
    }

    public PostgreSqlNodeImpl getEntity() {
        return (PostgreSqlNodeImpl)super.getEntity();
    }

    @Override
    public String getStatusCmd() {
        return this.callPgctl("status", false);
    }

    @Override
    public ProcessTaskWrapper<Integer> executeScriptAsync(String commands) {
        String filename = "postgresql-commands-" + Identifiers.makeRandomId((int)8);
        this.installFile(Streams.newInputStreamWithContents((String)commands), filename);
        return this.executeScriptFromInstalledFileAsync(filename);
    }

    public ProcessTaskWrapper<Integer> executeScriptFromInstalledFileAsync(String filenameAlreadyInstalledAtServer) {
        return (ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), BashCommands.sudoAsUser((String)"postgres", (String)(this.getInstallDir() + "/bin/psql -p " + this.entity.getAttribute((AttributeSensor)PostgreSqlNode.POSTGRESQL_PORT) + " --file " + filenameAlreadyInstalledAtServer))}).summary("executing datastore script " + filenameAlreadyInstalledAtServer));
    }
}

