/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.postgresql;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EffectorStartableImpl;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.chef.ChefConfig;
import brooklyn.entity.chef.ChefLifecycleEffectorTasks;
import brooklyn.entity.chef.ChefServerTasks;
import brooklyn.entity.database.postgresql.PostgreSqlNode;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.ssh.SshFeed;
import brooklyn.event.feed.ssh.SshPollConfig;
import brooklyn.location.basic.Locations;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskFactory;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.Jsonya;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.guava.Maybe;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlNodeChefImplFromScratch
extends EffectorStartableImpl
implements PostgreSqlNode {
    private static final Logger LOG = LoggerFactory.getLogger(PostgreSqlNodeChefImplFromScratch.class);
    public static final Effector<String> EXECUTE_SCRIPT = Effectors.effector(String.class, (String)"executeScript").description("invokes a script").parameter(ExecuteScriptEffectorBody.SCRIPT).impl((EffectorBody)new ExecuteScriptEffectorBody()).build();
    private SshFeed feed;

    public void init() {
        super.init();
        new ChefPostgreSqlLifecycle().attachLifecycleEffectors(this);
    }

    @Override
    public Integer getPostgreSqlPort() {
        return (Integer)this.getAttribute((AttributeSensor)POSTGRESQL_PORT);
    }

    @Override
    public String getSharedMemory() {
        return (String)this.getConfig(SHARED_MEMORY);
    }

    @Override
    public Integer getMaxConnections() {
        return (Integer)this.getConfig(MAX_CONNECTIONS);
    }

    public String getShortName() {
        return "PostgreSQL";
    }

    protected void connectSensors() {
        this.setAttribute(DATASTORE_URL, String.format("postgresql://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)POSTGRESQL_PORT)));
        Maybe machine = Locations.findUniqueSshMachineLocation((Iterable)this.getLocations());
        if (machine.isPresent()) {
            this.feed = SshFeed.builder().entity((EntityLocal)this).machine((SshMachineLocation)machine.get()).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(SERVICE_UP).command("ps -ef | grep [p]ostgres").setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
    }

    @Override
    public String executeScript(String commands) {
        return (String)Entities.invokeEffector((EntityLocal)this, (Entity)this, EXECUTE_SCRIPT, (Map)ConfigBag.newInstance().configure(ExecuteScriptEffectorBody.SCRIPT, (Object)commands).getAllConfig()).getUnchecked();
    }

    public static class ExecuteScriptEffectorBody
    extends EffectorBody<String> {
        public static final ConfigKey<String> SCRIPT = ConfigKeys.newStringConfigKey((String)"script", (String)"contents of script to run");

        public String call(ConfigBag parameters) {
            return ((ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{BashCommands.pipeTextTo((String)((String)parameters.get(SCRIPT)), (String)BashCommands.sudoAsUser((String)"postgres", (String)"psql --file -"))}).requiringExitCodeZero())).getStdout();
        }
    }

    public static class ChefPostgreSqlLifecycle
    extends ChefLifecycleEffectorTasks {
        public ChefPostgreSqlLifecycle() {
            this.usePidFile("/var/run/postgresql/*.pid");
            this.useService("postgresql");
        }

        protected void startWithKnifeAsync() {
            Entities.warnOnIgnoringConfig((Entity)this.entity(), (ConfigKey)ChefConfig.CHEF_LAUNCH_RUN_LIST);
            Entities.warnOnIgnoringConfig((Entity)this.entity(), (ConfigKey)ChefConfig.CHEF_LAUNCH_ATTRIBUTES);
            DynamicTasks.queue((TaskFactory)ChefServerTasks.knifeConvergeRunList((String)"postgresql::server").knifeAddAttributes(Jsonya.at((Object[])new Object[]{"postgresql", "config"}).add((Object)"port", new Object[]{this.entity().getPostgreSqlPort(), "listen_addresses", "*"}).getRootMap()).knifeAddAttributes(Jsonya.at((Object[])new Object[]{"postgresql", "pg_hba"}).list().map().add((Object)"type", new Object[]{"host", "db", "all", "user", "all", "addr", "0.0.0.0/0", "method", "md5"}).getRootMap()));
        }

        protected void postStartCustom() {
            super.postStartCustom();
            String creationScriptUrl = (String)this.entity().getConfig(PostgreSqlNode.CREATION_SCRIPT_URL);
            String creationScript = creationScriptUrl != null ? ResourceUtils.create((Object)this.entity()).getResourceAsString(creationScriptUrl) : (String)this.entity().getConfig(PostgreSqlNode.CREATION_SCRIPT_CONTENTS);
            this.entity().executeScript(creationScript);
            this.entity().connectSensors();
        }

        protected void preStopCustom() {
            this.entity().disconnectSensors();
            super.preStopCustom();
        }

        protected PostgreSqlNodeChefImplFromScratch entity() {
            return (PostgreSqlNodeChefImplFromScratch)super.entity();
        }
    }
}

