/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.postgresql;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatabaseNode;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.postgresql.PostgreSqlNodeImpl;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="PostgreSQL Node", description="PostgreSQL is an object-relational database management system (ORDBMS)", iconUrl="classpath:///postgresql-logo-200px.png")
@ImplementedBy(value=PostgreSqlNodeImpl.class)
public interface PostgreSqlNode
extends SoftwareProcess,
HasShortName,
DatastoreMixins.DatastoreCommon,
DatabaseNode {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"9.3-1");
    @SetFromFlag(value="configFileUrl")
    public static final ConfigKey<String> CONFIGURATION_FILE_URL = ConfigKeys.newStringConfigKey((String)"postgresql.config.file.url", (String)"URL where PostgreSQL configuration file can be found; if not supplied the blueprint uses the default and customises it");
    @SetFromFlag(value="authConfigFileUrl")
    public static final ConfigKey<String> AUTHENTICATION_CONFIGURATION_FILE_URL = ConfigKeys.newStringConfigKey((String)"postgresql.authConfig.file.url", (String)"URL where PostgreSQL host-based authentication configuration file can be found; if not supplied the blueprint uses the default and customises it");
    @SetFromFlag(value="port")
    public static final PortAttributeSensorAndConfigKey POSTGRESQL_PORT = new PortAttributeSensorAndConfigKey("postgresql.port", "PostgreSQL port", (Object)PortRanges.fromString((String)"5432+"));
    @SetFromFlag(value="sharedMemory")
    public static final ConfigKey<String> SHARED_MEMORY = ConfigKeys.newStringConfigKey((String)"postgresql.sharedMemory", (String)"Size of shared memory buffer (must specify as kB, MB or GB, minimum 128kB)", (String)"4MB");
    @SetFromFlag(value="maxConnections")
    public static final ConfigKey<Integer> MAX_CONNECTIONS = ConfigKeys.newIntegerConfigKey((String)"postgresql.maxConnections", (String)"Maximum number of connections to the database", (Integer)100);
    @SetFromFlag(value="disconnectOnStop")
    public static final ConfigKey<Boolean> DISCONNECT_ON_STOP = ConfigKeys.newBooleanConfigKey((String)"postgresql.disconnect.on.stop", (String)"If true, PostgreSQL will immediately disconnet (pg_ctl -m immediate stop) all current connections when the node is stopped", (Boolean)true);
    @SetFromFlag(value="pollPeriod")
    public static final ConfigKey<Long> POLL_PERIOD = ConfigKeys.newLongConfigKey((String)"postgresql.sensorpoll", (String)"Poll period (in milliseconds)", (Long)1000L);
    public static final Effector<String> EXECUTE_SCRIPT = Effectors.effector(DatastoreMixins.EXECUTE_SCRIPT).description("Executes the given script contents using psql").buildAbstract();

    public Integer getPostgreSqlPort();

    public String getSharedMemory();

    public Integer getMaxConnections();

    public String executeScript(String var1);
}

