/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.mysql;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractSoftwareProcessSshDriver;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.mysql.MySqlDriver;
import brooklyn.entity.database.mysql.MySqlNode;
import brooklyn.entity.database.mysql.MySqlNodeImpl;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.software.SshEffectorTasks;
import brooklyn.location.OsDetails;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.management.TaskFactory;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.io.FileUtil;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.text.ComparableVersion;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.time.CountdownTimer;
import brooklyn.util.time.Duration;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSshDriver
extends AbstractSoftwareProcessSshDriver
implements MySqlDriver {
    public static final Logger log = LoggerFactory.getLogger(MySqlSshDriver.class);

    public MySqlSshDriver(MySqlNodeImpl entity, SshMachineLocation machine) {
        super((EntityLocal)entity, machine);
        entity.setAttribute(Attributes.LOG_FILE_LOCATION, this.getLogFile());
    }

    public String getOsTag() {
        OsDetails os = this.getLocation().getOsDetails();
        if (os == null) {
            return "linux2.6-i686";
        }
        if (os.isMac()) {
            String osp1 = os.getVersion() == null ? "osx10.5" : (new ComparableVersion(os.getVersion()).isGreaterThanOrEqualTo("10.6") ? "osx10.6" : (new ComparableVersion(os.getVersion()).isGreaterThanOrEqualTo("10.5") ? "osx10.5" : "osx10.5"));
            String osp2 = os.is64bit() ? "x86_64" : "x86";
            return osp1 + "-" + osp2;
        }
        String osp1 = "linux2.6";
        String osp2 = os.is64bit() ? "x86_64" : "i686";
        return osp1 + "-" + osp2;
    }

    public String getMirrorUrl() {
        return (String)this.entity.getConfig(MySqlNode.MIRROR_URL);
    }

    public String getBaseDir() {
        return this.getExpandedInstallDir();
    }

    public String getDataDir() {
        String result = (String)this.entity.getConfig(MySqlNode.DATA_DIR);
        return result == null ? "." : result;
    }

    public String getLogFile() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "console.log"});
    }

    public String getConfigFile() {
        return "mymysql.cnf";
    }

    public String getInstallFilename() {
        return String.format("mysql-%s-%s.tar.gz", this.getVersion(), this.getOsTag());
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this, (Map)ImmutableMap.of((Object)"filename", (Object)this.getInstallFilename()));
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("mysql-%s-%s", this.getVersion(), this.getOsTag()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        LinkedList<String> commands = new LinkedList<String>();
        commands.add(BashCommands.INSTALL_TAR);
        commands.add(BashCommands.INSTALL_CURL);
        commands.add("echo installing extra packages");
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libgcc_s.so.1"), null));
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libaio.so.1 libncurses.so.5", (Object)"apt", (Object)"libaio1 libaio-dev"), null));
        commands.add(BashCommands.installPackage((Map)ImmutableMap.of((Object)"yum", (Object)"libaio", (Object)"apt", (Object)"ia32-libs"), null));
        commands.add("echo finished installing extra packages");
        commands.addAll(BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs));
        commands.add(String.format("tar xfvz %s", saveAs));
        this.newScript((String)"installing").body.append(commands).execute();
    }

    public MySqlNodeImpl getEntity() {
        return (MySqlNodeImpl)super.getEntity();
    }

    public int getPort() {
        return this.getEntity().getPort();
    }

    public String getSocketUid() {
        return this.getEntity().getSocketUid();
    }

    public String getPassword() {
        return this.getEntity().getPassword();
    }

    public void customize() {
        this.copyDatabaseConfigScript();
        this.newScript((String)"customizing").updateTaskAndFailOnNonZeroResultCode().body.append(new CharSequence[]{"chmod 600 " + this.getConfigFile(), this.getBaseDir() + "/scripts/mysql_install_db " + "--basedir=" + this.getBaseDir() + " --datadir=" + this.getDataDir() + " " + "--defaults-file=" + this.getConfigFile()}).execute();
        this.launch();
        CountdownTimer timer = Duration.seconds((Number)20).countdownTimer();
        boolean hasCreationScript = this.copyDatabaseCreationScript();
        timer.waitForExpiryUnchecked();
        DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), this.getBaseDir() + "/bin/mysqladmin --defaults-file=" + this.getConfigFile() + " --password= password " + this.getPassword()}).summary("setting password"));
        if (hasCreationScript) {
            this.executeScriptFromInstalledFileAsync("creation-script.sql");
        }
        this.stop();
    }

    protected void copyDatabaseConfigScript() {
        this.newScript("customizing").execute();
        String configScriptContents = this.processTemplate((String)this.entity.getAttribute(MySqlNode.TEMPLATE_CONFIGURATION_URL));
        StringReader configContents = new StringReader(configScriptContents);
        this.getMachine().copyTo((Reader)configContents, Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
    }

    protected boolean copyDatabaseCreationScript() {
        File templateFile;
        block8: {
            String creationScriptContents = DatastoreMixins.getDatabaseCreationScriptAsString((Entity)this.entity);
            if (creationScriptContents == null) {
                return false;
            }
            templateFile = null;
            BufferedWriter writer = null;
            try {
                templateFile = File.createTempFile("mysql", null);
                FileUtil.setFilePermissionsTo600((File)templateFile);
                writer = new BufferedWriter(new FileWriter(templateFile));
                writer.write(creationScriptContents);
                writer.flush();
                this.copyTemplate(templateFile.getAbsoluteFile(), this.getRunDir() + "/creation-script.sql");
                if (writer == null) break block8;
            }
            catch (IOException e) {
                try {
                    throw Exceptions.propagate((Throwable)e);
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        Streams.closeQuietly(writer);
                    }
                    if (templateFile != null) {
                        templateFile.delete();
                    }
                    throw throwable;
                }
            }
            Streams.closeQuietly((Closeable)writer);
        }
        if (templateFile != null) {
            templateFile.delete();
        }
        return true;
    }

    public String getMySqlServerOptionsString() {
        Map options = (Map)this.entity.getConfig(MySqlNode.MYSQL_SERVER_CONF);
        StringBuilder result = new StringBuilder();
        if (JavaGroovyEquivalents.groovyTruth((Object)options)) {
            for (Map.Entry entry : options.entrySet()) {
                result.append((String)entry.getKey());
                String value = entry.getValue().toString();
                if (!Strings.isEmpty((CharSequence)value)) {
                    result.append(" = ").append(value);
                }
                result.append('\n');
            }
        }
        return result.toString();
    }

    public void launch() {
        this.entity.setAttribute(MySqlNode.PID_FILE, (Object)(this.getRunDir() + "/" + "pid.txt"));
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)true)), (String)"launching").updateTaskAndFailOnNonZeroResultCode().body.append((CharSequence)String.format("nohup %s/bin/mysqld --defaults-file=%s --user=`whoami` > %s 2>&1 < /dev/null &", this.getBaseDir(), this.getConfigFile(), this.getLogFile())).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)Boolean.valueOf((boolean)false)), (String)"check-running").body.append((CharSequence)this.getStatusCmd()).execute() == 0;
    }

    public void stop() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "stopping").execute();
    }

    public void kill() {
        this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)true), "killing").execute();
    }

    @Override
    public String getStatusCmd() {
        return String.format("%s/bin/mysqladmin --defaults-file=%s status", this.getBaseDir(), Urls.mergePaths((String[])new String[]{this.getRunDir(), this.getConfigFile()}));
    }

    @Override
    public ProcessTaskWrapper<Integer> executeScriptAsync(String commands) {
        String filename = "mysql-commands-" + Identifiers.makeRandomId((int)8);
        DynamicTasks.queue((TaskFactory)SshEffectorTasks.put((String)Urls.mergePaths((String[])new String[]{this.getRunDir(), filename})).contents(commands).summary("copying datastore script to execute " + filename));
        return this.executeScriptFromInstalledFileAsync(filename);
    }

    public ProcessTaskWrapper<Integer> executeScriptFromInstalledFileAsync(String filenameAlreadyInstalledAtServer) {
        return (ProcessTaskWrapper)DynamicTasks.queue((TaskFactory)SshEffectorTasks.ssh((String[])new String[]{"cd " + this.getRunDir(), this.getBaseDir() + "/bin/mysql --defaults-file=" + this.getConfigFile() + " < " + filenameAlreadyInstalledAtServer}).summary("executing datastore script " + filenameAlreadyInstalledAtServer));
    }
}

