/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.mysql;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.database.mysql.MySqlDriver;
import brooklyn.entity.database.mysql.MySqlNode;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.ssh.SshFeed;
import brooklyn.event.feed.ssh.SshPollConfig;
import brooklyn.event.feed.ssh.SshPollValue;
import brooklyn.location.basic.Locations;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.guava.Maybe;
import brooklyn.util.text.Identifiers;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlNodeImpl
extends SoftwareProcessImpl
implements MySqlNode {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlNodeImpl.class);
    private SshFeed feed;

    public MySqlNodeImpl() {
    }

    public MySqlNodeImpl(Entity parent) {
        this((Map<?, ?>)MutableMap.of(), parent);
    }

    public MySqlNodeImpl(Map<?, ?> flags) {
        super(flags, null);
    }

    public MySqlNodeImpl(Map<?, ?> flags, Entity parent) {
        super(flags, parent);
    }

    public Class<?> getDriverInterface() {
        return MySqlDriver.class;
    }

    public MySqlDriver getDriver() {
        return (MySqlDriver)super.getDriver();
    }

    public void init() {
        super.init();
        this.getMutableEntityType().addEffector(EXECUTE_SCRIPT, (EffectorBody)new EffectorBody<String>(){

            public String call(ConfigBag parameters) {
                return MySqlNodeImpl.this.executeScript((String)parameters.getStringKey("commands"));
            }
        });
    }

    protected void connectSensors() {
        super.connectSensors();
        this.setAttribute(DATASTORE_URL, String.format("mysql://%s:%s/", this.getAttribute(HOSTNAME), this.getAttribute((AttributeSensor)MYSQL_PORT)));
        Maybe machine = Locations.findUniqueSshMachineLocation((Iterable)this.getLocations());
        if (machine.isPresent()) {
            String cmd = this.getDriver().getStatusCmd();
            this.feed = SshFeed.builder().entity((EntityLocal)this).period(Duration.FIVE_SECONDS).machine((SshMachineLocation)machine.get()).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(QUERIES_PER_SECOND_FROM_MYSQL).command(cmd).onSuccess((Function)new Function<SshPollValue, Double>(){

                public Double apply(SshPollValue input) {
                    String q = Strings.getFirstWordAfter((String)input.getStdout(), (String)"Queries per second avg:");
                    if (q == null) {
                        return null;
                    }
                    return Double.parseDouble(q);
                }
            })).setOnFailureOrException(null)).poll((SshPollConfig)((SshPollConfig)new SshPollConfig(SERVICE_PROCESS_IS_RUNNING).command(cmd).setOnSuccess((Object)true)).setOnFailureOrException((Object)false)).build();
        } else {
            LOG.warn("Location(s) {} not an ssh-machine location, so not polling for status; setting serviceUp immediately", (Object)this.getLocations());
            this.setAttribute(SERVICE_UP, true);
        }
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
        super.disconnectSensors();
    }

    public int getPort() {
        return (Integer)this.getAttribute((AttributeSensor)MYSQL_PORT);
    }

    public String getSocketUid() {
        String result = (String)this.getAttribute((AttributeSensor)MySqlNode.SOCKET_UID);
        if (Strings.isBlank((CharSequence)result)) {
            result = Identifiers.makeRandomId((int)6);
            this.setAttribute((AttributeSensor)MySqlNode.SOCKET_UID, result);
        }
        return result;
    }

    public String getPassword() {
        String result = (String)this.getAttribute((AttributeSensor)MySqlNode.PASSWORD);
        if (Strings.isBlank((CharSequence)result)) {
            result = Identifiers.makeRandomId((int)6);
            this.setAttribute((AttributeSensor)MySqlNode.PASSWORD, result);
        }
        return result;
    }

    public String getShortName() {
        return "MySQL";
    }

    @Override
    public String executeScript(String commands) {
        return this.getDriver().executeScriptAsync(commands).block().getStdout();
    }
}

