/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.mysql;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatabaseNode;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.mysql.MySqlNodeImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.MapConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="MySql Node", description="MySql is an open source relational database management system (RDBMS)", iconUrl="classpath:///mysql-logo-110x57.png")
@ImplementedBy(value=MySqlNodeImpl.class)
public interface MySqlNode
extends SoftwareProcess,
HasShortName,
DatastoreMixins.DatastoreCommon,
DatabaseNode {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"5.5.37");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey((AttributeSensorAndConfigKey)Attributes.DOWNLOAD_URL, "http://dev.mysql.com/get/Downloads/MySQL-5.5/mysql-${version}-${driver.osTag}.tar.gz/from/${driver.mirrorUrl}");
    @SetFromFlag(value="mirrorUrl")
    public static final ConfigKey<String> MIRROR_URL = ConfigKeys.newStringConfigKey((String)"mysql.install.mirror.url", (String)"URL of mirror", (String)"http://www.mirrorservice.org/sites/ftp.mysql.com/");
    @SetFromFlag(value="port")
    public static final PortAttributeSensorAndConfigKey MYSQL_PORT = new PortAttributeSensorAndConfigKey("mysql.port", "MySQL port", (Object)PortRanges.fromString((String)"3306, 13306+"));
    @SetFromFlag(value="dataDir")
    public static final ConfigKey<String> DATA_DIR = ConfigKeys.newStringConfigKey((String)"mysql.datadir", (String)"Directory for writing data files", null);
    @SetFromFlag(value="serverConf")
    public static final MapConfigKey<Object> MYSQL_SERVER_CONF = new MapConfigKey(Object.class, "mysql.server.conf", "Configuration options for mysqld");
    public static final ConfigKey<Object> MYSQL_SERVER_CONF_LOWER_CASE_TABLE_NAMES = MYSQL_SERVER_CONF.subKey("lower_case_table_names", "See MySQL guide. Set 1 to ignore case in table names (useful for OS portability)");
    @SetFromFlag(value="password")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey PASSWORD = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mysql.password", "Database admin password (or randomly generated if not set)", null);
    @SetFromFlag(value="socketUid")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey SOCKET_UID = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mysql.socketUid", "Socket uid, for use in file /tmp/mysql.sock.<uid>.3306 (or randomly generated if not set)", null);
    @Deprecated
    public static final AttributeSensor<String> MYSQL_URL = DATASTORE_URL;
    @SetFromFlag(value="configurationTemplateUrl")
    public static final BasicAttributeSensorAndConfigKey<String> TEMPLATE_CONFIGURATION_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mysql.template.configuration.url", "Template file (in freemarker format) for the mysql.conf file", "classpath://brooklyn/entity/database/mysql/mysql.conf");
    public static final AttributeSensor<Double> QUERIES_PER_SECOND_FROM_MYSQL = Sensors.newDoubleSensor((String)"mysql.queries.perSec.fromMysql");

    public String executeScript(String var1);
}

