/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.mariadb;

import brooklyn.catalog.Catalog;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatabaseNode;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.mariadb.MariaDbNodeImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.HasShortName;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.MapConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;

@Catalog(name="MariaDB Node", description="MariaDB is an open source relational database management system (RDBMS)", iconUrl="classpath:///mariadb-logo-180x119.png")
@ImplementedBy(value=MariaDbNodeImpl.class)
public interface MariaDbNode
extends SoftwareProcess,
DatastoreMixins.DatastoreCommon,
HasShortName,
DatabaseNode {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"5.5.40");
    @SetFromFlag(value="downloadUrl")
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey((AttributeSensorAndConfigKey)Attributes.DOWNLOAD_URL, "${driver.mirrorUrl}/mariadb-${version}/${driver.downloadParentDir}/mariadb-${version}-${driver.osTag}.tar.gz");
    @SetFromFlag(value="mirrorUrl")
    public static final ConfigKey<String> MIRROR_URL = ConfigKeys.newStringConfigKey((String)"mariadb.install.mirror.url", (String)"URL of mirror", (String)"http://mirrors.coreix.net/mariadb/");
    @SetFromFlag(value="port")
    public static final PortAttributeSensorAndConfigKey MARIADB_PORT = new PortAttributeSensorAndConfigKey("mariadb.port", "MariaDB port", (Object)PortRanges.fromString((String)"3306, 13306+"));
    @SetFromFlag(value="dataDir")
    public static final ConfigKey<String> DATA_DIR = ConfigKeys.newStringConfigKey((String)"mariadb.datadir", (String)"Directory for writing data files", null);
    @SetFromFlag(value="serverConf")
    public static final MapConfigKey<Object> MARIADB_SERVER_CONF = new MapConfigKey(Object.class, "mariadb.server.conf", "Configuration options for MariaDB server");
    public static final ConfigKey<Object> MARIADB_SERVER_CONF_LOWER_CASE_TABLE_NAMES = MARIADB_SERVER_CONF.subKey("lower_case_table_names", "See MariaDB (or MySQL!) guide. Set 1 to ignore case in table names (useful for OS portability)");
    @SetFromFlag(value="password")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey PASSWORD = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mariadb.password", "Database admin password (or randomly generated if not set)", null);
    @SetFromFlag(value="socketUid")
    public static final BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey SOCKET_UID = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mariadb.socketUid", "Socket uid, for use in file /tmp/mysql.sock.<uid>.3306 (or randomly generated if not set)", null);
    @Deprecated
    public static final AttributeSensor<String> MARIADB_URL = DATASTORE_URL;
    @SetFromFlag(value="configurationTemplateUrl")
    public static final BasicAttributeSensorAndConfigKey<String> TEMPLATE_CONFIGURATION_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("mariadb.template.configuration.url", "Template file (in freemarker format) for the my.cnf file", "classpath://brooklyn/entity/database/mariadb/my.cnf");
    public static final AttributeSensor<Double> QUERIES_PER_SECOND_FROM_MARIADB = Sensors.newDoubleSensor((String)"mariadb.queries.perSec.fromMariadb");

    public String executeScript(String var1);
}

