/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.crate;

import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.database.crate.CrateNode;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.java.JavaSoftwareProcessSshDriver;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.net.Urls;
import brooklyn.util.os.Os;
import brooklyn.util.ssh.BashCommands;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class CrateNodeSshDriver
extends JavaSoftwareProcessSshDriver {
    public CrateNodeSshDriver(EntityLocal entity, SshMachineLocation machine) {
        super(entity, machine);
    }

    public void preInstall() {
        this.resolver = Entities.newDownloader((EntityDriver)this);
        this.setExpandedInstallDir(Os.mergePaths((String[])new String[]{this.getInstallDir(), this.resolver.getUnpackedDirectoryName(String.format("crate-%s", this.getVersion()))}));
    }

    public void install() {
        List urls = this.resolver.getTargets();
        String saveAs = this.resolver.getFilename();
        ImmutableList commands = ImmutableList.builder().addAll((Iterable)BashCommands.commandsToDownloadUrlsAs((List)urls, (String)saveAs)).add((Object)("tar xvfz " + saveAs)).build();
        this.newScript((String)"installing").failOnNonZeroResultCode().body.append((Collection)commands).execute();
    }

    public void customize() {
        this.newScript((String)"customizing").body.append((CharSequence)("mkdir -p " + this.getDataLocation())).execute();
        this.copyTemplate((String)this.entity.getConfig(CrateNode.SERVER_CONFIG_URL), this.getConfigFileLocation());
    }

    public void launch() {
        StringBuilder command = new StringBuilder(this.getExpandedInstallDir()).append("/bin/crate ").append(" -d").append(" -p ").append(this.getPidFileLocation()).append(" -Des.config=").append(this.getConfigFileLocation());
        this.newScript((String)"launching").failOnNonZeroResultCode().body.append((CharSequence)command).execute();
    }

    public boolean isRunning() {
        return this.newScript((Map)MutableMap.of((Object)"usePidFile", (Object)this.getPidFileLocation()), "check-running").execute() == 0;
    }

    public void stop() {
        this.newScript((String)"stopping").body.append((CharSequence)("kill -USR2 `cat " + this.getPidFileLocation() + "`")).execute();
    }

    protected String getConfigFileLocation() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "config.yaml"});
    }

    public String getLogFileLocation() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "crate.log"});
    }

    protected String getPidFileLocation() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "pid.txt"});
    }

    public String getDataLocation() {
        return Urls.mergePaths((String[])new String[]{this.getRunDir(), "data"});
    }
}

