/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.crate;

import brooklyn.config.render.RendererHints;
import brooklyn.enricher.Enrichers;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.SoftwareProcessImpl;
import brooklyn.entity.database.crate.CrateNode;
import brooklyn.entity.database.crate.CrateNodeDriver;
import brooklyn.entity.java.JavaAppUtils;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.http.HttpFeed;
import brooklyn.event.feed.http.HttpPollConfig;
import brooklyn.event.feed.http.HttpValueFunctions;
import brooklyn.event.feed.jmx.JmxFeed;
import brooklyn.util.guava.Functionals;
import com.google.common.base.Function;

public class CrateNodeImpl
extends SoftwareProcessImpl
implements CrateNode {
    private JmxFeed jmxFeed;
    private HttpFeed httpFeed;

    public Class getDriverInterface() {
        return CrateNodeDriver.class;
    }

    protected void connectSensors() {
        super.connectSensors();
        this.connectServiceUpIsRunning();
        this.jmxFeed = JavaAppUtils.connectMXBeanSensors((EntityLocal)this);
        this.setAttribute(DATASTORE_URL, "crate://" + (String)this.getAttribute(HOSTNAME) + ":" + this.getPort());
        String url = "http://" + (String)this.getAttribute(HOSTNAME) + ":" + this.getHttpPort();
        this.setAttribute(MANAGEMENT_URL, url);
        this.httpFeed = HttpFeed.builder().entity((EntityLocal)this).baseUri(url).poll((HttpPollConfig)new HttpPollConfig(SERVER_NAME).onSuccess(HttpValueFunctions.jsonContents((String)"name", String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_STATUS).onSuccess(HttpValueFunctions.jsonContents((String)"status", Integer.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_OK).onSuccess(HttpValueFunctions.jsonContents((String)"ok", Boolean.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_BUILD_TIMESTAMP).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "build_timestamp"}, String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_BUILD_HASH).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "build_hash"}, String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_IS_BUILD_SNAPSHOT).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "build_snapshot"}, Boolean.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_LUCENE_VERSION).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "lucene_version"}, String.class))).poll((HttpPollConfig)new HttpPollConfig(SERVER_ES_VERSION).onSuccess(HttpValueFunctions.jsonContents((String[])new String[]{"version", "es_version"}, String.class))).build();
        this.addEnricher(((Enrichers.UpdatingMapBuilder)Enrichers.builder().updatingMap(Attributes.SERVICE_NOT_UP_INDICATORS).from(SERVER_OK).computing((Function)Functionals.ifNotEquals((Object)true).value((Object)"Crate server reports it is not ok."))).build());
    }

    protected void disconnectSensors() {
        this.disconnectServiceUpIsRunning();
        if (this.jmxFeed != null) {
            this.jmxFeed.stop();
        }
        if (this.httpFeed != null) {
            this.httpFeed.stop();
        }
        super.disconnectSensors();
    }

    public Integer getPort() {
        return (Integer)this.getAttribute((AttributeSensor)CRATE_PORT);
    }

    public Integer getHttpPort() {
        return (Integer)this.getAttribute((AttributeSensor)CRATE_HTTP_PORT);
    }

    static {
        JavaAppUtils.init();
        RendererHints.register((AttributeSensor)MANAGEMENT_URL, (RendererHints.Hint)RendererHints.namedActionWithUrl());
    }
}

