/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database.crate;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.SoftwareProcess;
import brooklyn.entity.database.DatastoreMixins;
import brooklyn.entity.database.crate.CrateNodeImpl;
import brooklyn.entity.java.UsesJava;
import brooklyn.entity.java.UsesJavaMXBeans;
import brooklyn.entity.java.UsesJmx;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.location.basic.PortRanges;
import brooklyn.util.flags.SetFromFlag;

@ImplementedBy(value=CrateNodeImpl.class)
public interface CrateNode
extends SoftwareProcess,
UsesJava,
UsesJmx,
UsesJavaMXBeans,
DatastoreMixins.DatastoreCommon {
    @SetFromFlag(value="version")
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"0.45.7");
    @SetFromFlag(value="downloadUrl")
    public static final AttributeSensorAndConfigKey<String, String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey((AttributeSensorAndConfigKey)Attributes.DOWNLOAD_URL, "https://cdn.crate.io/downloads/releases/crate-${version}.tar.gz");
    @SetFromFlag(value="serverConfig")
    public static final BasicAttributeSensorAndConfigKey<String> SERVER_CONFIG_URL = new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey("crate.serverConfig", "A URL of a YAML file to use to configure the server", "classpath://brooklyn/entity/database/crate/crate.yaml");
    @SetFromFlag(value="port")
    public static final PortAttributeSensorAndConfigKey CRATE_PORT = new PortAttributeSensorAndConfigKey("crate.port", "The port for node-to-node communication", (Object)PortRanges.fromString((String)"4300+"));
    @SetFromFlag(value="httpPort")
    public static final PortAttributeSensorAndConfigKey CRATE_HTTP_PORT = new PortAttributeSensorAndConfigKey("crate.httpPort", "The port for HTTP traffic", (Object)PortRanges.fromString((String)"4200+"));
    public static final AttributeSensor<String> MANAGEMENT_URL = Sensors.newStringSensor((String)"crate.managementUri", (String)"The address at which the Crate server listens");
    public static final AttributeSensor<String> SERVER_NAME = Sensors.newStringSensor((String)"crate.server.name", (String)"The name of the server");
    public static final AttributeSensor<Boolean> SERVER_OK = Sensors.newBooleanSensor((String)"crate.server.ok", (String)"True if the server reports thus");
    public static final AttributeSensor<Integer> SERVER_STATUS = Sensors.newIntegerSensor((String)"crate.server.status", (String)"The status of the server");
    public static final AttributeSensor<String> SERVER_BUILD_TIMESTAMP = Sensors.newStringSensor((String)"crate.server.buildTimestamp", (String)"The timestamp of the server build");
    public static final AttributeSensor<String> SERVER_BUILD_HASH = Sensors.newStringSensor((String)"crate.server.buildHash", (String)"The build hash of the server");
    public static final AttributeSensor<Boolean> SERVER_IS_BUILD_SNAPSHOT = Sensors.newBooleanSensor((String)"crate.server.isBuildSnapshot", (String)"True if the server reports it is a snapshot build");
    public static final AttributeSensor<String> SERVER_LUCENE_VERSION = Sensors.newStringSensor((String)"crate.server.luceneVersion", (String)"The Lucene version of the server");
    public static final AttributeSensor<String> SERVER_ES_VERSION = Sensors.newStringSensor((String)"crate.server.esVersion", (String)"The ES version of the server");
}

