/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.database;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.effector.Effectors;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.ResourceUtils;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.stream.KnownSizeInputStream;
import brooklyn.util.text.Strings;
import java.io.InputStream;
import javax.annotation.Nullable;

public class DatastoreMixins {
    public static final AttributeSensor<String> DATASTORE_URL = HasDatastoreUrl.DATASTORE_URL;
    public static final Effector<String> EXECUTE_SCRIPT = CanExecuteScript.EXECUTE_SCRIPT;
    public static final ConfigKey<String> CREATION_SCRIPT_CONTENTS = CanGiveCreationScript.CREATION_SCRIPT_CONTENTS;
    public static final ConfigKey<String> CREATION_SCRIPT_URL = CanGiveCreationScript.CREATION_SCRIPT_URL;

    private DatastoreMixins() {
    }

    @Nullable
    public static InputStream getDatabaseCreationScript(Entity entity) {
        String url = (String)entity.getConfig(CREATION_SCRIPT_URL);
        if (!Strings.isBlank((CharSequence)url)) {
            return new ResourceUtils((Object)entity).getResourceFromUrl(url);
        }
        String contents = (String)entity.getConfig(CREATION_SCRIPT_CONTENTS);
        if (!Strings.isBlank((CharSequence)contents)) {
            return KnownSizeInputStream.of((String)contents);
        }
        return null;
    }

    @Nullable
    public static String getDatabaseCreationScriptAsString(Entity entity) {
        String url = (String)entity.getConfig(CREATION_SCRIPT_URL);
        if (!Strings.isBlank((CharSequence)url)) {
            return new ResourceUtils((Object)entity).getResourceAsString(url);
        }
        String contents = (String)entity.getConfig(CREATION_SCRIPT_CONTENTS);
        if (!Strings.isBlank((CharSequence)contents)) {
            return contents;
        }
        return null;
    }

    public static interface DatastoreCommon
    extends Entity,
    HasDatastoreUrl,
    CanExecuteScript,
    CanGiveCreationScript {
    }

    public static interface CanGiveCreationScript {
        @SetFromFlag(value="creationScriptContents")
        public static final ConfigKey<String> CREATION_SCRIPT_CONTENTS = ConfigKeys.newStringConfigKey((String)"datastore.creation.script.contents", (String)"Contensts of creation script to initialize the datastore", (String)"");
        @SetFromFlag(value="creationScriptUrl")
        public static final ConfigKey<String> CREATION_SCRIPT_URL = ConfigKeys.newStringConfigKey((String)"datastore.creation.script.url", (String)"URL of creation script to use to initialize the datastore (ignored if contents are specified)", (String)"");
    }

    public static interface CanExecuteScript {
        public static final Effector<String> EXECUTE_SCRIPT = Effectors.effector(String.class, (String)"executeScript").description("executes the given script contents").parameter(String.class, "commands").buildAbstract();
    }

    public static interface HasDatastoreUrl {
        public static final AttributeSensor<String> DATASTORE_URL = Sensors.newStringSensor((String)"datastore.url", (String)"Primary contact URL for a datastore (e.g. mysql://localhost:3306/)");
    }
}

