/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.os;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.Sensors;
import brooklyn.location.Location;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.text.Identifiers;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import org.jclouds.compute.config.AdminAccessConfiguration;
import org.jclouds.scriptbuilder.domain.OsFamily;
import org.jclouds.scriptbuilder.functions.InitAdminAccess;
import org.jclouds.scriptbuilder.statements.login.AdminAccess;
import org.jclouds.scriptbuilder.statements.ssh.SshdConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class CreateUserPolicy
extends AbstractPolicy
implements SensorEventListener<Location> {
    private static final Logger LOG = LoggerFactory.getLogger(CreateUserPolicy.class);
    @SetFromFlag(value="user")
    public static final ConfigKey<String> VM_USERNAME = ConfigKeys.newStringConfigKey((String)"createuser.vm.user.name");
    @SetFromFlag(value="grantSudo")
    public static final ConfigKey<Boolean> GRANT_SUDO = ConfigKeys.newBooleanConfigKey((String)"createuser.vm.user.grantSudo", (String)"Whether to give the new user sudo rights", (Boolean)false);
    public static final AttributeSensor<String> VM_USER_CREDENTIALS = Sensors.newStringSensor((String)"createuser.vm.user.credentials", (String)"The \"<user> : <password> @ <hostname>:<port>\"");

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscribe((Entity)entity, (Sensor)AbstractEntity.LOCATION_ADDED, this);
    }

    public void onEvent(SensorEvent<Location> event) {
        Entity entity = event.getSource();
        Location loc = (Location)event.getValue();
        if (loc instanceof SshMachineLocation) {
            this.addUserAsync(entity, (SshMachineLocation)loc);
        }
    }

    protected void addUserAsync(final Entity entity, final SshMachineLocation machine) {
        ((EntityInternal)entity).getExecutionContext().execute(new Runnable(){

            @Override
            public void run() {
                CreateUserPolicy.this.addUser(entity, machine);
            }
        });
    }

    protected void addUser(Entity entity, SshMachineLocation machine) {
        boolean grantSudo = (Boolean)this.getRequiredConfig(GRANT_SUDO);
        String user = (String)this.getRequiredConfig(VM_USERNAME);
        String password = Identifiers.makeRandomId((int)12);
        String hostname = machine.getAddress().getHostName();
        int port = machine.getPort();
        String creds = user + " : " + password + " @ " + hostname + ":" + port;
        LOG.info("Adding auto-generated user " + user + " @ " + hostname + ":" + port);
        AdminAccess adminAccess = AdminAccess.builder().adminUsername(user).adminPassword(password).grantSudoToAdminUser(false).resetLoginPassword(true).loginPassword(password).authorizeAdminPublicKey(false).adminPublicKey("ignored").installAdminPrivateKey(false).adminPrivateKey("ignore").lockSsh(false).build();
        OsFamily scriptOsFamily = machine.getMachineDetails().getOsDetails().isWindows() ? OsFamily.WINDOWS : OsFamily.UNIX;
        InitAdminAccess initAdminAccess = new InitAdminAccess((AdminAccess.Configuration)new AdminAccessConfiguration.Default());
        initAdminAccess.visit(adminAccess);
        String cmd = adminAccess.render(scriptOsFamily);
        int result = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_RUN_AS_ROOT.getName(), (Object)true), "create-user-" + user, (List)ImmutableList.of((Object)cmd));
        if (result != 0) {
            throw new IllegalStateException("Failed to auto-generate user, using command " + cmd);
        }
        cmd = new SshdConfig((Map)ImmutableMap.of((Object)"PasswordAuthentication", (Object)"yes")).render(scriptOsFamily);
        result = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_RUN_AS_ROOT.getName(), (Object)true), "create-user-" + user, (List)ImmutableList.of((Object)cmd));
        if (result != 0) {
            throw new IllegalStateException("Failed to enable ssh-login-with-password, using command " + cmd);
        }
        if (grantSudo) {
            ImmutableList cmds = ImmutableList.of((Object)("cat >> /etc/sudoers <<-'END_OF_JCLOUDS_FILE'\n" + user + " ALL = (ALL) NOPASSWD:ALL\n" + "END_OF_JCLOUDS_FILE\n"), (Object)"chmod 0440 /etc/sudoers");
            result = machine.execScript((Map)ImmutableMap.of((Object)SshTool.PROP_RUN_AS_ROOT.getName(), (Object)true), "add-user-to-sudoers-" + user, (List)cmds);
            if (result != 0) {
                throw new IllegalStateException("Failed to auto-generate user, using command " + cmd);
            }
        }
        ((EntityLocal)entity).setAttribute(VM_USER_CREDENTIALS, (Object)creds);
    }
}

