/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.policy.os;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.Sensors;
import brooklyn.location.Location;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.policy.basic.AbstractPolicy;
import com.google.common.annotations.Beta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AdvertiseWinrmLoginPolicy
extends AbstractPolicy
implements SensorEventListener<Location> {
    private static final Logger LOG = LoggerFactory.getLogger(AdvertiseWinrmLoginPolicy.class);
    public static final AttributeSensor<String> VM_USER_CREDENTIALS = Sensors.newStringSensor((String)"vm.user.credentials", (String)"The \"<user> : <password> @ <hostname>:<port>\"");

    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.subscribe((Entity)entity, (Sensor)AbstractEntity.LOCATION_ADDED, this);
    }

    public void onEvent(SensorEvent<Location> event) {
        Entity entity = event.getSource();
        Location loc = (Location)event.getValue();
        if (loc instanceof WinRmMachineLocation) {
            this.advertiseUserAsync(entity, (WinRmMachineLocation)loc);
        }
    }

    protected void advertiseUserAsync(Entity entity, WinRmMachineLocation machine) {
        String user = machine.getUser();
        String hostname = machine.getHostname();
        int port = (Integer)machine.config().get(WinRmMachineLocation.WINRM_PORT);
        String password = (String)machine.config().get(WinRmMachineLocation.PASSWORD);
        String creds = user + " : " + password + " @ " + hostname + ":" + port;
        LOG.info("Advertising user " + user + " @ " + hostname + ":" + port);
        ((EntityLocal)entity).setAttribute(VM_USER_CREDENTIALS, (Object)creds);
    }
}

