/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds.zone;

import brooklyn.location.Location;
import brooklyn.location.cloud.AbstractAvailabilityZoneExtension;
import brooklyn.location.cloud.AvailabilityZoneExtension;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.management.ManagementContext;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jclouds.aws.ec2.AWSEC2Api;
import org.jclouds.ec2.domain.AvailabilityZoneInfo;
import org.jclouds.ec2.features.AvailabilityZoneAndRegionApi;
import org.jclouds.ec2.options.DescribeAvailabilityZonesOptions;

public class AwsAvailabilityZoneExtension
extends AbstractAvailabilityZoneExtension
implements AvailabilityZoneExtension {
    private final JcloudsLocation loc;

    public AwsAvailabilityZoneExtension(ManagementContext managementContext, JcloudsLocation loc) {
        super(managementContext);
        this.loc = (JcloudsLocation)Preconditions.checkNotNull((Object)loc, (Object)"loc");
        Preconditions.checkArgument((boolean)loc.getProvider().equals("aws-ec2"), (String)"provider not aws-ec2 (%s)", (Object[])new Object[]{loc.getProvider()});
    }

    protected List<Location> doGetAllSubLocations() {
        ArrayList result = Lists.newArrayList();
        Set<AvailabilityZoneInfo> zones = this.getAvailabilityZones();
        for (AvailabilityZoneInfo zone : zones) {
            result.add(this.newSubLocation((Location)this.loc, zone));
        }
        return result;
    }

    protected boolean isNameMatch(Location loc, Predicate<? super String> namePredicate) {
        return namePredicate.apply((Object)((JcloudsLocation)loc).getRegion());
    }

    protected Set<AvailabilityZoneInfo> getAvailabilityZones() {
        String regionName = this.loc.getRegion();
        AWSEC2Api ec2Client = (AWSEC2Api)this.loc.getComputeService().getContext().unwrapApi(AWSEC2Api.class);
        return ((AvailabilityZoneAndRegionApi)ec2Client.getAvailabilityZoneAndRegionApi().get()).describeAvailabilityZonesInRegion(regionName, new DescribeAvailabilityZonesOptions[0]);
    }

    protected JcloudsLocation newSubLocation(Location parent, AvailabilityZoneInfo zone) {
        return this.loc.newSubLocation((Map)ImmutableMap.of((Object)JcloudsLocation.CLOUD_REGION_ID, (Object)zone.getZone()));
    }
}

