/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds.templates;

import brooklyn.location.jclouds.templates.AbstractPortableTemplateBuilder;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.TreeSet;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.domain.TemplateBuilder;
import org.jclouds.compute.domain.TemplateBuilderSpec;
import org.jclouds.compute.options.TemplateOptions;

public class PortableTemplateBuilder<T extends PortableTemplateBuilder<?>>
extends AbstractPortableTemplateBuilder<T> {
    ComputeService svc;
    List<TemplateOptions> additionalOptionalOptions = new ArrayList<TemplateOptions>();

    public synchronized Template build() {
        if (this.svc != null) {
            return this.newJcloudsTemplate(this.svc);
        }
        throw new IllegalStateException("Cannot build a portable template until a compute service is attached");
    }

    public synchronized ComputeService attachComputeService(ComputeService svc) {
        ComputeService old = this.svc;
        this.svc = svc;
        return old;
    }

    public TemplateBuilder newJcloudsTemplateBuilder(ComputeService svc) {
        TemplateBuilder tb = svc.templateBuilder();
        for (Function c : this.commands) {
            tb = (TemplateBuilder)c.apply((Object)tb);
        }
        tb.options(this.computeAggregatedOptions(true));
        return tb;
    }

    public Template newJcloudsTemplate(ComputeService svc) {
        return this.newJcloudsTemplateBuilder(svc).build();
    }

    public T addOptionalOptions(TemplateOptions options) {
        this.additionalOptionalOptions.add(options);
        return (T)this;
    }

    protected TemplateOptions computeAggregatedOptions(boolean includeOptional) {
        TemplateOptions result = this.getOptions() != null ? this.getOptions().clone() : new TemplateOptions();
        if (includeOptional) {
            for (TemplateOptions moreOptions : this.getAdditionalOptionalOptions()) {
                result = PortableTemplateBuilder.addTemplateOptions(result, moreOptions);
            }
        }
        for (TemplateOptions moreOptions : this.getAdditionalOptions()) {
            result = PortableTemplateBuilder.addTemplateOptions(result, moreOptions);
        }
        return result;
    }

    public List<TemplateOptions> getAdditionalOptionalOptions() {
        return ImmutableList.copyOf(this.additionalOptionalOptions);
    }

    public static TemplateOptions addTemplateOptions(TemplateOptions options, TemplateOptions moreOptions) {
        TemplateOptions result = options.clone();
        moreOptions.copyTo(result);
        LinkedHashSet tags = new LinkedHashSet(options.getTags());
        tags.addAll(moreOptions.getTags());
        result.tags(tags);
        LinkedHashMap userMetadata = new LinkedHashMap(options.getUserMetadata());
        userMetadata.putAll(moreOptions.getUserMetadata());
        result.userMetadata(userMetadata);
        TreeSet<Integer> inboundPorts = new TreeSet<Integer>();
        for (int port : options.getInboundPorts()) {
            inboundPorts.add(port);
        }
        for (int port : moreOptions.getInboundPorts()) {
            inboundPorts.add(port);
        }
        int[] inboundPortsArray = new int[inboundPorts.size()];
        int i = 0;
        Iterator portI = inboundPorts.iterator();
        while (portI.hasNext()) {
            inboundPortsArray[i++] = (Integer)portI.next();
        }
        result.inboundPorts(inboundPortsArray);
        return result;
    }

    @Override
    protected String makeNonTrivialArgumentsString() {
        String s = super.makeNonTrivialArgumentsString();
        TemplateOptions aggr = this.computeAggregatedOptions(false);
        if (aggr.getInboundPorts().length > 0) {
            s = "ports=" + Ints.asList((int[])aggr.getInboundPorts()) + (s != null && s.length() > 0 ? ", " + s : "");
        }
        if (!aggr.getUserMetadata().isEmpty()) {
            s = "metadata=" + aggr.getUserMetadata() + (s != null && s.length() > 0 ? ", " + s : "");
        }
        if (!aggr.getTags().isEmpty()) {
            s = "tags=" + aggr.getTags() + (s != null && s.length() > 0 ? ", " + s : "");
        }
        return s;
    }

    public TemplateBuilder from(TemplateBuilderSpec spec) {
        TemplateOptions options = new TemplateOptions();
        this.addOptionalOptions(options);
        TemplateBuilder result = spec.copyTo((TemplateBuilder)this, options);
        return result;
    }

    public TemplateBuilder from(String spec) {
        return this.from(TemplateBuilderSpec.parse((String)spec));
    }
}

