/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds.pool;

import brooklyn.location.jclouds.pool.MachinePoolPredicates;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.concurrent.Immutable;
import org.jclouds.compute.domain.NodeMetadata;

@Immutable
public class MachineSet
implements Iterable<NodeMetadata> {
    final Set<NodeMetadata> members;

    public MachineSet(Iterable<? extends NodeMetadata> m) {
        this.members = ImmutableSet.copyOf(m);
    }

    public MachineSet(NodeMetadata ... nodes) {
        this.members = ImmutableSet.copyOf((Object[])nodes);
    }

    @Override
    public Iterator<NodeMetadata> iterator() {
        return this.members.iterator();
    }

    public MachineSet removed(MachineSet toRemove) {
        LinkedHashSet<NodeMetadata> s = new LinkedHashSet<NodeMetadata>(this.members);
        for (NodeMetadata m : toRemove) {
            s.remove(m);
        }
        return new MachineSet(s);
    }

    public MachineSet added(MachineSet toAdd) {
        LinkedHashSet<NodeMetadata> s = new LinkedHashSet<NodeMetadata>(this.members);
        for (NodeMetadata m : toAdd) {
            s.add(m);
        }
        return new MachineSet(s);
    }

    public MachineSet filtered(Predicate<NodeMetadata> criterion) {
        return this.filtered(new Predicate[]{criterion});
    }

    public MachineSet filtered(Predicate<NodeMetadata> ... criteria) {
        return new MachineSet(Iterables.filter(this.members, MachinePoolPredicates.compose(criteria)));
    }

    public int size() {
        return this.members.size();
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    public boolean contains(NodeMetadata input) {
        return this.members.contains(input);
    }

    public String toString() {
        return this.members.toString();
    }

    public int hashCode() {
        return this.members.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof MachineSet && this.members.equals(((MachineSet)obj).members);
    }
}

