/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds.pool;

import brooklyn.location.jclouds.pool.MachinePoolPredicates;
import brooklyn.location.jclouds.pool.MachineSet;
import brooklyn.location.jclouds.pool.ReusableMachineTemplate;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.RunNodesException;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MachinePool {
    private static final Logger log = LoggerFactory.getLogger(MachinePool.class);
    protected final ComputeService computeService;
    final AtomicBoolean refreshNeeded = new AtomicBoolean(true);
    final List<ReusableMachineTemplate> templates = new ArrayList<ReusableMachineTemplate>();
    String poolName = null;
    volatile MachineSet detectedMachines = new MachineSet(new NodeMetadata[0]);
    volatile MachineSet matchedMachines = new MachineSet(new NodeMetadata[0]);
    volatile MachineSet claimedMachines = new MachineSet(new NodeMetadata[0]);
    volatile MachineSet blacklistedMachines = new MachineSet(new NodeMetadata[0]);

    public MachinePool(ComputeService computeService) {
        this.computeService = computeService;
    }

    protected synchronized void init() {
        if (!this.refreshNeeded.get()) {
            return;
        }
        this.refresh();
    }

    public void setPoolName(String poolName) {
        if (poolName != null) {
            log.warn("Changing pool name of " + this + " (from " + this.poolName + " to " + poolName + ") is discouraged.");
        }
        this.poolName = poolName;
    }

    public synchronized String getPoolName() {
        if (this.poolName == null) {
            this.poolName = this.getClass().getSimpleName() + "-" + System.getProperty("user.name");
        }
        return this.poolName;
    }

    public synchronized void refresh() {
        this.refreshNeeded.set(false);
        Set computes = this.computeService.listNodes();
        LinkedHashSet<NodeMetadata> nodes = new LinkedHashSet<NodeMetadata>();
        for (ComputeMetadata c : computes) {
            if (c instanceof NodeMetadata) {
                nodes.add((NodeMetadata)c);
                continue;
            }
            log.warn("MachinePool " + this + " ignoring non-Node record for remote machine: " + c);
        }
        MachineSet allNewDetectedMachines = new MachineSet(nodes);
        MachineSet newDetectedMachines = this.filterForAllowedMachines(allNewDetectedMachines);
        MachineSet oldDetectedMachines = this.detectedMachines;
        MachineSet newMatchedMachines = new MachineSet(new NodeMetadata[0]);
        this.detectedMachines = newDetectedMachines;
        MachineSet appearedMachinesIncludingBlacklist = allNewDetectedMachines.removed(oldDetectedMachines);
        MachineSet appearedMachines = this.filterForAllowedMachines(appearedMachinesIncludingBlacklist);
        if (appearedMachinesIncludingBlacklist.size() > appearedMachines.size() && log.isDebugEnabled()) {
            log.debug("Pool " + this + ", ignoring " + (appearedMachinesIncludingBlacklist.size() - appearedMachines.size()) + " disallowed");
        }
        int matchedAppeared = 0;
        for (NodeMetadata m : appearedMachines) {
            if (m.getStatus() != NodeMetadata.Status.RUNNING) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Pool " + this + ", newly detected machine " + m + ", not running (" + m.getStatus() + ")");
                continue;
            }
            Set<ReusableMachineTemplate> ts = this.getTemplatesMatchingInstance(m);
            if (!ts.isEmpty()) {
                ++matchedAppeared;
                newMatchedMachines = newMatchedMachines.added(new MachineSet(m));
                if (!log.isDebugEnabled()) continue;
                log.debug("Pool " + this + ", newly detected machine " + m + ", matches pool templates " + ts);
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Pool " + this + ", newly detected machine " + m + ", does not match any pool templates");
        }
        if (matchedAppeared > 0) {
            log.info("Pool " + this + " discovered " + matchedAppeared + " matching machines (of " + appearedMachines.size() + " total new; " + newDetectedMachines.size() + " total including claimed and unmatched)");
        } else if (log.isDebugEnabled()) {
            log.debug("Pool " + this + " discovered " + matchedAppeared + " matching machines (of " + appearedMachines.size() + " total new; " + newDetectedMachines.size() + " total including claimed and unmatched)");
        }
        this.matchedMachines = newMatchedMachines;
    }

    protected MachineSet filterForAllowedMachines(MachineSet input) {
        return input.removed(this.blacklistedMachines);
    }

    protected ReusableMachineTemplate registerTemplate(ReusableMachineTemplate template) {
        this.registerTemplates(template);
        return template;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerTemplates(ReusableMachineTemplate ... templatesToReg) {
        List<ReusableMachineTemplate> list = this.templates;
        synchronized (list) {
            for (ReusableMachineTemplate template : templatesToReg) {
                this.templates.add(template);
            }
        }
    }

    protected ReusableMachineTemplate newTemplate(String name) {
        return this.registerTemplate(new ReusableMachineTemplate(name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ReusableMachineTemplate> getTemplates() {
        ImmutableList result;
        List<ReusableMachineTemplate> list = this.templates;
        synchronized (list) {
            result = ImmutableList.copyOf(this.templates);
        }
        return result;
    }

    public MachineSet all() {
        this.init();
        return this.matchedMachines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineSet unclaimed() {
        this.init();
        MachinePool machinePool = this;
        synchronized (machinePool) {
            return this.matchedMachines.removed(this.claimedMachines);
        }
    }

    public MachineSet all(Predicate<NodeMetadata> criterion) {
        return this.all(new Predicate[]{criterion});
    }

    public MachineSet all(Predicate<NodeMetadata> ... ops) {
        return new MachineSet(Iterables.filter((Iterable)this.all(), MachinePoolPredicates.compose(ops)));
    }

    public MachineSet unclaimed(Predicate<NodeMetadata> criterion) {
        return this.unclaimed(new Predicate[]{criterion});
    }

    public MachineSet unclaimed(Predicate<NodeMetadata> ... criteria) {
        return new MachineSet(Iterables.filter((Iterable)this.unclaimed(), MachinePoolPredicates.compose(criteria)));
    }

    public MachineSet ensureExists(ReusableMachineTemplate template) {
        return this.ensureExists(1, template);
    }

    public synchronized void addToBlacklist(MachineSet newToBlacklist) {
        this.setBlacklist(this.blacklistedMachines.added(newToBlacklist));
    }

    public synchronized void setBlacklist(MachineSet newBlacklist) {
        this.blacklistedMachines = newBlacklist;
        this.detectedMachines = this.detectedMachines.removed(this.blacklistedMachines);
        this.matchedMachines = this.matchedMachines.removed(this.blacklistedMachines);
    }

    public MachineSet ensureExists(int count, ReusableMachineTemplate template) {
        MachineSet current = this.all(MachinePoolPredicates.matching(template));
        if (current.size() >= count) {
            return current;
        }
        MachineSet moreNeeded = this.create(count - current.size(), template);
        return current.added(moreNeeded);
    }

    public MachineSet ensureUnclaimed(ReusableMachineTemplate template) {
        return this.ensureUnclaimed(1, template);
    }

    public MachineSet ensureUnclaimed(int count, ReusableMachineTemplate template) {
        MachineSet current = this.unclaimed(MachinePoolPredicates.matching(template));
        if (current.size() >= count) {
            return current;
        }
        MachineSet moreNeeded = this.create(count - current.size(), template);
        return current.added(moreNeeded);
    }

    public Set<ReusableMachineTemplate> getTemplatesMatchingInstance(NodeMetadata nm) {
        LinkedHashSet<ReusableMachineTemplate> result = new LinkedHashSet<ReusableMachineTemplate>();
        for (ReusableMachineTemplate t : this.getTemplates()) {
            if (!MachinePoolPredicates.matching(t).apply((Object)nm)) continue;
            result.add(t);
        }
        return result;
    }

    public MachineSet create(int count, ReusableMachineTemplate template) {
        Set nodes;
        try {
            Template t = template.newJcloudsTemplate(this.computeService);
            if (log.isDebugEnabled()) {
                log.debug("Creating " + count + " new instances of " + t);
            }
            nodes = this.computeService.createNodesInGroup(this.getPoolName(), count, t);
        }
        catch (RunNodesException e) {
            throw Throwables.propagate((Throwable)e);
        }
        MachineSet result = new MachineSet(nodes);
        this.registerNewNodes(result, template);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNewNodes(MachineSet result, ReusableMachineTemplate template) {
        for (NodeMetadata m : result) {
            Set<ReusableMachineTemplate> ts = this.getTemplatesMatchingInstance(m);
            if (ts.isEmpty()) {
                log.error("Pool " + this + ", created machine " + m + " from template " + template + ", but no pool templates match!");
                continue;
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Pool " + this + ", created machine " + m + " from template " + template + ", matching templates " + ts);
        }
        MachinePool machinePool = this;
        synchronized (machinePool) {
            this.detectedMachines = this.detectedMachines.added(result);
            this.matchedMachines = this.matchedMachines.added(result);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineSet claim(int count, ReusableMachineTemplate t) {
        this.init();
        LinkedHashSet<NodeMetadata> claiming = new LinkedHashSet<NodeMetadata>();
        while (claiming.size() < count) {
            MachineSet mm = this.ensureUnclaimed(count - claiming.size(), t);
            for (NodeMetadata m : mm) {
                MachinePool machinePool = this;
                synchronized (machinePool) {
                    if (claiming.size() < count && !this.claimedMachines.contains(m)) {
                        claiming.add(m);
                        this.claimedMachines = this.claimedMachines.added(new MachineSet(m));
                    }
                }
            }
        }
        MachineSet result = new MachineSet(claiming);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MachineSet claim(MachineSet set) {
        this.init();
        MachinePool machinePool = this;
        synchronized (machinePool) {
            MachineSet originalClaimed = this.claimedMachines;
            this.claimedMachines = this.claimedMachines.added(set);
            MachineSet newlyClaimed = this.claimedMachines.removed(originalClaimed);
            if (newlyClaimed.size() != set.size()) {
                this.claimedMachines = originalClaimed;
                MachineSet unavailable = set.removed(newlyClaimed);
                throw new IllegalArgumentException("Could not claim all requested machines; failed to claim " + unavailable);
            }
            return newlyClaimed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int unclaim(MachineSet set) {
        this.init();
        MachinePool machinePool = this;
        synchronized (machinePool) {
            MachineSet originalClaimed = this.claimedMachines;
            this.claimedMachines = this.claimedMachines.removed(set);
            return originalClaimed.size() - this.claimedMachines.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int destroy(final MachineSet set) {
        this.init();
        MachinePool machinePool = this;
        synchronized (machinePool) {
            this.detectedMachines = this.detectedMachines.removed(set);
            this.matchedMachines = this.matchedMachines.removed(set);
            this.claimedMachines = this.claimedMachines.removed(set);
        }
        Set destroyed = this.computeService.destroyNodesMatching((Predicate)new Predicate<NodeMetadata>(){

            public boolean apply(NodeMetadata input) {
                return set.contains(input);
            }
        });
        MachinePool machinePool2 = this;
        synchronized (machinePool2) {
            this.detectedMachines = this.detectedMachines.removed(set);
            this.matchedMachines = this.matchedMachines.removed(set);
            this.claimedMachines = this.claimedMachines.removed(set);
        }
        return destroyed.size();
    }
}

