/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds.networking;

import brooklyn.entity.Entity;
import brooklyn.location.geo.LocalhostExternalIpLoader;
import brooklyn.location.jclouds.BasicJcloudsLocationCustomizer;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsMachineLocation;
import brooklyn.location.jclouds.networking.SecurityGroupDefinition;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.net.Cidr;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jclouds.aws.AWSResponseException;
import org.jclouds.compute.ComputeService;
import org.jclouds.compute.domain.SecurityGroup;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.extensions.SecurityGroupExtension;
import org.jclouds.domain.Location;
import org.jclouds.net.domain.IpPermission;
import org.jclouds.net.domain.IpProtocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class JcloudsLocationSecurityGroupCustomizer
extends BasicJcloudsLocationCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsLocationSecurityGroupCustomizer.class);
    private static final LoadingCache<String, JcloudsLocationSecurityGroupCustomizer> CUSTOMISERS = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, JcloudsLocationSecurityGroupCustomizer>(){

        public JcloudsLocationSecurityGroupCustomizer load(String appContext) throws Exception {
            return new JcloudsLocationSecurityGroupCustomizer(appContext);
        }
    });
    private final Cache<Location, SecurityGroup> sharedGroupCache = CacheBuilder.newBuilder().build();
    private final Cache<String, SecurityGroup> uniqueGroupCache = CacheBuilder.newBuilder().build();
    private final String applicationId;
    private Supplier<Cidr> sshCidrSupplier;
    private Predicate<Exception> isExceptionRetryable = Predicates.alwaysFalse();

    protected JcloudsLocationSecurityGroupCustomizer(String applicationId) {
        this(applicationId, (Supplier<Cidr>)Suppliers.ofInstance((Object)new Cidr("0.0.0.0/0")));
    }

    protected JcloudsLocationSecurityGroupCustomizer(String applicationId, Supplier<Cidr> sshCidrSupplier) {
        this.applicationId = applicationId;
        this.sshCidrSupplier = sshCidrSupplier;
    }

    public static JcloudsLocationSecurityGroupCustomizer getInstance(String applicationId) {
        return (JcloudsLocationSecurityGroupCustomizer)CUSTOMISERS.getUnchecked((Object)applicationId);
    }

    public static JcloudsLocationSecurityGroupCustomizer getInstance(Entity entity) {
        return JcloudsLocationSecurityGroupCustomizer.getInstance(entity.getApplicationId());
    }

    public JcloudsLocationSecurityGroupCustomizer setRetryExceptionPredicate(Predicate<Exception> predicate) {
        this.isExceptionRetryable = (Predicate)Preconditions.checkNotNull(predicate, (Object)"predicate");
        return this;
    }

    public JcloudsLocationSecurityGroupCustomizer setSshCidrSupplier(Supplier<Cidr> cidrSupplier) {
        this.sshCidrSupplier = (Supplier)Preconditions.checkNotNull(cidrSupplier, (Object)"cidrSupplier");
        return this;
    }

    public JcloudsLocationSecurityGroupCustomizer addPermissionsToLocation(JcloudsMachineLocation location, IpPermission ... permissions) {
        this.addPermissionsToLocation(location, (Iterable<IpPermission>)ImmutableList.copyOf((Object[])permissions));
        return this;
    }

    public JcloudsLocationSecurityGroupCustomizer addPermissionsToLocation(JcloudsMachineLocation location, SecurityGroupDefinition securityGroupDefinition) {
        this.addPermissionsToLocation(location, securityGroupDefinition.getPermissions());
        return this;
    }

    public JcloudsLocationSecurityGroupCustomizer addPermissionsToLocation(JcloudsMachineLocation location, Iterable<IpPermission> permissions) {
        ComputeService computeService = location.getParent().getComputeService();
        String nodeId = location.getNode().getId();
        this.addPermissionsToLocation(permissions, nodeId, computeService);
        return this;
    }

    @VisibleForTesting
    void addPermissionsToLocation(Iterable<IpPermission> permissions, final String nodeId, ComputeService computeService) {
        SecurityGroup machineUniqueSecurityGroup;
        if (!computeService.getSecurityGroupExtension().isPresent()) {
            LOG.warn("Security group extension for {} absent; cannot update node {} with {}", new Object[]{computeService, nodeId, permissions});
            return;
        }
        final SecurityGroupExtension securityApi = (SecurityGroupExtension)computeService.getSecurityGroupExtension().get();
        Tasks.setBlockingDetails((String)("Loading unique security group for node: " + nodeId));
        try {
            machineUniqueSecurityGroup = (SecurityGroup)this.uniqueGroupCache.get((Object)nodeId, (Callable)new Callable<SecurityGroup>(){

                @Override
                public SecurityGroup call() throws Exception {
                    SecurityGroup sg = JcloudsLocationSecurityGroupCustomizer.this.getUniqueSecurityGroupForNodeCachingSharedGroupIfPreviouslyUnknown(nodeId, securityApi);
                    if (sg == null) {
                        throw new IllegalStateException("Failed to find machine-unique group on node: " + nodeId);
                    }
                    return sg;
                }
            });
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)new Exception(e.getCause()));
        }
        finally {
            Tasks.resetBlockingDetails();
        }
        for (IpPermission permission : permissions) {
            this.addPermission(permission, machineUniqueSecurityGroup, securityApi);
        }
    }

    private SecurityGroup getUniqueSecurityGroupForNodeCachingSharedGroupIfPreviouslyUnknown(String nodeId, SecurityGroupExtension securityApi) {
        SecurityGroup unique;
        Set groupsOnNode = securityApi.listSecurityGroupsForNode(nodeId);
        if (groupsOnNode.size() != 2) {
            LOG.warn("Expected to find two security groups on node {} in app {} (one shared, one unique). Found {}: {}", new Object[]{nodeId, this.applicationId, groupsOnNode.size(), groupsOnNode});
            return null;
        }
        String expectedSharedName = this.getNameForSharedSecurityGroup();
        Iterator it = groupsOnNode.iterator();
        SecurityGroup shared = (SecurityGroup)it.next();
        if (shared.getName().endsWith(expectedSharedName)) {
            unique = (SecurityGroup)it.next();
        } else {
            unique = shared;
            shared = (SecurityGroup)it.next();
        }
        if (!shared.getName().endsWith(expectedSharedName)) {
            LOG.warn("Couldn't determine which security group is shared between instances in app {}. Expected={}, found={}", new Object[]{this.applicationId, expectedSharedName, groupsOnNode});
            return null;
        }
        SecurityGroup old = this.sharedGroupCache.asMap().putIfAbsent(shared.getLocation(), shared);
        LOG.info("Loaded unique security group for node {} (in {}): {}", new Object[]{nodeId, this.applicationId, unique});
        if (old == null) {
            LOG.info("Proactively set shared group for app {} to: {}", (Object)this.applicationId, (Object)shared);
        }
        return unique;
    }

    @Override
    public void customize(JcloudsLocation location, ComputeService computeService, Template template) {
        if (!computeService.getSecurityGroupExtension().isPresent()) {
            LOG.warn("Security group extension for {} absent; cannot configure security groups in context: {}", (Object)computeService, (Object)this.applicationId);
        } else if (template.getLocation() == null) {
            LOG.warn("No location has been set on {}; cannot configure security groups in context: {}", (Object)template, (Object)this.applicationId);
        } else {
            LOG.info("Configuring security groups on location {} in context {}", (Object)location, (Object)this.applicationId);
            this.setSecurityGroupOnTemplate(location, template, (SecurityGroupExtension)computeService.getSecurityGroupExtension().get());
        }
    }

    private void setSecurityGroupOnTemplate(JcloudsLocation location, final Template template, final SecurityGroupExtension securityApi) {
        SecurityGroup shared;
        Tasks.setBlockingDetails((String)("Loading security group shared by instances in " + template.getLocation() + " in app " + this.applicationId));
        try {
            shared = (SecurityGroup)this.sharedGroupCache.get((Object)template.getLocation(), (Callable)new Callable<SecurityGroup>(){

                @Override
                public SecurityGroup call() throws Exception {
                    return JcloudsLocationSecurityGroupCustomizer.this.getOrCreateSharedSecurityGroup(template.getLocation(), securityApi);
                }
            });
        }
        catch (ExecutionException e) {
            throw Throwables.propagate((Throwable)new Exception(e.getCause()));
        }
        finally {
            Tasks.resetBlockingDetails();
        }
        Set originalGroups = template.getOptions().getGroups();
        template.getOptions().securityGroups(new String[]{shared.getName()});
        if (!originalGroups.isEmpty()) {
            LOG.info("Replaced configured security groups: configured={}, replaced with={}", (Object)originalGroups, (Object)template.getOptions().getGroups());
        } else {
            LOG.debug("Configured security groups at {} to: {}", (Object)location, (Object)template.getOptions().getGroups());
        }
    }

    private SecurityGroup getOrCreateSharedSecurityGroup(Location location, SecurityGroupExtension securityApi) {
        final String groupName = this.getNameForSharedSecurityGroup();
        Optional shared = Iterables.tryFind((Iterable)securityApi.listSecurityGroupsInLocation(location), (Predicate)new Predicate<SecurityGroup>(){

            public boolean apply(SecurityGroup input) {
                return input.getName().endsWith(groupName);
            }
        });
        if (shared.isPresent()) {
            LOG.info("Found existing shared security group in {} for app {}: {}", new Object[]{location, this.applicationId, groupName});
            return (SecurityGroup)shared.get();
        }
        LOG.info("Creating new shared security group in {} for app {}: {}", new Object[]{location, this.applicationId, groupName});
        return this.createBaseSecurityGroupInLocation(groupName, location, securityApi);
    }

    private SecurityGroup createBaseSecurityGroupInLocation(String groupName, Location location, SecurityGroupExtension securityApi) {
        SecurityGroup group = this.addSecurityGroupInLocation(groupName, location, securityApi);
        IpPermission.Builder allWithinGroup = IpPermission.builder().groupId(group.getProviderId()).fromPort(0).toPort(65535);
        this.addPermission(allWithinGroup.ipProtocol(IpProtocol.TCP).build(), group, securityApi);
        this.addPermission(allWithinGroup.ipProtocol(IpProtocol.UDP).build(), group, securityApi);
        this.addPermission(allWithinGroup.ipProtocol(IpProtocol.ICMP).fromPort(-1).toPort(-1).build(), group, securityApi);
        IpPermission sshPermission = IpPermission.builder().fromPort(22).toPort(22).ipProtocol(IpProtocol.TCP).cidrBlock(this.getBrooklynCidrBlock()).build();
        this.addPermission(sshPermission, group, securityApi);
        return group;
    }

    protected SecurityGroup addSecurityGroupInLocation(final String groupName, final Location location, final SecurityGroupExtension securityApi) {
        LOG.debug("Creating security group {} in {}", (Object)groupName, (Object)location);
        Callable<SecurityGroup> callable = new Callable<SecurityGroup>(){

            @Override
            public SecurityGroup call() throws Exception {
                return securityApi.createSecurityGroup(groupName, location);
            }
        };
        return this.runOperationWithRetry(callable);
    }

    protected SecurityGroup addPermission(final IpPermission permission, final SecurityGroup group, final SecurityGroupExtension securityApi) {
        LOG.debug("Adding permission to security group {}: {}", (Object)group.getName(), (Object)permission);
        Callable<SecurityGroup> callable = new Callable<SecurityGroup>(){

            @Override
            public SecurityGroup call() throws Exception {
                return securityApi.addIpPermission(permission, group);
            }
        };
        return this.runOperationWithRetry(callable);
    }

    public String getBrooklynCidrBlock() {
        return ((Cidr)this.sshCidrSupplier.get()).toString();
    }

    @VisibleForTesting
    String getNameForSharedSecurityGroup() {
        return "brooklyn-" + this.applicationId.toLowerCase() + "-shared";
    }

    @VisibleForTesting
    void clearSecurityGroupCaches() {
        LOG.info("Clearing security group caches");
        this.sharedGroupCache.invalidateAll();
        this.uniqueGroupCache.invalidateAll();
    }

    protected <T> T runOperationWithRetry(Callable<T> operation) {
        int backoff = 64;
        Exception lastException = null;
        for (int retries = 0; retries < 100; ++retries) {
            try {
                return operation.call();
            }
            catch (Exception e) {
                lastException = e;
                if (!this.isExceptionRetryable.apply((Object)e)) break;
                LOG.debug("Attempt #{} failed to add security group: {}", (Object)(retries + 1), (Object)e.getMessage());
                try {
                    Thread.sleep(backoff);
                }
                catch (InterruptedException e1) {
                    throw Exceptions.propagate((Throwable)e1);
                }
                backoff <<= 1;
                continue;
            }
        }
        throw new RuntimeException("Unable to add security group rule; repeated errors from provider", lastException);
    }

    public static Predicate<Exception> newAwsExceptionRetryPredicate() {
        return new AwsExceptionRetryPredicate();
    }

    private static class LocalhostExternalIpCidrSupplier
    implements Supplier<Cidr> {
        private volatile Cidr cidr;

        private LocalhostExternalIpCidrSupplier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Cidr get() {
            Cidr local = this.cidr;
            if (local == null) {
                LocalhostExternalIpCidrSupplier localhostExternalIpCidrSupplier = this;
                synchronized (localhostExternalIpCidrSupplier) {
                    local = this.cidr;
                    if (local == null) {
                        String externalIp = LocalhostExternalIpLoader.getLocalhostIpWithin((Duration)Duration.seconds((Number)5));
                        this.cidr = local = new Cidr(externalIp + "/32");
                    }
                }
            }
            return local;
        }
    }

    private static class AwsExceptionRetryPredicate
    implements Predicate<Exception> {
        private static final Set<String> AWS_ERRORS_TO_RETRY = ImmutableSet.of((Object)"InvalidGroup.InUse", (Object)"DependencyViolation", (Object)"RequestLimitExceeded");

        private AwsExceptionRetryPredicate() {
        }

        public boolean apply(Exception input) {
            AWSResponseException exception = (AWSResponseException)Exceptions.getFirstThrowableOfType((Throwable)input, AWSResponseException.class);
            if (exception != null) {
                String code = exception.getError().getCode();
                return AWS_ERRORS_TO_RETRY.contains(code);
            }
            return false;
        }
    }
}

