/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.location.jclouds;

import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.location.jclouds.JcloudsLocation;
import brooklyn.location.jclouds.JcloudsMachineLocation;
import brooklyn.util.JavaGroovyEquivalents;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.net.Networking;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.net.HostAndPort;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.Set;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcloudsWinRmMachineLocation
extends WinRmMachineLocation
implements JcloudsMachineLocation {
    private static final Logger LOG = LoggerFactory.getLogger(JcloudsWinRmMachineLocation.class);
    @SetFromFlag
    JcloudsLocation jcloudsParent;
    @SetFromFlag
    NodeMetadata node;
    @SetFromFlag
    Template template;

    public String toVerboseString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId()).add("name", (Object)this.getDisplayName()).add("user", (Object)this.getUser()).add("address", (Object)this.getAddress()).add("port", this.getPort()).add("node", (Object)this.getNode()).add("jcloudsId", (Object)this.getJcloudsId()).add("privateAddresses", (Object)this.node.getPrivateAddresses()).add("publicAddresses", (Object)this.node.getPublicAddresses()).add("parentLocation", (Object)this.getParent()).add("osDetails", (Object)this.getOsDetails()).toString();
    }

    @Override
    public int getPort() {
        return (Integer)this.getConfig(WINRM_PORT);
    }

    @Override
    public NodeMetadata getNode() {
        return this.node;
    }

    @Override
    public Template getTemplate() {
        return this.template;
    }

    @Override
    public JcloudsLocation getParent() {
        return this.jcloudsParent;
    }

    public String getHostname() {
        InetAddress address = this.getAddress();
        return address != null ? address.getHostAddress() : null;
    }

    public Set<String> getPublicAddresses() {
        return this.node.getPublicAddresses();
    }

    public Set<String> getPrivateAddresses() {
        return this.node.getPrivateAddresses();
    }

    @Override
    public String getSubnetHostname() {
        return this.getHostname();
    }

    public String getSubnetIp() {
        Optional<String> privateAddress = this.getPrivateAddress();
        if (privateAddress.isPresent()) {
            return (String)privateAddress.get();
        }
        String hostname = this.jcloudsParent.getPublicHostname(this.node, (Optional<HostAndPort>)Optional.absent(), this.config().getBag());
        if (hostname != null && !Networking.isValidIp4((String)hostname)) {
            try {
                return InetAddress.getByName(hostname).getHostAddress();
            }
            catch (UnknownHostException e) {
                LOG.debug("Cannot resolve IP for hostname {} of machine {} (so returning hostname): {}", new Object[]{hostname, this, e});
            }
        }
        return hostname;
    }

    protected Optional<String> getPrivateAddress() {
        if (JavaGroovyEquivalents.groovyTruth((Collection)this.node.getPrivateAddresses())) {
            for (String p : this.node.getPrivateAddresses()) {
                if (Networking.isLocalOnly((String)p)) continue;
                return Optional.of((Object)p);
            }
        }
        return Optional.absent();
    }

    @Override
    public String getJcloudsId() {
        return this.node.getId();
    }
}

